/*
 *
 *  * Copyright 2015 Skymind,Inc.
 *  *
 *  *    Licensed under the Apache License, Version 2.0 (the "License");
 *  *    you may not use this file except in compliance with the License.
 *  *    You may obtain a copy of the License at
 *  *
 *  *        http://www.apache.org/licenses/LICENSE-2.0
 *  *
 *  *    Unless required by applicable law or agreed to in writing, software
 *  *    distributed under the License is distributed on an "AS IS" BASIS,
 *  *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  *    See the License for the specific language governing permissions and
 *  *    limitations under the License.
 *
 */

/** @jsx React.DOM */
var React = require('react');
var Dropzone = require('../');

var DropzoneDemo = React.createClass({
    getInitialState: function () {
      return {
        files: []
      };
    },

    onDrop: function (files) {
      console.log('Received files: ', files);
      this.setState({
        files: files
      });
    },

    showFiles: function () {
      if (this.state.files.length <= 0) {
        return '';
      }
        var files = this.state.files;

      return (
        <div>
          <h3>Dropped files: </h3>
          <ul>
            {[].map.call(files, function (f, i) {
              return <li key={i}>{f.name + ' : ' + f.size + ' bytes.'}</li>
            })}
          </ul>
        </div>
        );
    },

    render: function () {
      var styling = {
        padding: 30
      };

      return (
          <div>
            <Dropzone onDrop={this.onDrop} size={150} >
              <div style={styling}>Try dropping some files here, or click to select files to upload.</div>
            </Dropzone>
            {this.showFiles()}
          </div>
      );
    }
});

React.render(<DropzoneDemo />, document.body);

module.exports = DropzoneDemo;