/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.uploads;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileResource.class);
    private String filePath = System.getProperty("java.io.tmpdir");

    public FileResource(String filePath) {
        this.filePath = filePath;
    }

    @POST
    @Path(value="/upload")
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public Response uploadFile(@FormDataParam(value="0") InputStream uploadedInputStream, @FormDataParam(value="0") FormDataContentDisposition fileDetail) throws IOException {
        String uploadedFileLocation = new File(this.filePath, fileDetail.getFileName()).getAbsolutePath();
        LOGGER.info(uploadedFileLocation);
        this.writeToFile(uploadedInputStream, uploadedFileLocation);
        String output = "{\"value\": \"File uploaded to : " + uploadedFileLocation + "\"}";
        return Response.ok((Object)output).build();
    }

    private void writeToFile(InputStream uploadedInputStream, String uploadedFileLocation) throws IOException {
        int read;
        int BUFFER_LENGTH = 1024;
        byte[] buffer = new byte[1024];
        FileOutputStream out = new FileOutputStream(new File(uploadedFileLocation));
        while ((read = uploadedInputStream.read(buffer)) != -1) {
            ((OutputStream)out).write(buffer, 0, read);
        }
        out.flush();
        ((OutputStream)out).close();
        this.handleUpload(new File(uploadedFileLocation));
    }

    public abstract void handleUpload(File var1);
}

