/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.storage.sqlite;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import org.deeplearning4j.api.storage.Persistable;
import org.deeplearning4j.api.storage.StatsStorage;
import org.deeplearning4j.api.storage.StatsStorageEvent;
import org.deeplearning4j.api.storage.StatsStorageListener;
import org.deeplearning4j.api.storage.StorageMetaData;
import org.nd4j.linalg.primitives.Pair;

public class J7FileStatsStorage
implements StatsStorage {
    private static final String TABLE_NAME_METADATA = "StorageMetaData";
    private static final String TABLE_NAME_STATIC_INFO = "StaticInfo";
    private static final String TABLE_NAME_UPDATES = "Updates";
    private static final String INSERT_META_SQL = "INSERT OR REPLACE INTO StorageMetaData (SessionID, TypeID, ObjectClass, ObjectBytes) VALUES ( ?, ?, ?, ? );";
    private static final String INSERT_STATIC_SQL = "INSERT OR REPLACE INTO StaticInfo (SessionID, TypeID, WorkerID, ObjectClass, ObjectBytes) VALUES ( ?, ?, ?, ?, ? );";
    private static final String INSERT_UPDATE_SQL = "INSERT OR REPLACE INTO Updates (SessionID, TypeID, WorkerID, Timestamp, ObjectClass, ObjectBytes) VALUES ( ?, ?, ?, ?, ?, ? );";
    private final File file;
    private final Connection connection;
    private List<StatsStorageListener> listeners = new ArrayList<StatsStorageListener>();

    public J7FileStatsStorage(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        this.file = file;
        try {
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + file.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException("Error ninializing J7FileStatsStorage instance", e);
        }
        try {
            this.initializeTables();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void initializeTables() throws SQLException {
        DatabaseMetaData meta = this.connection.getMetaData();
        ResultSet rs = meta.getTables(null, null, "%", null);
        boolean hasStorageMetaDataTable = false;
        boolean hasStaticInfoTable = false;
        boolean hasUpdatesTable = false;
        while (rs.next()) {
            String name = rs.getString(3);
            if (TABLE_NAME_METADATA.equals(name)) {
                hasStorageMetaDataTable = true;
                continue;
            }
            if (TABLE_NAME_STATIC_INFO.equals(name)) {
                hasStaticInfoTable = true;
                continue;
            }
            if (!TABLE_NAME_UPDATES.equals(name)) continue;
            hasUpdatesTable = true;
        }
        Statement statement = this.connection.createStatement();
        if (!hasStorageMetaDataTable) {
            statement.executeUpdate("CREATE TABLE StorageMetaData (SessionID TEXT NOT NULL, TypeID TEXT NOT NULL, ObjectClass TEXT NOT NULL, ObjectBytes BLOB NOT NULL, PRIMARY KEY ( SessionID, TypeID ));");
        }
        if (!hasStaticInfoTable) {
            statement.executeUpdate("CREATE TABLE StaticInfo (SessionID TEXT NOT NULL, TypeID TEXT NOT NULL, WorkerID TEXT NOT NULL, ObjectClass TEXT NOT NULL, ObjectBytes BLOB NOT NULL, PRIMARY KEY ( SessionID, TypeID, WorkerID ));");
        }
        if (!hasUpdatesTable) {
            statement.executeUpdate("CREATE TABLE Updates (SessionID TEXT NOT NULL, TypeID TEXT NOT NULL, WorkerID TEXT NOT NULL, Timestamp INTEGER NOT NULL, ObjectClass TEXT NOT NULL, ObjectBytes BLOB NOT NULL, PRIMARY KEY ( SessionID, TypeID, WorkerID, Timestamp ));");
        }
        statement.close();
    }

    /*
     * Exception decompiling
     */
    private static Pair<String, byte[]> serializeForDB(Object object) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T deserialize(byte[] bytes) {
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            Object object = ois.readObject();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T queryAndGet(String sql, int columnIndex) {
        try (Statement statement = this.connection.createStatement();){
            ResultSet rs = statement.executeQuery(sql);
            if (!rs.next()) {
                T t = null;
                return t;
            }
            byte[] bytes = rs.getBytes(columnIndex);
            T t = J7FileStatsStorage.deserialize(bytes);
            return t;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> selectDistinct(String columnName, boolean queryMeta, boolean queryStatic, boolean queryUpdates, String conditionColumn, String conditionValue) {
        HashSet<String> unique = new HashSet<String>();
        try (Statement statement = this.connection.createStatement();){
            if (queryMeta) {
                this.queryHelper(statement, this.querySqlHelper(columnName, TABLE_NAME_METADATA, conditionColumn, conditionValue), unique);
            }
            if (queryStatic) {
                this.queryHelper(statement, this.querySqlHelper(columnName, TABLE_NAME_STATIC_INFO, conditionColumn, conditionValue), unique);
            }
            if (queryUpdates) {
                this.queryHelper(statement, this.querySqlHelper(columnName, TABLE_NAME_UPDATES, conditionColumn, conditionValue), unique);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return new ArrayList<String>(unique);
    }

    private String querySqlHelper(String columnName, String table, String conditionColumn, String conditionValue) {
        String unique = "SELECT DISTINCT " + columnName + " FROM " + table;
        if (conditionColumn != null) {
            unique = unique + " WHERE " + conditionColumn + " = '" + conditionValue + "'";
        }
        unique = unique + ";";
        return unique;
    }

    private void queryHelper(Statement statement, String q, Set<String> unique) throws SQLException {
        ResultSet rs = statement.executeQuery(q);
        while (rs.next()) {
            String str = rs.getString(1);
            unique.add(str);
        }
    }

    protected List<StatsStorageEvent> checkStorageEvents(Persistable p) {
        if (this.listeners.isEmpty()) {
            return null;
        }
        StatsStorageEvent newSID = null;
        StatsStorageEvent newTID = null;
        StatsStorageEvent newWID = null;
        String sid = p.getSessionID();
        String tid = p.getTypeID();
        String wid = p.getWorkerID();
        boolean isNewSID = false;
        boolean isNewTID = false;
        boolean isNewWID = false;
        if (!this.listSessionIDs().contains(sid)) {
            isNewSID = true;
            isNewTID = true;
            isNewWID = true;
        }
        if (!isNewTID && !this.listTypeIDsForSession(sid).contains(tid)) {
            isNewTID = true;
        }
        if (!isNewWID && !this.listWorkerIDsForSessionAndType(sid, tid).contains(wid)) {
            isNewWID = true;
        }
        if (isNewSID) {
            newSID = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.NewSessionID, p.getSessionID(), p.getTypeID(), p.getWorkerID(), p.getTimeStamp());
        }
        if (isNewTID) {
            newTID = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.NewTypeID, p.getSessionID(), p.getTypeID(), p.getWorkerID(), p.getTimeStamp());
        }
        if (isNewWID) {
            newWID = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.NewWorkerID, p.getSessionID(), p.getTypeID(), p.getWorkerID(), p.getTimeStamp());
        }
        if (!(isNewSID || isNewTID || isNewWID)) {
            return null;
        }
        ArrayList<StatsStorageEvent> sses = new ArrayList<StatsStorageEvent>(3);
        if (newSID != null) {
            sses.add(newSID);
        }
        if (newTID != null) {
            sses.add(newTID);
        }
        if (newWID != null) {
            sses.add(newWID);
        }
        return sses;
    }

    public void putStorageMetaData(StorageMetaData storageMetaData) {
        this.putStorageMetaData(Collections.singletonList(storageMetaData));
    }

    public void putStorageMetaData(Collection<? extends StorageMetaData> collection) {
        List<StatsStorageEvent> sses = null;
        try {
            PreparedStatement ps = this.connection.prepareStatement(INSERT_META_SQL);
            for (StorageMetaData storageMetaData : collection) {
                List<StatsStorageEvent> ssesTemp = this.checkStorageEvents((Persistable)storageMetaData);
                if (ssesTemp != null) {
                    if (sses == null) {
                        sses = ssesTemp;
                    } else {
                        sses.addAll(ssesTemp);
                    }
                }
                if (!this.listeners.isEmpty()) {
                    StatsStorageEvent sse = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.PostMetaData, storageMetaData.getSessionID(), storageMetaData.getTypeID(), storageMetaData.getWorkerID(), storageMetaData.getTimeStamp());
                    if (sses == null) {
                        sses = new ArrayList<StatsStorageEvent>();
                    }
                    sses.add(sse);
                }
                Pair<String, byte[]> p = J7FileStatsStorage.serializeForDB(storageMetaData);
                ps.setString(1, storageMetaData.getSessionID());
                ps.setString(2, storageMetaData.getTypeID());
                ps.setString(3, (String)p.getFirst());
                ps.setObject(4, p.getSecond());
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.notifyListeners(sses);
    }

    public void putStaticInfo(Persistable staticInfo) {
        this.putStaticInfo(Collections.singletonList(staticInfo));
    }

    public void putStaticInfo(Collection<? extends Persistable> collection) {
        List<StatsStorageEvent> sses = null;
        try {
            PreparedStatement ps = this.connection.prepareStatement(INSERT_STATIC_SQL);
            for (Persistable persistable : collection) {
                List<StatsStorageEvent> ssesTemp = this.checkStorageEvents(persistable);
                if (ssesTemp != null) {
                    if (sses == null) {
                        sses = ssesTemp;
                    } else {
                        sses.addAll(ssesTemp);
                    }
                }
                if (!this.listeners.isEmpty()) {
                    StatsStorageEvent sse = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.PostStaticInfo, persistable.getSessionID(), persistable.getTypeID(), persistable.getWorkerID(), persistable.getTimeStamp());
                    if (sses == null) {
                        sses = new ArrayList<StatsStorageEvent>();
                    }
                    sses.add(sse);
                }
                Pair<String, byte[]> pair = J7FileStatsStorage.serializeForDB(persistable);
                ps.setString(1, persistable.getSessionID());
                ps.setString(2, persistable.getTypeID());
                ps.setString(3, persistable.getWorkerID());
                ps.setString(4, (String)pair.getFirst());
                ps.setBytes(5, (byte[])pair.getSecond());
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.notifyListeners(sses);
    }

    public void putUpdate(Persistable update) {
        this.putUpdate(Collections.singletonList(update));
    }

    public void putUpdate(Collection<? extends Persistable> collection) {
        List<StatsStorageEvent> sses = null;
        try {
            PreparedStatement ps = this.connection.prepareStatement(INSERT_UPDATE_SQL);
            for (Persistable persistable : collection) {
                List<StatsStorageEvent> ssesTemp = this.checkStorageEvents(persistable);
                if (ssesTemp != null) {
                    if (sses == null) {
                        sses = ssesTemp;
                    } else {
                        sses.addAll(ssesTemp);
                    }
                }
                if (!this.listeners.isEmpty()) {
                    StatsStorageEvent sse = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.PostUpdate, persistable.getSessionID(), persistable.getTypeID(), persistable.getWorkerID(), persistable.getTimeStamp());
                    if (sses == null) {
                        sses = new ArrayList<StatsStorageEvent>();
                    }
                    sses.add(sse);
                }
                Pair<String, byte[]> pair = J7FileStatsStorage.serializeForDB(persistable);
                ps.setString(1, persistable.getSessionID());
                ps.setString(2, persistable.getTypeID());
                ps.setString(3, persistable.getWorkerID());
                ps.setLong(4, persistable.getTimeStamp());
                ps.setString(5, (String)pair.getFirst());
                ps.setObject(6, pair.getSecond());
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.notifyListeners(sses);
    }

    public void close() throws IOException {
        try {
            this.connection.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public boolean isClosed() {
        try {
            return this.connection.isClosed();
        }
        catch (Exception e) {
            return true;
        }
    }

    public List<String> listSessionIDs() {
        return this.selectDistinct("SessionID", true, true, false, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sessionExists(String sessionID) {
        String existsMetaSQL = "SELECT 1 FROM StorageMetaData WHERE SessionID = '" + sessionID + "';";
        String existsStaticSQL = "SELECT 1 FROM StaticInfo WHERE SessionID = '" + sessionID + "';";
        try (Statement statement = this.connection.createStatement();){
            ResultSet rs = statement.executeQuery(existsMetaSQL);
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            rs = statement.executeQuery(existsStaticSQL);
            boolean bl = rs.next();
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Persistable getStaticInfo(String sessionID, String typeID, String workerID) {
        String selectStaticSQL = "SELECT ObjectBytes FROM StaticInfo WHERE SessionID = '" + sessionID + "' AND TypeID = '" + typeID + "' AND WorkerID = '" + workerID + "';";
        return (Persistable)this.queryAndGet(selectStaticSQL, 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Persistable> getAllStaticInfos(String sessionID, String typeID) {
        String selectStaticSQL = "SELECT * FROM StaticInfo WHERE SessionID = '" + sessionID + "' AND TypeID = '" + typeID + "';";
        try (Statement statement = this.connection.createStatement();){
            ResultSet rs = statement.executeQuery(selectStaticSQL);
            ArrayList<Persistable> out = new ArrayList<Persistable>();
            while (rs.next()) {
                byte[] bytes = rs.getBytes(5);
                out.add((Persistable)J7FileStatsStorage.deserialize(bytes));
            }
            ArrayList<Persistable> arrayList = out;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> listTypeIDsForSession(String sessionID) {
        return this.selectDistinct("TypeID", true, true, true, "SessionID", sessionID);
    }

    public List<String> listWorkerIDsForSession(String sessionID) {
        return this.selectDistinct("WorkerID", false, true, true, "SessionID", sessionID);
    }

    public List<String> listWorkerIDsForSessionAndType(String sessionID, String typeID) {
        String uniqueStatic = "SELECT DISTINCT WorkerID FROM StaticInfo WHERE SessionID = '" + sessionID + "' AND TypeID = '" + typeID + "';";
        String uniqueUpdates = "SELECT DISTINCT WorkerID FROM Updates WHERE SessionID = '" + sessionID + "' AND TypeID = '" + typeID + "';";
        HashSet<String> unique = new HashSet<String>();
        try (Statement statement = this.connection.createStatement();){
            String str;
            ResultSet rs = statement.executeQuery(uniqueStatic);
            while (rs.next()) {
                str = rs.getString(1);
                unique.add(str);
            }
            rs = statement.executeQuery(uniqueUpdates);
            while (rs.next()) {
                str = rs.getString(1);
                unique.add(str);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return new ArrayList<String>(unique);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getNumUpdateRecordsFor(String sessionID) {
        String sql = "SELECT COUNT(*) FROM Updates WHERE SessionID = '" + sessionID + "';";
        try (Statement statement = this.connection.createStatement();){
            int n = statement.executeQuery(sql).getInt(1);
            return n;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getNumUpdateRecordsFor(String sessionID, String typeID, String workerID) {
        String sql = "SELECT COUNT(*) FROM Updates WHERE SessionID = '" + sessionID + "' AND TypeID = '" + typeID + "' AND WorkerID = '" + workerID + "';";
        try (Statement statement = this.connection.createStatement();){
            int n = statement.executeQuery(sql).getInt(1);
            return n;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Persistable getLatestUpdate(String sessionID, String typeID, String workerID) {
        String sql = "SELECT ObjectBytes FROM Updates WHERE SessionID = '" + sessionID + "' AND TypeID = '" + typeID + "' AND WorkerID = '" + workerID + "' ORDER BY Timestamp DESC LIMIT 1;";
        return (Persistable)this.queryAndGet(sql, 1);
    }

    public Persistable getUpdate(String sessionID, String typeId, String workerID, long timestamp) {
        String sql = "SELECT ObjectBytes FROM Updates WHERE SessionID = '" + sessionID + "' AND TypeID = '" + typeId + "' AND WorkerID = '" + workerID + "' AND Timestamp = '" + timestamp + "';";
        return (Persistable)this.queryAndGet(sql, 1);
    }

    public List<Persistable> getLatestUpdateAllWorkers(String sessionID, String typeID) {
        String sql = "SELECT workerId, MAX(Timestamp) FROM Updates WHERE SessionID ='" + sessionID + "' AND TypeID = '" + typeID + "' GROUP BY workerId";
        HashMap<String, Long> m = new HashMap<String, Long>();
        try {
            Statement statement = this.connection.createStatement();
            Object object = null;
            try {
                ResultSet rs = statement.executeQuery(sql);
                while (rs.next()) {
                    String wid = rs.getString(1);
                    long ts = rs.getLong(2);
                    m.put(wid, ts);
                }
            }
            catch (Throwable rs) {
                object = rs;
                throw rs;
            }
            finally {
                if (statement != null) {
                    if (object != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable rs) {
                            ((Throwable)object).addSuppressed(rs);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        ArrayList<Persistable> out = new ArrayList<Persistable>();
        for (String s : m.keySet()) {
            out.add(this.getUpdate(sessionID, typeID, s, (Long)m.get(s)));
        }
        return out;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Persistable> getAllUpdatesAfter(String sessionID, String typeID, String workerID, long timestamp) {
        String sql = "SELECT * FROM Updates WHERE SessionID = '" + sessionID + "' AND TypeID = '" + typeID + "' AND workerId = '" + workerID + "' AND Timestamp > " + timestamp + ";";
        try (Statement statement = this.connection.createStatement();){
            ResultSet rs = statement.executeQuery(sql);
            ArrayList<Persistable> out = new ArrayList<Persistable>();
            while (rs.next()) {
                byte[] bytes = rs.getBytes(6);
                out.add((Persistable)J7FileStatsStorage.deserialize(bytes));
            }
            ArrayList<Persistable> arrayList = out;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Persistable> getAllUpdatesAfter(String sessionID, String typeID, long timestamp) {
        String sql = "SELECT ObjectBytes FROM Updates WHERE SessionID = '" + sessionID + "'  AND TypeID = '" + typeID + "' AND Timestamp > " + timestamp + ";";
        return this.queryUpdates(sql);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long[] getAllUpdateTimes(String sessionID, String typeID, String workerID) {
        String sql = "SELECT Timestamp FROM Updates WHERE SessionID = '" + sessionID + "'  AND TypeID = '" + typeID + "' AND workerID = '" + workerID + "';";
        try (Statement statement = this.connection.createStatement();){
            ResultSet rs = statement.executeQuery(sql);
            LongArrayList list = new LongArrayList();
            while (rs.next()) {
                list.add(rs.getLong(1));
            }
            long[] lArray = list.toLongArray();
            return lArray;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Persistable> getUpdates(String sessionID, String typeID, String workerID, long[] timestamps) {
        if (timestamps == null || timestamps.length == 0) {
            return Collections.emptyList();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ObjectBytes FROM ").append(TABLE_NAME_UPDATES).append(" WHERE SessionID = '").append(sessionID).append("' AND TypeID = '").append(typeID).append("' AND workerID='").append(workerID).append("'  AND Timestamp IN (");
        for (int i = 0; i < timestamps.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(timestamps[i]);
        }
        sb.append(");");
        String sql = sb.toString();
        return this.queryUpdates(sql);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Persistable> queryUpdates(String sql) {
        try (Statement statement = this.connection.createStatement();){
            ResultSet rs = statement.executeQuery(sql);
            ArrayList<Persistable> out = new ArrayList<Persistable>();
            while (rs.next()) {
                byte[] bytes = rs.getBytes(1);
                out.add((Persistable)J7FileStatsStorage.deserialize(bytes));
            }
            ArrayList<Persistable> arrayList = out;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public StorageMetaData getStorageMetaData(String sessionID, String typeID) {
        String sql = "SELECT ObjectBytes FROM StorageMetaData WHERE SessionID = '" + sessionID + "' AND TypeID = '" + typeID + "' LIMIT 1;";
        return (StorageMetaData)this.queryAndGet(sql, 1);
    }

    public void registerStatsStorageListener(StatsStorageListener listener) {
        this.listeners.add(listener);
    }

    public void deregisterStatsStorageListener(StatsStorageListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public List<StatsStorageListener> getListeners() {
        return new ArrayList<StatsStorageListener>(this.listeners);
    }

    public String toString() {
        return "J7FileStatsStorage(file=" + this.file + ")";
    }

    protected void notifyListeners(List<StatsStorageEvent> sses) {
        if (sses == null || sses.isEmpty() || this.listeners.isEmpty()) {
            return;
        }
        for (StatsStorageListener l : this.listeners) {
            for (StatsStorageEvent e : sses) {
                l.notify(e);
            }
        }
    }
}

