/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.stats.sbe;

public enum MemoryType {
    JvmCurrent(0),
    JvmMax(1),
    OffHeapCurrent(2),
    OffHeapMax(3),
    DeviceCurrent(4),
    DeviceMax(5),
    NULL_VAL(255);

    private final short value;

    private MemoryType(short value) {
        this.value = value;
    }

    public short value() {
        return this.value;
    }

    public static MemoryType get(short value) {
        switch (value) {
            case 0: {
                return JvmCurrent;
            }
            case 1: {
                return JvmMax;
            }
            case 2: {
                return OffHeapCurrent;
            }
            case 3: {
                return OffHeapMax;
            }
            case 4: {
                return DeviceCurrent;
            }
            case 5: {
                return DeviceMax;
            }
        }
        if (255 == value) {
            return NULL_VAL;
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

