/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.model.stats.sbe;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.deeplearning4j.ui.model.stats.sbe.VarDataUTF8Decoder;

public class VarDataUTF8Encoder {
    public static final int ENCODED_LENGTH = -1;
    private MutableDirectBuffer buffer;
    private int offset;

    public VarDataUTF8Encoder wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        return this;
    }

    public int encodedLength() {
        return -1;
    }

    public static long lengthNullValue() {
        return 0xFFFFFFFEL;
    }

    public static long lengthMinValue() {
        return 0L;
    }

    public static long lengthMaxValue() {
        return 0x40000000L;
    }

    public VarDataUTF8Encoder length(long value) {
        this.buffer.putInt(this.offset + 0, (int)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static short varDataNullValue() {
        return 255;
    }

    public static short varDataMinValue() {
        return 0;
    }

    public static short varDataMaxValue() {
        return 254;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        VarDataUTF8Decoder writer = new VarDataUTF8Decoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset);
        return writer.appendTo(builder);
    }
}

