/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.model.stats.sbe;

import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;

public class UpdateFieldsPresentEncoder {
    public static final int ENCODED_LENGTH = 4;
    private MutableDirectBuffer buffer;
    private int offset;

    public UpdateFieldsPresentEncoder wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        return this;
    }

    public int encodedLength() {
        return 4;
    }

    public UpdateFieldsPresentEncoder clear() {
        this.buffer.putInt(this.offset, 0, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder score(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 1 : bits & 0xFFFFFFFE;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder memoryUse(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 2 : bits & 0xFFFFFFFD;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder performance(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 4 : bits & 0xFFFFFFFB;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder garbageCollection(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 8 : bits & 0xFFFFFFF7;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder histogramParameters(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 0x10 : bits & 0xFFFFFFEF;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder histogramGradients(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 0x20 : bits & 0xFFFFFFDF;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder histogramUpdates(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 0x40 : bits & 0xFFFFFFBF;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder histogramActivations(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 0x80 : bits & 0xFFFFFF7F;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder meanParameters(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 0x100 : bits & 0xFFFFFEFF;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder meanGradients(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 0x200 : bits & 0xFFFFFDFF;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder meanUpdates(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 0x400 : bits & 0xFFFFFBFF;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder meanActivations(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 0x800 : bits & 0xFFFFF7FF;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder stdevParameters(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 0x1000 : bits & 0xFFFFEFFF;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder stdevGradients(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 0x2000 : bits & 0xFFFFDFFF;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder stdevUpdates(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 0x4000 : bits & 0xFFFFBFFF;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder stdevActivations(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 0x8000 : bits & 0xFFFF7FFF;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder meanMagnitudeParameters(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 0x10000 : bits & 0xFFFEFFFF;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder meanMagnitudeGradients(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 0x20000 : bits & 0xFFFDFFFF;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder meanMagnitudeUpdates(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 0x40000 : bits & 0xFFFBFFFF;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder meanMagnitudeActivations(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 0x80000 : bits & 0xFFF7FFFF;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder learningRatesPresent(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 0x100000 : bits & 0xFFEFFFFF;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder dataSetMetaDataPresent(boolean value) {
        int bits = this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
        bits = value ? bits | 0x200000 : bits & 0xFFDFFFFF;
        this.buffer.putInt(this.offset, bits, ByteOrder.LITTLE_ENDIAN);
        return this;
    }
}

