/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.model.stats.sbe;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.deeplearning4j.ui.model.stats.sbe.GroupSizeEncodingDecoder;
import org.deeplearning4j.ui.model.stats.sbe.MemoryType;
import org.deeplearning4j.ui.model.stats.sbe.MetaAttribute;
import org.deeplearning4j.ui.model.stats.sbe.StatsType;
import org.deeplearning4j.ui.model.stats.sbe.SummaryType;
import org.deeplearning4j.ui.model.stats.sbe.UpdateFieldsPresentDecoder;

public class UpdateDecoder {
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 2;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    private final UpdateDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;
    private final UpdateFieldsPresentDecoder fieldsPresent = new UpdateFieldsPresentDecoder();
    private final MemoryUseDecoder memoryUse = new MemoryUseDecoder();
    private final PerformanceDecoder performance = new PerformanceDecoder();
    private final GcStatsDecoder gcStats = new GcStatsDecoder();
    private final ParamNamesDecoder paramNames = new ParamNamesDecoder();
    private final LayerNamesDecoder layerNames = new LayerNamesDecoder();
    private final PerParameterStatsDecoder perParameterStats = new PerParameterStatsDecoder();
    private final DataSetMetaDataBytesDecoder dataSetMetaDataBytes = new DataSetMetaDataBytesDecoder();

    public int sbeBlockLength() {
        return 32;
    }

    public int sbeTemplateId() {
        return 2;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public int offset() {
        return this.offset;
    }

    public UpdateDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        this.buffer = buffer;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int timeId() {
        return 1;
    }

    public static String timeMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static long timeNullValue() {
        return Long.MIN_VALUE;
    }

    public static long timeMinValue() {
        return -9223372036854775807L;
    }

    public static long timeMaxValue() {
        return Long.MAX_VALUE;
    }

    public long time() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int deltaTimeId() {
        return 2;
    }

    public static String deltaTimeMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int deltaTimeNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int deltaTimeMinValue() {
        return -2147483647;
    }

    public static int deltaTimeMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int deltaTime() {
        return this.buffer.getInt(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int iterationCountId() {
        return 3;
    }

    public static String iterationCountMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int iterationCountNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int iterationCountMinValue() {
        return -2147483647;
    }

    public static int iterationCountMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int iterationCount() {
        return this.buffer.getInt(this.offset + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public static int fieldsPresentId() {
        return 4;
    }

    public static String fieldsPresentMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public UpdateFieldsPresentDecoder fieldsPresent() {
        this.fieldsPresent.wrap(this.buffer, this.offset + 16);
        return this.fieldsPresent;
    }

    public static int statsCollectionDurationId() {
        return 5;
    }

    public static String statsCollectionDurationMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int statsCollectionDurationNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int statsCollectionDurationMinValue() {
        return -2147483647;
    }

    public static int statsCollectionDurationMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int statsCollectionDuration() {
        return this.buffer.getInt(this.offset + 20, ByteOrder.LITTLE_ENDIAN);
    }

    public static int scoreId() {
        return 6;
    }

    public static String scoreMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static double scoreNullValue() {
        return Double.NaN;
    }

    public static double scoreMinValue() {
        return Double.MIN_VALUE;
    }

    public static double scoreMaxValue() {
        return Double.MAX_VALUE;
    }

    public double score() {
        return this.buffer.getDouble(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public static long memoryUseDecoderId() {
        return 100L;
    }

    public MemoryUseDecoder memoryUse() {
        this.memoryUse.wrap(this.parentMessage, this.buffer);
        return this.memoryUse;
    }

    public static long performanceDecoderId() {
        return 200L;
    }

    public PerformanceDecoder performance() {
        this.performance.wrap(this.parentMessage, this.buffer);
        return this.performance;
    }

    public static long gcStatsDecoderId() {
        return 300L;
    }

    public GcStatsDecoder gcStats() {
        this.gcStats.wrap(this.parentMessage, this.buffer);
        return this.gcStats;
    }

    public static long paramNamesDecoderId() {
        return 350L;
    }

    public ParamNamesDecoder paramNames() {
        this.paramNames.wrap(this.parentMessage, this.buffer);
        return this.paramNames;
    }

    public static long layerNamesDecoderId() {
        return 351L;
    }

    public LayerNamesDecoder layerNames() {
        this.layerNames.wrap(this.parentMessage, this.buffer);
        return this.layerNames;
    }

    public static long perParameterStatsDecoderId() {
        return 400L;
    }

    public PerParameterStatsDecoder perParameterStats() {
        this.perParameterStats.wrap(this.parentMessage, this.buffer);
        return this.perParameterStats;
    }

    public static long dataSetMetaDataBytesDecoderId() {
        return 500L;
    }

    public DataSetMetaDataBytesDecoder dataSetMetaDataBytes() {
        this.dataSetMetaDataBytes.wrap(this.parentMessage, this.buffer);
        return this.dataSetMetaDataBytes;
    }

    public static int sessionIDId() {
        return 1200;
    }

    public static String sessionIDCharacterEncoding() {
        return "UTF-8";
    }

    public static String sessionIDMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int sessionIDHeaderLength() {
        return 4;
    }

    public int sessionIDLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getSessionID(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getSessionID(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public String sessionID() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int typeIDId() {
        return 1201;
    }

    public static String typeIDCharacterEncoding() {
        return "UTF-8";
    }

    public static String typeIDMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int typeIDHeaderLength() {
        return 4;
    }

    public int typeIDLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getTypeID(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getTypeID(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public String typeID() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int workerIDId() {
        return 1202;
    }

    public static String workerIDCharacterEncoding() {
        return "UTF-8";
    }

    public static String workerIDMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int workerIDHeaderLength() {
        return 4;
    }

    public int workerIDLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getWorkerID(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getWorkerID(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public String workerID() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int dataSetMetaDataClassNameId() {
        return 1300;
    }

    public static String dataSetMetaDataClassNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String dataSetMetaDataClassNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int dataSetMetaDataClassNameHeaderLength() {
        return 4;
    }

    public int dataSetMetaDataClassNameLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getDataSetMetaDataClassName(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getDataSetMetaDataClassName(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public String dataSetMetaDataClassName() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[Update](sbeTemplateId=");
        builder.append(2);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.actingVersion != 0) {
            builder.append(this.actingVersion);
            builder.append('/');
        }
        builder.append(0);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 32) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(32);
        builder.append("):");
        builder.append("time=");
        builder.append(this.time());
        builder.append('|');
        builder.append("deltaTime=");
        builder.append(this.deltaTime());
        builder.append('|');
        builder.append("iterationCount=");
        builder.append(this.iterationCount());
        builder.append('|');
        builder.append("fieldsPresent=");
        builder.append(this.fieldsPresent());
        builder.append('|');
        builder.append("statsCollectionDuration=");
        builder.append(this.statsCollectionDuration());
        builder.append('|');
        builder.append("score=");
        builder.append(this.score());
        builder.append('|');
        builder.append("memoryUse=[");
        MemoryUseDecoder memoryUse = this.memoryUse();
        if (memoryUse.count() > 0) {
            while (memoryUse.hasNext()) {
                memoryUse.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("performance=[");
        PerformanceDecoder performance = this.performance();
        if (performance.count() > 0) {
            while (performance.hasNext()) {
                performance.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("gcStats=[");
        GcStatsDecoder gcStats = this.gcStats();
        if (gcStats.count() > 0) {
            while (gcStats.hasNext()) {
                gcStats.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("paramNames=[");
        ParamNamesDecoder paramNames = this.paramNames();
        if (paramNames.count() > 0) {
            while (paramNames.hasNext()) {
                paramNames.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("layerNames=[");
        LayerNamesDecoder layerNames = this.layerNames();
        if (layerNames.count() > 0) {
            while (layerNames.hasNext()) {
                layerNames.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("perParameterStats=[");
        PerParameterStatsDecoder perParameterStats = this.perParameterStats();
        if (perParameterStats.count() > 0) {
            while (perParameterStats.hasNext()) {
                perParameterStats.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("dataSetMetaDataBytes=[");
        DataSetMetaDataBytesDecoder dataSetMetaDataBytes = this.dataSetMetaDataBytes();
        if (dataSetMetaDataBytes.count() > 0) {
            while (dataSetMetaDataBytes.hasNext()) {
                dataSetMetaDataBytes.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("sessionID=");
        builder.append(this.sessionID());
        builder.append('|');
        builder.append("typeID=");
        builder.append(this.typeID());
        builder.append('|');
        builder.append("workerID=");
        builder.append(this.workerID());
        builder.append('|');
        builder.append("dataSetMetaDataClassName=");
        builder.append(this.dataSetMetaDataClassName());
        this.limit(originalLimit);
        return builder;
    }

    public static class DataSetMetaDataBytesDecoder
    implements Iterable<DataSetMetaDataBytesDecoder>,
    Iterator<DataSetMetaDataBytesDecoder> {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingDecoder dimensions = new GroupSizeEncodingDecoder();
        private UpdateDecoder parentMessage;
        private DirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;
        private final MetaDataBytesDecoder metaDataBytes = new MetaDataBytesDecoder();

        public void wrap(UpdateDecoder parentMessage, DirectBuffer buffer) {
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.blockLength = this.dimensions.blockLength();
            this.count = this.dimensions.numInGroup();
            this.index = -1;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 0;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<DataSetMetaDataBytesDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.count;
        }

        @Override
        public DataSetMetaDataBytesDecoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static long metaDataBytesDecoderId() {
            return 501L;
        }

        public MetaDataBytesDecoder metaDataBytes() {
            this.metaDataBytes.wrap(this.parentMessage, this.buffer);
            return this.metaDataBytes;
        }

        public String toString() {
            return this.appendTo(new StringBuilder(100)).toString();
        }

        public StringBuilder appendTo(StringBuilder builder) {
            builder.append('(');
            builder.append("metaDataBytes=[");
            MetaDataBytesDecoder metaDataBytes = this.metaDataBytes();
            if (metaDataBytes.count() > 0) {
                while (metaDataBytes.hasNext()) {
                    metaDataBytes.next().appendTo(builder);
                    builder.append(',');
                }
                builder.setLength(builder.length() - 1);
            }
            builder.append(']');
            builder.append(')');
            return builder;
        }

        public static class MetaDataBytesDecoder
        implements Iterable<MetaDataBytesDecoder>,
        Iterator<MetaDataBytesDecoder> {
            private static final int HEADER_SIZE = 4;
            private final GroupSizeEncodingDecoder dimensions = new GroupSizeEncodingDecoder();
            private UpdateDecoder parentMessage;
            private DirectBuffer buffer;
            private int blockLength;
            private int actingVersion;
            private int count;
            private int index;
            private int offset;

            public void wrap(UpdateDecoder parentMessage, DirectBuffer buffer) {
                this.parentMessage = parentMessage;
                this.buffer = buffer;
                this.dimensions.wrap(buffer, parentMessage.limit());
                this.blockLength = this.dimensions.blockLength();
                this.count = this.dimensions.numInGroup();
                this.index = -1;
                parentMessage.limit(parentMessage.limit() + 4);
            }

            public static int sbeHeaderSize() {
                return 4;
            }

            public static int sbeBlockLength() {
                return 1;
            }

            public int actingBlockLength() {
                return this.blockLength;
            }

            public int count() {
                return this.count;
            }

            @Override
            public Iterator<MetaDataBytesDecoder> iterator() {
                return this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < this.count;
            }

            @Override
            public MetaDataBytesDecoder next() {
                if (this.index + 1 >= this.count) {
                    throw new NoSuchElementException();
                }
                this.offset = this.parentMessage.limit();
                this.parentMessage.limit(this.offset + this.blockLength);
                ++this.index;
                return this;
            }

            public static int bytesId() {
                return 502;
            }

            public static String bytesMetaAttribute(MetaAttribute metaAttribute) {
                switch (metaAttribute) {
                    case EPOCH: {
                        return "unix";
                    }
                    case TIME_UNIT: {
                        return "nanosecond";
                    }
                    case SEMANTIC_TYPE: {
                        return "";
                    }
                }
                return "";
            }

            public static byte bytesNullValue() {
                return -128;
            }

            public static byte bytesMinValue() {
                return -127;
            }

            public static byte bytesMaxValue() {
                return 127;
            }

            public byte bytes() {
                return this.buffer.getByte(this.offset + 0);
            }

            public String toString() {
                return this.appendTo(new StringBuilder(100)).toString();
            }

            public StringBuilder appendTo(StringBuilder builder) {
                builder.append('(');
                builder.append("bytes=");
                builder.append(this.bytes());
                builder.append(')');
                return builder;
            }
        }
    }

    public static class PerParameterStatsDecoder
    implements Iterable<PerParameterStatsDecoder>,
    Iterator<PerParameterStatsDecoder> {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingDecoder dimensions = new GroupSizeEncodingDecoder();
        private UpdateDecoder parentMessage;
        private DirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;
        private final SummaryStatDecoder summaryStat = new SummaryStatDecoder();
        private final HistogramsDecoder histograms = new HistogramsDecoder();

        public void wrap(UpdateDecoder parentMessage, DirectBuffer buffer) {
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.blockLength = this.dimensions.blockLength();
            this.count = this.dimensions.numInGroup();
            this.index = -1;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 4;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<PerParameterStatsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.count;
        }

        @Override
        public PerParameterStatsDecoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int learningRateId() {
            return 401;
        }

        public static String learningRateMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static float learningRateNullValue() {
            return Float.NaN;
        }

        public static float learningRateMinValue() {
            return Float.MIN_VALUE;
        }

        public static float learningRateMaxValue() {
            return Float.MAX_VALUE;
        }

        public float learningRate() {
            return this.buffer.getFloat(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
        }

        public static long summaryStatDecoderId() {
            return 402L;
        }

        public SummaryStatDecoder summaryStat() {
            this.summaryStat.wrap(this.parentMessage, this.buffer);
            return this.summaryStat;
        }

        public static long histogramsDecoderId() {
            return 406L;
        }

        public HistogramsDecoder histograms() {
            this.histograms.wrap(this.parentMessage, this.buffer);
            return this.histograms;
        }

        public String toString() {
            return this.appendTo(new StringBuilder(100)).toString();
        }

        public StringBuilder appendTo(StringBuilder builder) {
            builder.append('(');
            builder.append("learningRate=");
            builder.append(this.learningRate());
            builder.append('|');
            builder.append("summaryStat=[");
            SummaryStatDecoder summaryStat = this.summaryStat();
            if (summaryStat.count() > 0) {
                while (summaryStat.hasNext()) {
                    summaryStat.next().appendTo(builder);
                    builder.append(',');
                }
                builder.setLength(builder.length() - 1);
            }
            builder.append(']');
            builder.append('|');
            builder.append("histograms=[");
            HistogramsDecoder histograms = this.histograms();
            if (histograms.count() > 0) {
                while (histograms.hasNext()) {
                    histograms.next().appendTo(builder);
                    builder.append(',');
                }
                builder.setLength(builder.length() - 1);
            }
            builder.append(']');
            builder.append(')');
            return builder;
        }

        public static class HistogramsDecoder
        implements Iterable<HistogramsDecoder>,
        Iterator<HistogramsDecoder> {
            private static final int HEADER_SIZE = 4;
            private final GroupSizeEncodingDecoder dimensions = new GroupSizeEncodingDecoder();
            private UpdateDecoder parentMessage;
            private DirectBuffer buffer;
            private int blockLength;
            private int actingVersion;
            private int count;
            private int index;
            private int offset;
            private final HistogramCountsDecoder histogramCounts = new HistogramCountsDecoder();

            public void wrap(UpdateDecoder parentMessage, DirectBuffer buffer) {
                this.parentMessage = parentMessage;
                this.buffer = buffer;
                this.dimensions.wrap(buffer, parentMessage.limit());
                this.blockLength = this.dimensions.blockLength();
                this.count = this.dimensions.numInGroup();
                this.index = -1;
                parentMessage.limit(parentMessage.limit() + 4);
            }

            public static int sbeHeaderSize() {
                return 4;
            }

            public static int sbeBlockLength() {
                return 21;
            }

            public int actingBlockLength() {
                return this.blockLength;
            }

            public int count() {
                return this.count;
            }

            @Override
            public Iterator<HistogramsDecoder> iterator() {
                return this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < this.count;
            }

            @Override
            public HistogramsDecoder next() {
                if (this.index + 1 >= this.count) {
                    throw new NoSuchElementException();
                }
                this.offset = this.parentMessage.limit();
                this.parentMessage.limit(this.offset + this.blockLength);
                ++this.index;
                return this;
            }

            public static int statTypeId() {
                return 407;
            }

            public static String statTypeMetaAttribute(MetaAttribute metaAttribute) {
                switch (metaAttribute) {
                    case EPOCH: {
                        return "unix";
                    }
                    case TIME_UNIT: {
                        return "nanosecond";
                    }
                    case SEMANTIC_TYPE: {
                        return "";
                    }
                }
                return "";
            }

            public StatsType statType() {
                return StatsType.get((short)(this.buffer.getByte(this.offset + 0) & 0xFF));
            }

            public static int minValueId() {
                return 408;
            }

            public static String minValueMetaAttribute(MetaAttribute metaAttribute) {
                switch (metaAttribute) {
                    case EPOCH: {
                        return "unix";
                    }
                    case TIME_UNIT: {
                        return "nanosecond";
                    }
                    case SEMANTIC_TYPE: {
                        return "";
                    }
                }
                return "";
            }

            public static double minValueNullValue() {
                return Double.NaN;
            }

            public static double minValueMinValue() {
                return Double.MIN_VALUE;
            }

            public static double minValueMaxValue() {
                return Double.MAX_VALUE;
            }

            public double minValue() {
                return this.buffer.getDouble(this.offset + 1, ByteOrder.LITTLE_ENDIAN);
            }

            public static int maxValueId() {
                return 409;
            }

            public static String maxValueMetaAttribute(MetaAttribute metaAttribute) {
                switch (metaAttribute) {
                    case EPOCH: {
                        return "unix";
                    }
                    case TIME_UNIT: {
                        return "nanosecond";
                    }
                    case SEMANTIC_TYPE: {
                        return "";
                    }
                }
                return "";
            }

            public static double maxValueNullValue() {
                return Double.NaN;
            }

            public static double maxValueMinValue() {
                return Double.MIN_VALUE;
            }

            public static double maxValueMaxValue() {
                return Double.MAX_VALUE;
            }

            public double maxValue() {
                return this.buffer.getDouble(this.offset + 9, ByteOrder.LITTLE_ENDIAN);
            }

            public static int nBinsId() {
                return 410;
            }

            public static String nBinsMetaAttribute(MetaAttribute metaAttribute) {
                switch (metaAttribute) {
                    case EPOCH: {
                        return "unix";
                    }
                    case TIME_UNIT: {
                        return "nanosecond";
                    }
                    case SEMANTIC_TYPE: {
                        return "";
                    }
                }
                return "";
            }

            public static int nBinsNullValue() {
                return Integer.MIN_VALUE;
            }

            public static int nBinsMinValue() {
                return -2147483647;
            }

            public static int nBinsMaxValue() {
                return Integer.MAX_VALUE;
            }

            public int nBins() {
                return this.buffer.getInt(this.offset + 17, ByteOrder.LITTLE_ENDIAN);
            }

            public static long histogramCountsDecoderId() {
                return 411L;
            }

            public HistogramCountsDecoder histogramCounts() {
                this.histogramCounts.wrap(this.parentMessage, this.buffer);
                return this.histogramCounts;
            }

            public String toString() {
                return this.appendTo(new StringBuilder(100)).toString();
            }

            public StringBuilder appendTo(StringBuilder builder) {
                builder.append('(');
                builder.append("statType=");
                builder.append((Object)this.statType());
                builder.append('|');
                builder.append("minValue=");
                builder.append(this.minValue());
                builder.append('|');
                builder.append("maxValue=");
                builder.append(this.maxValue());
                builder.append('|');
                builder.append("nBins=");
                builder.append(this.nBins());
                builder.append('|');
                builder.append("histogramCounts=[");
                HistogramCountsDecoder histogramCounts = this.histogramCounts();
                if (histogramCounts.count() > 0) {
                    while (histogramCounts.hasNext()) {
                        histogramCounts.next().appendTo(builder);
                        builder.append(',');
                    }
                    builder.setLength(builder.length() - 1);
                }
                builder.append(']');
                builder.append(')');
                return builder;
            }

            public static class HistogramCountsDecoder
            implements Iterable<HistogramCountsDecoder>,
            Iterator<HistogramCountsDecoder> {
                private static final int HEADER_SIZE = 4;
                private final GroupSizeEncodingDecoder dimensions = new GroupSizeEncodingDecoder();
                private UpdateDecoder parentMessage;
                private DirectBuffer buffer;
                private int blockLength;
                private int actingVersion;
                private int count;
                private int index;
                private int offset;

                public void wrap(UpdateDecoder parentMessage, DirectBuffer buffer) {
                    this.parentMessage = parentMessage;
                    this.buffer = buffer;
                    this.dimensions.wrap(buffer, parentMessage.limit());
                    this.blockLength = this.dimensions.blockLength();
                    this.count = this.dimensions.numInGroup();
                    this.index = -1;
                    parentMessage.limit(parentMessage.limit() + 4);
                }

                public static int sbeHeaderSize() {
                    return 4;
                }

                public static int sbeBlockLength() {
                    return 4;
                }

                public int actingBlockLength() {
                    return this.blockLength;
                }

                public int count() {
                    return this.count;
                }

                @Override
                public Iterator<HistogramCountsDecoder> iterator() {
                    return this;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasNext() {
                    return this.index + 1 < this.count;
                }

                @Override
                public HistogramCountsDecoder next() {
                    if (this.index + 1 >= this.count) {
                        throw new NoSuchElementException();
                    }
                    this.offset = this.parentMessage.limit();
                    this.parentMessage.limit(this.offset + this.blockLength);
                    ++this.index;
                    return this;
                }

                public static int binCountId() {
                    return 412;
                }

                public static String binCountMetaAttribute(MetaAttribute metaAttribute) {
                    switch (metaAttribute) {
                        case EPOCH: {
                            return "unix";
                        }
                        case TIME_UNIT: {
                            return "nanosecond";
                        }
                        case SEMANTIC_TYPE: {
                            return "";
                        }
                    }
                    return "";
                }

                public static long binCountNullValue() {
                    return 0xFFFFFFFEL;
                }

                public static long binCountMinValue() {
                    return 0L;
                }

                public static long binCountMaxValue() {
                    return 0xFFFFFFFDL;
                }

                public long binCount() {
                    return (long)this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
                }

                public String toString() {
                    return this.appendTo(new StringBuilder(100)).toString();
                }

                public StringBuilder appendTo(StringBuilder builder) {
                    builder.append('(');
                    builder.append("binCount=");
                    builder.append(this.binCount());
                    builder.append(')');
                    return builder;
                }
            }
        }

        public static class SummaryStatDecoder
        implements Iterable<SummaryStatDecoder>,
        Iterator<SummaryStatDecoder> {
            private static final int HEADER_SIZE = 4;
            private final GroupSizeEncodingDecoder dimensions = new GroupSizeEncodingDecoder();
            private UpdateDecoder parentMessage;
            private DirectBuffer buffer;
            private int blockLength;
            private int actingVersion;
            private int count;
            private int index;
            private int offset;

            public void wrap(UpdateDecoder parentMessage, DirectBuffer buffer) {
                this.parentMessage = parentMessage;
                this.buffer = buffer;
                this.dimensions.wrap(buffer, parentMessage.limit());
                this.blockLength = this.dimensions.blockLength();
                this.count = this.dimensions.numInGroup();
                this.index = -1;
                parentMessage.limit(parentMessage.limit() + 4);
            }

            public static int sbeHeaderSize() {
                return 4;
            }

            public static int sbeBlockLength() {
                return 10;
            }

            public int actingBlockLength() {
                return this.blockLength;
            }

            public int count() {
                return this.count;
            }

            @Override
            public Iterator<SummaryStatDecoder> iterator() {
                return this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < this.count;
            }

            @Override
            public SummaryStatDecoder next() {
                if (this.index + 1 >= this.count) {
                    throw new NoSuchElementException();
                }
                this.offset = this.parentMessage.limit();
                this.parentMessage.limit(this.offset + this.blockLength);
                ++this.index;
                return this;
            }

            public static int statTypeId() {
                return 403;
            }

            public static String statTypeMetaAttribute(MetaAttribute metaAttribute) {
                switch (metaAttribute) {
                    case EPOCH: {
                        return "unix";
                    }
                    case TIME_UNIT: {
                        return "nanosecond";
                    }
                    case SEMANTIC_TYPE: {
                        return "";
                    }
                }
                return "";
            }

            public StatsType statType() {
                return StatsType.get((short)(this.buffer.getByte(this.offset + 0) & 0xFF));
            }

            public static int summaryTypeId() {
                return 404;
            }

            public static String summaryTypeMetaAttribute(MetaAttribute metaAttribute) {
                switch (metaAttribute) {
                    case EPOCH: {
                        return "unix";
                    }
                    case TIME_UNIT: {
                        return "nanosecond";
                    }
                    case SEMANTIC_TYPE: {
                        return "";
                    }
                }
                return "";
            }

            public SummaryType summaryType() {
                return SummaryType.get((short)(this.buffer.getByte(this.offset + 1) & 0xFF));
            }

            public static int valueId() {
                return 405;
            }

            public static String valueMetaAttribute(MetaAttribute metaAttribute) {
                switch (metaAttribute) {
                    case EPOCH: {
                        return "unix";
                    }
                    case TIME_UNIT: {
                        return "nanosecond";
                    }
                    case SEMANTIC_TYPE: {
                        return "";
                    }
                }
                return "";
            }

            public static double valueNullValue() {
                return Double.NaN;
            }

            public static double valueMinValue() {
                return Double.MIN_VALUE;
            }

            public static double valueMaxValue() {
                return Double.MAX_VALUE;
            }

            public double value() {
                return this.buffer.getDouble(this.offset + 2, ByteOrder.LITTLE_ENDIAN);
            }

            public String toString() {
                return this.appendTo(new StringBuilder(100)).toString();
            }

            public StringBuilder appendTo(StringBuilder builder) {
                builder.append('(');
                builder.append("statType=");
                builder.append((Object)this.statType());
                builder.append('|');
                builder.append("summaryType=");
                builder.append((Object)this.summaryType());
                builder.append('|');
                builder.append("value=");
                builder.append(this.value());
                builder.append(')');
                return builder;
            }
        }
    }

    public static class LayerNamesDecoder
    implements Iterable<LayerNamesDecoder>,
    Iterator<LayerNamesDecoder> {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingDecoder dimensions = new GroupSizeEncodingDecoder();
        private UpdateDecoder parentMessage;
        private DirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;

        public void wrap(UpdateDecoder parentMessage, DirectBuffer buffer) {
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.blockLength = this.dimensions.blockLength();
            this.count = this.dimensions.numInGroup();
            this.index = -1;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 0;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<LayerNamesDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.count;
        }

        @Override
        public LayerNamesDecoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int layerNameId() {
            return 1101;
        }

        public static String layerNameCharacterEncoding() {
            return "UTF-8";
        }

        public static String layerNameMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int layerNameHeaderLength() {
            return 4;
        }

        public int layerNameLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int getLayerName(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getLayerName(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public String layerName() {
            String value;
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            try {
                value = new String(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public String toString() {
            return this.appendTo(new StringBuilder(100)).toString();
        }

        public StringBuilder appendTo(StringBuilder builder) {
            builder.append('(');
            builder.append("layerName=");
            builder.append(this.layerName());
            builder.append(')');
            return builder;
        }
    }

    public static class ParamNamesDecoder
    implements Iterable<ParamNamesDecoder>,
    Iterator<ParamNamesDecoder> {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingDecoder dimensions = new GroupSizeEncodingDecoder();
        private UpdateDecoder parentMessage;
        private DirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;

        public void wrap(UpdateDecoder parentMessage, DirectBuffer buffer) {
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.blockLength = this.dimensions.blockLength();
            this.count = this.dimensions.numInGroup();
            this.index = -1;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 0;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<ParamNamesDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.count;
        }

        @Override
        public ParamNamesDecoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int paramNameId() {
            return 1100;
        }

        public static String paramNameCharacterEncoding() {
            return "UTF-8";
        }

        public static String paramNameMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int paramNameHeaderLength() {
            return 4;
        }

        public int paramNameLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int getParamName(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getParamName(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public String paramName() {
            String value;
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            try {
                value = new String(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public String toString() {
            return this.appendTo(new StringBuilder(100)).toString();
        }

        public StringBuilder appendTo(StringBuilder builder) {
            builder.append('(');
            builder.append("paramName=");
            builder.append(this.paramName());
            builder.append(')');
            return builder;
        }
    }

    public static class GcStatsDecoder
    implements Iterable<GcStatsDecoder>,
    Iterator<GcStatsDecoder> {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingDecoder dimensions = new GroupSizeEncodingDecoder();
        private UpdateDecoder parentMessage;
        private DirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;

        public void wrap(UpdateDecoder parentMessage, DirectBuffer buffer) {
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.blockLength = this.dimensions.blockLength();
            this.count = this.dimensions.numInGroup();
            this.index = -1;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 8;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<GcStatsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.count;
        }

        @Override
        public GcStatsDecoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int deltaGCCountId() {
            return 301;
        }

        public static String deltaGCCountMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int deltaGCCountNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int deltaGCCountMinValue() {
            return -2147483647;
        }

        public static int deltaGCCountMaxValue() {
            return Integer.MAX_VALUE;
        }

        public int deltaGCCount() {
            return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
        }

        public static int deltaGCTimeMsId() {
            return 302;
        }

        public static String deltaGCTimeMsMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int deltaGCTimeMsNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int deltaGCTimeMsMinValue() {
            return -2147483647;
        }

        public static int deltaGCTimeMsMaxValue() {
            return Integer.MAX_VALUE;
        }

        public int deltaGCTimeMs() {
            return this.buffer.getInt(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
        }

        public static int gcNameId() {
            return 1000;
        }

        public static String gcNameCharacterEncoding() {
            return "UTF-8";
        }

        public static String gcNameMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int gcNameHeaderLength() {
            return 4;
        }

        public int gcNameLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int getGcName(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getGcName(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public String gcName() {
            String value;
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            try {
                value = new String(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public String toString() {
            return this.appendTo(new StringBuilder(100)).toString();
        }

        public StringBuilder appendTo(StringBuilder builder) {
            builder.append('(');
            builder.append("deltaGCCount=");
            builder.append(this.deltaGCCount());
            builder.append('|');
            builder.append("deltaGCTimeMs=");
            builder.append(this.deltaGCTimeMs());
            builder.append('|');
            builder.append("gcName=");
            builder.append(this.gcName());
            builder.append(')');
            return builder;
        }
    }

    public static class PerformanceDecoder
    implements Iterable<PerformanceDecoder>,
    Iterator<PerformanceDecoder> {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingDecoder dimensions = new GroupSizeEncodingDecoder();
        private UpdateDecoder parentMessage;
        private DirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;

        public void wrap(UpdateDecoder parentMessage, DirectBuffer buffer) {
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.blockLength = this.dimensions.blockLength();
            this.count = this.dimensions.numInGroup();
            this.index = -1;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 32;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<PerformanceDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.count;
        }

        @Override
        public PerformanceDecoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int totalRuntimeMsId() {
            return 201;
        }

        public static String totalRuntimeMsMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static long totalRuntimeMsNullValue() {
            return Long.MIN_VALUE;
        }

        public static long totalRuntimeMsMinValue() {
            return -9223372036854775807L;
        }

        public static long totalRuntimeMsMaxValue() {
            return Long.MAX_VALUE;
        }

        public long totalRuntimeMs() {
            return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
        }

        public static int totalExamplesId() {
            return 202;
        }

        public static String totalExamplesMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static long totalExamplesNullValue() {
            return Long.MIN_VALUE;
        }

        public static long totalExamplesMinValue() {
            return -9223372036854775807L;
        }

        public static long totalExamplesMaxValue() {
            return Long.MAX_VALUE;
        }

        public long totalExamples() {
            return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
        }

        public static int totalMinibatchesId() {
            return 203;
        }

        public static String totalMinibatchesMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static long totalMinibatchesNullValue() {
            return Long.MIN_VALUE;
        }

        public static long totalMinibatchesMinValue() {
            return -9223372036854775807L;
        }

        public static long totalMinibatchesMaxValue() {
            return Long.MAX_VALUE;
        }

        public long totalMinibatches() {
            return this.buffer.getLong(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
        }

        public static int examplesPerSecondId() {
            return 204;
        }

        public static String examplesPerSecondMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static float examplesPerSecondNullValue() {
            return Float.NaN;
        }

        public static float examplesPerSecondMinValue() {
            return Float.MIN_VALUE;
        }

        public static float examplesPerSecondMaxValue() {
            return Float.MAX_VALUE;
        }

        public float examplesPerSecond() {
            return this.buffer.getFloat(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
        }

        public static int minibatchesPerSecondId() {
            return 205;
        }

        public static String minibatchesPerSecondMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static float minibatchesPerSecondNullValue() {
            return Float.NaN;
        }

        public static float minibatchesPerSecondMinValue() {
            return Float.MIN_VALUE;
        }

        public static float minibatchesPerSecondMaxValue() {
            return Float.MAX_VALUE;
        }

        public float minibatchesPerSecond() {
            return this.buffer.getFloat(this.offset + 28, ByteOrder.LITTLE_ENDIAN);
        }

        public String toString() {
            return this.appendTo(new StringBuilder(100)).toString();
        }

        public StringBuilder appendTo(StringBuilder builder) {
            builder.append('(');
            builder.append("totalRuntimeMs=");
            builder.append(this.totalRuntimeMs());
            builder.append('|');
            builder.append("totalExamples=");
            builder.append(this.totalExamples());
            builder.append('|');
            builder.append("totalMinibatches=");
            builder.append(this.totalMinibatches());
            builder.append('|');
            builder.append("examplesPerSecond=");
            builder.append(this.examplesPerSecond());
            builder.append('|');
            builder.append("minibatchesPerSecond=");
            builder.append(this.minibatchesPerSecond());
            builder.append(')');
            return builder;
        }
    }

    public static class MemoryUseDecoder
    implements Iterable<MemoryUseDecoder>,
    Iterator<MemoryUseDecoder> {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingDecoder dimensions = new GroupSizeEncodingDecoder();
        private UpdateDecoder parentMessage;
        private DirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;

        public void wrap(UpdateDecoder parentMessage, DirectBuffer buffer) {
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.blockLength = this.dimensions.blockLength();
            this.count = this.dimensions.numInGroup();
            this.index = -1;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 9;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<MemoryUseDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.count;
        }

        @Override
        public MemoryUseDecoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int memoryTypeId() {
            return 101;
        }

        public static String memoryTypeMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public MemoryType memoryType() {
            return MemoryType.get((short)(this.buffer.getByte(this.offset + 0) & 0xFF));
        }

        public static int memoryBytesId() {
            return 102;
        }

        public static String memoryBytesMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static long memoryBytesNullValue() {
            return Long.MIN_VALUE;
        }

        public static long memoryBytesMinValue() {
            return -9223372036854775807L;
        }

        public static long memoryBytesMaxValue() {
            return Long.MAX_VALUE;
        }

        public long memoryBytes() {
            return this.buffer.getLong(this.offset + 1, ByteOrder.LITTLE_ENDIAN);
        }

        public String toString() {
            return this.appendTo(new StringBuilder(100)).toString();
        }

        public StringBuilder appendTo(StringBuilder builder) {
            builder.append('(');
            builder.append("memoryType=");
            builder.append((Object)this.memoryType());
            builder.append('|');
            builder.append("memoryBytes=");
            builder.append(this.memoryBytes());
            builder.append(')');
            return builder;
        }
    }
}

