/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.model.stats.sbe;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.deeplearning4j.ui.model.stats.sbe.GroupSizeEncodingDecoder;

public class GroupSizeEncodingEncoder {
    public static final int ENCODED_LENGTH = 4;
    private MutableDirectBuffer buffer;
    private int offset;

    public GroupSizeEncodingEncoder wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        return this;
    }

    public int encodedLength() {
        return 4;
    }

    public static int blockLengthNullValue() {
        return 65535;
    }

    public static int blockLengthMinValue() {
        return 0;
    }

    public static int blockLengthMaxValue() {
        return 65534;
    }

    public GroupSizeEncodingEncoder blockLength(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int numInGroupNullValue() {
        return 65535;
    }

    public static int numInGroupMinValue() {
        return 0;
    }

    public static int numInGroupMaxValue() {
        return 65534;
    }

    public GroupSizeEncodingEncoder numInGroup(int value) {
        this.buffer.putShort(this.offset + 2, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        GroupSizeEncodingDecoder writer = new GroupSizeEncodingDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset);
        return writer.appendTo(builder);
    }
}

