/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.api;

import java.awt.Color;
import java.beans.ConstructorProperties;
import org.deeplearning4j.ui.api.LengthUnit;
import org.deeplearning4j.ui.api.Utils;
import org.deeplearning4j.ui.components.chart.style.StyleChart;
import org.deeplearning4j.ui.components.component.style.StyleDiv;
import org.deeplearning4j.ui.components.decorator.style.StyleAccordion;
import org.deeplearning4j.ui.components.table.style.StyleTable;
import org.deeplearning4j.ui.components.text.style.StyleText;
import org.nd4j.shade.jackson.annotation.JsonSubTypes;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
@JsonSubTypes(value={@JsonSubTypes.Type(value=StyleChart.class, name="StyleChart"), @JsonSubTypes.Type(value=StyleTable.class, name="StyleTable"), @JsonSubTypes.Type(value=StyleText.class, name="StyleText"), @JsonSubTypes.Type(value=StyleAccordion.class, name="StyleAccordion"), @JsonSubTypes.Type(value=StyleDiv.class, name="StyleDiv")})
public abstract class Style {
    private Double width;
    private Double height;
    private LengthUnit widthUnit;
    private LengthUnit heightUnit;
    protected LengthUnit marginUnit;
    protected Double marginTop;
    protected Double marginBottom;
    protected Double marginLeft;
    protected Double marginRight;
    protected String backgroundColor;

    public Style(Builder b) {
        this.width = b.width;
        this.height = b.height;
        this.widthUnit = b.widthUnit;
        this.heightUnit = b.heightUnit;
        this.marginUnit = b.marginUnit;
        this.marginTop = b.marginTop;
        this.marginBottom = b.marginBottom;
        this.marginLeft = b.marginLeft;
        this.marginRight = b.marginRight;
        this.backgroundColor = b.backgroundColor;
    }

    public Double getWidth() {
        return this.width;
    }

    public Double getHeight() {
        return this.height;
    }

    public LengthUnit getWidthUnit() {
        return this.widthUnit;
    }

    public LengthUnit getHeightUnit() {
        return this.heightUnit;
    }

    public LengthUnit getMarginUnit() {
        return this.marginUnit;
    }

    public Double getMarginTop() {
        return this.marginTop;
    }

    public Double getMarginBottom() {
        return this.marginBottom;
    }

    public Double getMarginLeft() {
        return this.marginLeft;
    }

    public Double getMarginRight() {
        return this.marginRight;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public void setWidthUnit(LengthUnit widthUnit) {
        this.widthUnit = widthUnit;
    }

    public void setHeightUnit(LengthUnit heightUnit) {
        this.heightUnit = heightUnit;
    }

    public void setMarginUnit(LengthUnit marginUnit) {
        this.marginUnit = marginUnit;
    }

    public void setMarginTop(Double marginTop) {
        this.marginTop = marginTop;
    }

    public void setMarginBottom(Double marginBottom) {
        this.marginBottom = marginBottom;
    }

    public void setMarginLeft(Double marginLeft) {
        this.marginLeft = marginLeft;
    }

    public void setMarginRight(Double marginRight) {
        this.marginRight = marginRight;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Style)) {
            return false;
        }
        Style other = (Style)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$width = this.getWidth();
        Double other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Double this$height = this.getHeight();
        Double other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        LengthUnit this$widthUnit = this.getWidthUnit();
        LengthUnit other$widthUnit = other.getWidthUnit();
        if (this$widthUnit == null ? other$widthUnit != null : !((Object)((Object)this$widthUnit)).equals((Object)other$widthUnit)) {
            return false;
        }
        LengthUnit this$heightUnit = this.getHeightUnit();
        LengthUnit other$heightUnit = other.getHeightUnit();
        if (this$heightUnit == null ? other$heightUnit != null : !((Object)((Object)this$heightUnit)).equals((Object)other$heightUnit)) {
            return false;
        }
        LengthUnit this$marginUnit = this.getMarginUnit();
        LengthUnit other$marginUnit = other.getMarginUnit();
        if (this$marginUnit == null ? other$marginUnit != null : !((Object)((Object)this$marginUnit)).equals((Object)other$marginUnit)) {
            return false;
        }
        Double this$marginTop = this.getMarginTop();
        Double other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Double this$marginBottom = this.getMarginBottom();
        Double other$marginBottom = other.getMarginBottom();
        if (this$marginBottom == null ? other$marginBottom != null : !((Object)this$marginBottom).equals(other$marginBottom)) {
            return false;
        }
        Double this$marginLeft = this.getMarginLeft();
        Double other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Double this$marginRight = this.getMarginRight();
        Double other$marginRight = other.getMarginRight();
        if (this$marginRight == null ? other$marginRight != null : !((Object)this$marginRight).equals(other$marginRight)) {
            return false;
        }
        String this$backgroundColor = this.getBackgroundColor();
        String other$backgroundColor = other.getBackgroundColor();
        return !(this$backgroundColor == null ? other$backgroundColor != null : !this$backgroundColor.equals(other$backgroundColor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Style;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Double $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        LengthUnit $widthUnit = this.getWidthUnit();
        result = result * 59 + ($widthUnit == null ? 43 : ((Object)((Object)$widthUnit)).hashCode());
        LengthUnit $heightUnit = this.getHeightUnit();
        result = result * 59 + ($heightUnit == null ? 43 : ((Object)((Object)$heightUnit)).hashCode());
        LengthUnit $marginUnit = this.getMarginUnit();
        result = result * 59 + ($marginUnit == null ? 43 : ((Object)((Object)$marginUnit)).hashCode());
        Double $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Double $marginBottom = this.getMarginBottom();
        result = result * 59 + ($marginBottom == null ? 43 : ((Object)$marginBottom).hashCode());
        Double $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Double $marginRight = this.getMarginRight();
        result = result * 59 + ($marginRight == null ? 43 : ((Object)$marginRight).hashCode());
        String $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : $backgroundColor.hashCode());
        return result;
    }

    public String toString() {
        return "Style(width=" + this.getWidth() + ", height=" + this.getHeight() + ", widthUnit=" + (Object)((Object)this.getWidthUnit()) + ", heightUnit=" + (Object)((Object)this.getHeightUnit()) + ", marginUnit=" + (Object)((Object)this.getMarginUnit()) + ", marginTop=" + this.getMarginTop() + ", marginBottom=" + this.getMarginBottom() + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ", backgroundColor=" + this.getBackgroundColor() + ")";
    }

    @ConstructorProperties(value={"width", "height", "widthUnit", "heightUnit", "marginUnit", "marginTop", "marginBottom", "marginLeft", "marginRight", "backgroundColor"})
    public Style(Double width, Double height, LengthUnit widthUnit, LengthUnit heightUnit, LengthUnit marginUnit, Double marginTop, Double marginBottom, Double marginLeft, Double marginRight, String backgroundColor) {
        this.width = width;
        this.height = height;
        this.widthUnit = widthUnit;
        this.heightUnit = heightUnit;
        this.marginUnit = marginUnit;
        this.marginTop = marginTop;
        this.marginBottom = marginBottom;
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;
        this.backgroundColor = backgroundColor;
    }

    public Style() {
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected Double width;
        protected Double height;
        protected LengthUnit widthUnit;
        protected LengthUnit heightUnit;
        protected LengthUnit marginUnit;
        protected Double marginTop;
        protected Double marginBottom;
        protected Double marginLeft;
        protected Double marginRight;
        protected String backgroundColor;

        public T width(double width, LengthUnit widthUnit) {
            this.width = width;
            this.widthUnit = widthUnit;
            return (T)this;
        }

        public T height(double height, LengthUnit heightUnit) {
            this.height = height;
            this.heightUnit = heightUnit;
            return (T)this;
        }

        public T margin(LengthUnit unit, Integer marginTop, Integer marginBottom, Integer marginLeft, Integer marginRight) {
            return this.margin(unit, marginTop != null ? Double.valueOf(marginTop.doubleValue()) : null, marginBottom != null ? Double.valueOf(marginBottom.doubleValue()) : null, marginLeft != null ? Double.valueOf(marginLeft.doubleValue()) : null, marginRight != null ? Double.valueOf(marginRight.doubleValue()) : null);
        }

        public T margin(LengthUnit unit, Double marginTop, Double marginBottom, Double marginLeft, Double marginRight) {
            this.marginUnit = unit;
            this.marginTop = marginTop;
            this.marginBottom = marginBottom;
            this.marginLeft = marginLeft;
            this.marginRight = marginRight;
            return (T)this;
        }

        public T backgroundColor(Color color) {
            return this.backgroundColor(Utils.colorToHex(color));
        }

        public T backgroundColor(String color) {
            this.backgroundColor = color;
            return (T)this;
        }
    }
}

