/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.weightnoise.IWeightNoise;
import org.deeplearning4j.nn.weights.IWeightInit;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.nn.weights.WeightInitDistribution;
import org.deeplearning4j.util.NetworkUtils;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.regularization.L1Regularization;
import org.nd4j.linalg.learning.regularization.L2Regularization;
import org.nd4j.linalg.learning.regularization.Regularization;
import org.nd4j.linalg.learning.regularization.WeightDecay;

public abstract class BaseLayer
extends Layer
implements Serializable,
Cloneable {
    protected IActivation activationFn;
    protected IWeightInit weightInitFn;
    protected double biasInit;
    protected double gainInit;
    protected List<Regularization> regularization;
    protected List<Regularization> regularizationBias;
    protected IUpdater iUpdater;
    protected IUpdater biasUpdater;
    protected IWeightNoise weightNoise;
    protected GradientNormalization gradientNormalization = GradientNormalization.None;
    protected double gradientNormalizationThreshold = 1.0;

    public BaseLayer(Builder builder) {
        super(builder);
        this.layerName = builder.layerName;
        this.activationFn = builder.activationFn;
        this.weightInitFn = builder.weightInitFn;
        this.biasInit = builder.biasInit;
        this.gainInit = builder.gainInit;
        this.regularization = builder.regularization;
        this.regularizationBias = builder.regularizationBias;
        this.iUpdater = builder.iupdater;
        this.biasUpdater = builder.biasUpdater;
        this.gradientNormalization = builder.gradientNormalization;
        this.gradientNormalizationThreshold = builder.gradientNormalizationThreshold;
        this.weightNoise = builder.weightNoise;
    }

    @Override
    public void resetLayerDefaultConfig() {
        this.setIUpdater(null);
        this.setWeightInitFn(null);
        this.setBiasInit(Double.NaN);
        this.setGainInit(Double.NaN);
        this.regularization = null;
        this.regularizationBias = null;
        this.setGradientNormalization(GradientNormalization.None);
        this.setGradientNormalizationThreshold(1.0);
        this.iUpdater = null;
        this.biasUpdater = null;
    }

    @Override
    public BaseLayer clone() {
        BaseLayer clone = (BaseLayer)super.clone();
        if (clone.iDropout != null) {
            clone.iDropout = clone.iDropout.clone();
        }
        if (this.regularization != null) {
            clone.regularization = new ArrayList<Regularization>(this.regularization.size());
            for (Regularization r : this.regularization) {
                clone.regularization.add(r.clone());
            }
        }
        if (this.regularizationBias != null) {
            clone.regularizationBias = new ArrayList<Regularization>(this.regularizationBias.size());
            for (Regularization r : this.regularizationBias) {
                clone.regularizationBias.add(r.clone());
            }
        }
        return clone;
    }

    @Override
    public IUpdater getUpdaterByParam(String paramName) {
        if (this.biasUpdater != null && this.initializer().isBiasParam(this, paramName)) {
            return this.biasUpdater;
        }
        return this.iUpdater;
    }

    @Override
    public GradientNormalization getGradientNormalization() {
        return this.gradientNormalization;
    }

    @Override
    public List<Regularization> getRegularizationByParam(String paramName) {
        if (this.initializer().isWeightParam(this, paramName)) {
            return this.regularization;
        }
        if (this.initializer().isBiasParam(this, paramName)) {
            return this.regularizationBias;
        }
        return null;
    }

    public IActivation getActivationFn() {
        return this.activationFn;
    }

    public IWeightInit getWeightInitFn() {
        return this.weightInitFn;
    }

    public double getBiasInit() {
        return this.biasInit;
    }

    public double getGainInit() {
        return this.gainInit;
    }

    public List<Regularization> getRegularization() {
        return this.regularization;
    }

    public List<Regularization> getRegularizationBias() {
        return this.regularizationBias;
    }

    public IUpdater getIUpdater() {
        return this.iUpdater;
    }

    public IUpdater getBiasUpdater() {
        return this.biasUpdater;
    }

    public IWeightNoise getWeightNoise() {
        return this.weightNoise;
    }

    @Override
    public double getGradientNormalizationThreshold() {
        return this.gradientNormalizationThreshold;
    }

    public void setActivationFn(IActivation activationFn) {
        this.activationFn = activationFn;
    }

    public void setWeightInitFn(IWeightInit weightInitFn) {
        this.weightInitFn = weightInitFn;
    }

    public void setBiasInit(double biasInit) {
        this.biasInit = biasInit;
    }

    public void setGainInit(double gainInit) {
        this.gainInit = gainInit;
    }

    public void setRegularization(List<Regularization> regularization) {
        this.regularization = regularization;
    }

    public void setRegularizationBias(List<Regularization> regularizationBias) {
        this.regularizationBias = regularizationBias;
    }

    public void setIUpdater(IUpdater iUpdater) {
        this.iUpdater = iUpdater;
    }

    public void setBiasUpdater(IUpdater biasUpdater) {
        this.biasUpdater = biasUpdater;
    }

    public void setWeightNoise(IWeightNoise weightNoise) {
        this.weightNoise = weightNoise;
    }

    public void setGradientNormalization(GradientNormalization gradientNormalization) {
        this.gradientNormalization = gradientNormalization;
    }

    public void setGradientNormalizationThreshold(double gradientNormalizationThreshold) {
        this.gradientNormalizationThreshold = gradientNormalizationThreshold;
    }

    @Override
    public String toString() {
        return "BaseLayer(activationFn=" + this.getActivationFn() + ", weightInitFn=" + this.getWeightInitFn() + ", biasInit=" + this.getBiasInit() + ", gainInit=" + this.getGainInit() + ", regularization=" + this.getRegularization() + ", regularizationBias=" + this.getRegularizationBias() + ", iUpdater=" + this.getIUpdater() + ", biasUpdater=" + this.getBiasUpdater() + ", weightNoise=" + this.getWeightNoise() + ", gradientNormalization=" + (Object)((Object)this.getGradientNormalization()) + ", gradientNormalizationThreshold=" + this.getGradientNormalizationThreshold() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseLayer)) {
            return false;
        }
        BaseLayer other = (BaseLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IActivation this$activationFn = this.getActivationFn();
        IActivation other$activationFn = other.getActivationFn();
        if (this$activationFn == null ? other$activationFn != null : !this$activationFn.equals(other$activationFn)) {
            return false;
        }
        IWeightInit this$weightInitFn = this.getWeightInitFn();
        IWeightInit other$weightInitFn = other.getWeightInitFn();
        if (this$weightInitFn == null ? other$weightInitFn != null : !this$weightInitFn.equals(other$weightInitFn)) {
            return false;
        }
        if (Double.compare(this.getBiasInit(), other.getBiasInit()) != 0) {
            return false;
        }
        if (Double.compare(this.getGainInit(), other.getGainInit()) != 0) {
            return false;
        }
        List<Regularization> this$regularization = this.getRegularization();
        List<Regularization> other$regularization = other.getRegularization();
        if (this$regularization == null ? other$regularization != null : !((Object)this$regularization).equals(other$regularization)) {
            return false;
        }
        List<Regularization> this$regularizationBias = this.getRegularizationBias();
        List<Regularization> other$regularizationBias = other.getRegularizationBias();
        if (this$regularizationBias == null ? other$regularizationBias != null : !((Object)this$regularizationBias).equals(other$regularizationBias)) {
            return false;
        }
        IUpdater this$iUpdater = this.getIUpdater();
        IUpdater other$iUpdater = other.getIUpdater();
        if (this$iUpdater == null ? other$iUpdater != null : !this$iUpdater.equals(other$iUpdater)) {
            return false;
        }
        IUpdater this$biasUpdater = this.getBiasUpdater();
        IUpdater other$biasUpdater = other.getBiasUpdater();
        if (this$biasUpdater == null ? other$biasUpdater != null : !this$biasUpdater.equals(other$biasUpdater)) {
            return false;
        }
        IWeightNoise this$weightNoise = this.getWeightNoise();
        IWeightNoise other$weightNoise = other.getWeightNoise();
        if (this$weightNoise == null ? other$weightNoise != null : !this$weightNoise.equals(other$weightNoise)) {
            return false;
        }
        GradientNormalization this$gradientNormalization = this.getGradientNormalization();
        GradientNormalization other$gradientNormalization = other.getGradientNormalization();
        if (this$gradientNormalization == null ? other$gradientNormalization != null : !((Object)((Object)this$gradientNormalization)).equals((Object)other$gradientNormalization)) {
            return false;
        }
        return Double.compare(this.getGradientNormalizationThreshold(), other.getGradientNormalizationThreshold()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        IActivation $activationFn = this.getActivationFn();
        result = result * 59 + ($activationFn == null ? 43 : $activationFn.hashCode());
        IWeightInit $weightInitFn = this.getWeightInitFn();
        result = result * 59 + ($weightInitFn == null ? 43 : $weightInitFn.hashCode());
        long $biasInit = Double.doubleToLongBits(this.getBiasInit());
        result = result * 59 + (int)($biasInit >>> 32 ^ $biasInit);
        long $gainInit = Double.doubleToLongBits(this.getGainInit());
        result = result * 59 + (int)($gainInit >>> 32 ^ $gainInit);
        List<Regularization> $regularization = this.getRegularization();
        result = result * 59 + ($regularization == null ? 43 : ((Object)$regularization).hashCode());
        List<Regularization> $regularizationBias = this.getRegularizationBias();
        result = result * 59 + ($regularizationBias == null ? 43 : ((Object)$regularizationBias).hashCode());
        IUpdater $iUpdater = this.getIUpdater();
        result = result * 59 + ($iUpdater == null ? 43 : $iUpdater.hashCode());
        IUpdater $biasUpdater = this.getBiasUpdater();
        result = result * 59 + ($biasUpdater == null ? 43 : $biasUpdater.hashCode());
        IWeightNoise $weightNoise = this.getWeightNoise();
        result = result * 59 + ($weightNoise == null ? 43 : $weightNoise.hashCode());
        GradientNormalization $gradientNormalization = this.getGradientNormalization();
        result = result * 59 + ($gradientNormalization == null ? 43 : ((Object)((Object)$gradientNormalization)).hashCode());
        long $gradientNormalizationThreshold = Double.doubleToLongBits(this.getGradientNormalizationThreshold());
        result = result * 59 + (int)($gradientNormalizationThreshold >>> 32 ^ $gradientNormalizationThreshold);
        return result;
    }

    public BaseLayer() {
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Layer.Builder<T> {
        protected IActivation activationFn = null;
        protected IWeightInit weightInitFn = null;
        protected double biasInit = Double.NaN;
        protected double gainInit = Double.NaN;
        protected List<Regularization> regularization = new ArrayList<Regularization>();
        protected List<Regularization> regularizationBias = new ArrayList<Regularization>();
        protected IUpdater iupdater = null;
        protected IUpdater biasUpdater = null;
        protected GradientNormalization gradientNormalization = null;
        protected double gradientNormalizationThreshold = Double.NaN;
        protected IWeightNoise weightNoise;

        public T activation(IActivation activationFunction) {
            this.setActivationFn(activationFunction);
            return (T)this;
        }

        public T activation(Activation activation) {
            return this.activation(activation.getActivationFunction());
        }

        public T weightInit(IWeightInit weightInit) {
            this.setWeightInitFn(weightInit);
            return (T)this;
        }

        public T weightInit(WeightInit weightInit) {
            if (weightInit == WeightInit.DISTRIBUTION) {
                throw new UnsupportedOperationException("Not supported!, Use weightInit(Distribution distribution) instead!");
            }
            this.setWeightInitFn(weightInit.getWeightInitFunction());
            return (T)this;
        }

        public T weightInit(Distribution distribution) {
            return this.weightInit(new WeightInitDistribution(distribution));
        }

        public T biasInit(double biasInit) {
            this.setBiasInit(biasInit);
            return (T)this;
        }

        public T gainInit(double gainInit) {
            this.gainInit = gainInit;
            return (T)this;
        }

        @Deprecated
        public T dist(Distribution dist) {
            return this.weightInit(dist);
        }

        public T l1(double l1) {
            NetworkUtils.removeInstances(this.regularization, L1Regularization.class);
            if (l1 > 0.0) {
                this.regularization.add((Regularization)new L1Regularization(l1));
            }
            return (T)this;
        }

        public T l2(double l2) {
            NetworkUtils.removeInstances(this.regularization, L2Regularization.class);
            if (l2 > 0.0) {
                NetworkUtils.removeInstancesWithWarning(this.regularization, WeightDecay.class, "WeightDecay regularization removed: incompatible with added L2 regularization");
                this.regularization.add((Regularization)new L2Regularization(l2));
            }
            return (T)this;
        }

        public T l1Bias(double l1Bias) {
            NetworkUtils.removeInstances(this.regularizationBias, L1Regularization.class);
            if (l1Bias > 0.0) {
                this.regularizationBias.add((Regularization)new L1Regularization(l1Bias));
            }
            return (T)this;
        }

        public T l2Bias(double l2Bias) {
            NetworkUtils.removeInstances(this.regularizationBias, L2Regularization.class);
            if (l2Bias > 0.0) {
                NetworkUtils.removeInstancesWithWarning(this.regularizationBias, WeightDecay.class, "WeightDecay regularization removed: incompatible with added L2 regularization");
                this.regularizationBias.add((Regularization)new L2Regularization(l2Bias));
            }
            return (T)this;
        }

        public Builder weightDecay(double coefficient) {
            return this.weightDecay(coefficient, true);
        }

        public Builder weightDecay(double coefficient, boolean applyLR) {
            NetworkUtils.removeInstances(this.regularization, WeightDecay.class);
            if (coefficient > 0.0) {
                NetworkUtils.removeInstancesWithWarning(this.regularization, L2Regularization.class, "L2 regularization removed: incompatible with added WeightDecay regularization");
                this.regularization.add((Regularization)new WeightDecay(coefficient, applyLR));
            }
            return this;
        }

        public Builder weightDecayBias(double coefficient) {
            return this.weightDecayBias(coefficient, true);
        }

        public Builder weightDecayBias(double coefficient, boolean applyLR) {
            NetworkUtils.removeInstances(this.regularizationBias, WeightDecay.class);
            if (coefficient > 0.0) {
                NetworkUtils.removeInstancesWithWarning(this.regularizationBias, L2Regularization.class, "L2 regularization removed: incompatible with added WeightDecay regularization");
                this.regularizationBias.add((Regularization)new WeightDecay(coefficient, applyLR));
            }
            return this;
        }

        public Builder regularization(List<Regularization> regularization) {
            this.setRegularization(regularization);
            return this;
        }

        public Builder regularizationBias(List<Regularization> regularizationBias) {
            this.setRegularizationBias(regularizationBias);
            return this;
        }

        @Deprecated
        public T updater(Updater updater) {
            return this.updater(updater.getIUpdaterWithDefaultConfig());
        }

        public T updater(IUpdater updater) {
            this.setIupdater(updater);
            return (T)this;
        }

        public T biasUpdater(IUpdater biasUpdater) {
            this.setBiasUpdater(biasUpdater);
            return (T)this;
        }

        public T gradientNormalization(GradientNormalization gradientNormalization) {
            this.setGradientNormalization(gradientNormalization);
            return (T)this;
        }

        public T gradientNormalizationThreshold(double threshold) {
            this.setGradientNormalizationThreshold(threshold);
            return (T)this;
        }

        public T weightNoise(IWeightNoise weightNoise) {
            this.setWeightNoise(weightNoise);
            return (T)this;
        }

        public IActivation getActivationFn() {
            return this.activationFn;
        }

        public IWeightInit getWeightInitFn() {
            return this.weightInitFn;
        }

        public double getBiasInit() {
            return this.biasInit;
        }

        public double getGainInit() {
            return this.gainInit;
        }

        public List<Regularization> getRegularization() {
            return this.regularization;
        }

        public List<Regularization> getRegularizationBias() {
            return this.regularizationBias;
        }

        public IUpdater getIupdater() {
            return this.iupdater;
        }

        public IUpdater getBiasUpdater() {
            return this.biasUpdater;
        }

        public GradientNormalization getGradientNormalization() {
            return this.gradientNormalization;
        }

        public double getGradientNormalizationThreshold() {
            return this.gradientNormalizationThreshold;
        }

        public IWeightNoise getWeightNoise() {
            return this.weightNoise;
        }

        public void setActivationFn(IActivation activationFn) {
            this.activationFn = activationFn;
        }

        public void setWeightInitFn(IWeightInit weightInitFn) {
            this.weightInitFn = weightInitFn;
        }

        public void setBiasInit(double biasInit) {
            this.biasInit = biasInit;
        }

        public void setGainInit(double gainInit) {
            this.gainInit = gainInit;
        }

        public void setRegularization(List<Regularization> regularization) {
            this.regularization = regularization;
        }

        public void setRegularizationBias(List<Regularization> regularizationBias) {
            this.regularizationBias = regularizationBias;
        }

        public void setIupdater(IUpdater iupdater) {
            this.iupdater = iupdater;
        }

        public void setBiasUpdater(IUpdater biasUpdater) {
            this.biasUpdater = biasUpdater;
        }

        public void setGradientNormalization(GradientNormalization gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
        }

        public void setGradientNormalizationThreshold(double gradientNormalizationThreshold) {
            this.gradientNormalizationThreshold = gradientNormalizationThreshold;
        }

        public void setWeightNoise(IWeightNoise weightNoise) {
            this.weightNoise = weightNoise;
        }
    }
}

