/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.graph;

import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.inputs.InvalidInputTypeException;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class PoolHelperVertex
extends GraphVertex {
    @Override
    public PoolHelperVertex clone() {
        return new PoolHelperVertex();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof PoolHelperVertex;
    }

    @Override
    public int hashCode() {
        return 433682566;
    }

    @Override
    public long numParams(boolean backprop) {
        return 0L;
    }

    @Override
    public int minVertexInputs() {
        return 1;
    }

    @Override
    public int maxVertexInputs() {
        return 1;
    }

    @Override
    public org.deeplearning4j.nn.graph.vertex.GraphVertex instantiate(ComputationGraph graph, String name, int idx, INDArray paramsView, boolean initializeParams, DataType networkDatatype) {
        return new org.deeplearning4j.nn.graph.vertex.impl.PoolHelperVertex(graph, name, idx, networkDatatype);
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType ... vertexInputs) throws InvalidInputTypeException {
        if (vertexInputs.length == 1) {
            return vertexInputs[0];
        }
        InputType first = vertexInputs[0];
        if (first.getType() == InputType.Type.CNNFlat) {
            throw new InvalidInputTypeException("Invalid input: MergeVertex cannot currently merge CNN data in flattened format. Got: " + vertexInputs);
        }
        if (first.getType() != InputType.Type.CNN) {
            int size = 0;
            InputType.Type type = null;
            for (int i = 0; i < vertexInputs.length; ++i) {
                long thisSize;
                if (vertexInputs[i].getType() != first.getType()) {
                    throw new InvalidInputTypeException("Invalid input: MergeVertex cannot merge activations of different types: first type = " + (Object)((Object)first.getType()) + ", input type " + (i + 1) + " = " + (Object)((Object)vertexInputs[i].getType()));
                }
                switch (vertexInputs[i].getType()) {
                    case FF: {
                        thisSize = ((InputType.InputTypeFeedForward)vertexInputs[i]).getSize();
                        type = InputType.Type.FF;
                        break;
                    }
                    case RNN: {
                        thisSize = ((InputType.InputTypeRecurrent)vertexInputs[i]).getSize();
                        type = InputType.Type.RNN;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown input type: " + vertexInputs[i]);
                    }
                }
                size = thisSize <= 0L ? -1 : (int)((long)size + thisSize);
            }
            if (size > 0) {
                if (type == InputType.Type.FF) {
                    return InputType.feedForward(size);
                }
                return InputType.recurrent(size);
            }
            if (type == InputType.Type.FF) {
                return InputType.feedForward(-1L);
            }
            return InputType.recurrent(-1L);
        }
        InputType.InputTypeConvolutional firstConv = (InputType.InputTypeConvolutional)first;
        int fd = (int)firstConv.getChannels();
        int fw = (int)firstConv.getWidth();
        int fh = (int)firstConv.getHeight();
        int depthSum = fd;
        for (int i = 1; i < vertexInputs.length; ++i) {
            if (vertexInputs[i].getType() != InputType.Type.CNN) {
                throw new InvalidInputTypeException("Invalid input: MergeVertex cannot process activations of different types: first type = " + (Object)((Object)InputType.Type.CNN) + ", input type " + (i + 1) + " = " + (Object)((Object)vertexInputs[i].getType()));
            }
            InputType.InputTypeConvolutional otherConv = (InputType.InputTypeConvolutional)vertexInputs[i];
            int od = (int)otherConv.getChannels();
            int ow = (int)otherConv.getWidth();
            int oh = (int)otherConv.getHeight();
            if (fw != ow || fh != oh) {
                throw new InvalidInputTypeException("Invalid input: MergeVertex cannot merge CNN activations of different width/heights:first [channels,width,height] = [" + fd + "," + fw + "," + fh + "], input " + i + " = [" + od + "," + ow + "," + oh + "]");
            }
            depthSum += od;
        }
        return InputType.convolutional(fh, fw, depthSum);
    }

    @Override
    public MemoryReport getMemoryReport(InputType ... inputTypes) {
        InputType outputType = this.getOutputType(-1, inputTypes);
        return new LayerMemoryReport.Builder(null, PoolHelperVertex.class, inputTypes[0], outputType).standardMemory(0L, 0L).workingMemory(0L, 0L, 0L, 0L).cacheMemory(0L, 0L).build();
    }
}

