/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.adapters;

import org.nd4j.adapters.OutputAdapter;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Regression2dAdapter
implements OutputAdapter<double[][]> {
    private static final Logger log = LoggerFactory.getLogger(Regression2dAdapter.class);

    public double[][] apply(INDArray ... outputs) {
        Preconditions.checkArgument((outputs.length == 1 ? 1 : 0) != 0, (String)"Argmax adapter can have only 1 output");
        INDArray array = outputs[0];
        Preconditions.checkArgument((array.rank() < 3 ? 1 : 0) != 0, (String)"Argmax adapter requires 2D or 1D output");
        if (array.rank() == 2 && !array.isVector()) {
            return array.toDoubleMatrix();
        }
        double[][] result = new double[1][(int)array.length()];
        int e = 0;
        while ((long)e < array.length()) {
            result[0][e] = array.getDouble((long)e);
            ++e;
        }
        return result;
    }
}

