/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.weights.embeddings;

import lombok.NonNull;
import org.deeplearning4j.nn.weights.embeddings.EmbeddingInitializer;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ArrayEmbeddingInitializer
implements EmbeddingInitializer {
    private final INDArray embeddings;

    public ArrayEmbeddingInitializer(@NonNull INDArray embeddings) {
        if (embeddings == null) {
            throw new NullPointerException("embeddings is marked @NonNull but is null");
        }
        Preconditions.checkState((embeddings.rank() == 2 ? 1 : 0) != 0, (String)"Embedding array must be rank 2 with shape [vocabSize, vectorSize], got array with shape %ndShape", (Object)embeddings);
        this.embeddings = embeddings;
    }

    @Override
    public void loadWeightsInto(INDArray array) {
        array.assign(this.embeddings);
    }

    @Override
    public long vocabSize() {
        return this.embeddings.size(0);
    }

    @Override
    public int vectorSize() {
        return (int)this.embeddings.size(1);
    }

    @Override
    public boolean jsonSerializable() {
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayEmbeddingInitializer)) {
            return false;
        }
        ArrayEmbeddingInitializer other = (ArrayEmbeddingInitializer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        INDArray this$embeddings = this.embeddings;
        INDArray other$embeddings = other.embeddings;
        return !(this$embeddings == null ? other$embeddings != null : !this$embeddings.equals(other$embeddings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArrayEmbeddingInitializer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        INDArray $embeddings = this.embeddings;
        result = result * 59 + ($embeddings == null ? 43 : $embeddings.hashCode());
        return result;
    }
}

