/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.weights;

import org.deeplearning4j.nn.weights.IWeightInit;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.factory.Nd4j;

public class WeightInitReluUniform
implements IWeightInit {
    @Override
    public INDArray init(double fanIn, double fanOut, long[] shape, char order, INDArray paramView) {
        double u = Math.sqrt(6.0 / fanIn);
        Nd4j.rand((INDArray)paramView, (Distribution)Nd4j.getDistributions().createUniform(-u, u));
        return paramView.reshape(order, shape);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeightInitReluUniform)) {
            return false;
        }
        WeightInitReluUniform other = (WeightInitReluUniform)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof WeightInitReluUniform;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }
}

