/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.recurrent;

import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.recurrent.BaseRecurrentLayer;
import org.deeplearning4j.nn.layers.recurrent.FwdPassReturn;
import org.deeplearning4j.nn.layers.recurrent.LSTMHelpers;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GravesBidirectionalLSTM
extends BaseRecurrentLayer<org.deeplearning4j.nn.conf.layers.GravesBidirectionalLSTM> {
    private static final Logger log = LoggerFactory.getLogger(GravesBidirectionalLSTM.class);
    protected FwdPassReturn cachedPassForward;
    protected FwdPassReturn cachedPassBackward;

    public GravesBidirectionalLSTM(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not supported " + this.layerId());
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        return this.backpropGradientHelper(epsilon, false, -1, workspaceMgr);
    }

    @Override
    public Pair<Gradient, INDArray> tbpttBackpropGradient(INDArray epsilon, int tbpttBackwardLength, LayerWorkspaceMgr workspaceMgr) {
        return this.backpropGradientHelper(epsilon, true, tbpttBackwardLength, workspaceMgr);
    }

    private Pair<Gradient, INDArray> backpropGradientHelper(INDArray epsilon, boolean truncatedBPTT, int tbpttBackwardLength, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(true);
        if (truncatedBPTT) {
            throw new UnsupportedOperationException("Time step for bidirectional RNN not supported: it has to run on a batch of data all at once " + this.layerId());
        }
        FwdPassReturn fwdPass = this.activateHelperDirectional(true, null, null, true, true, workspaceMgr);
        Pair<Gradient, INDArray> forwardsGradient = LSTMHelpers.backpropGradientHelper(this.conf, ((org.deeplearning4j.nn.conf.layers.GravesBidirectionalLSTM)this.layerConf()).getGateActivationFn(), this.input, this.getParam("RWF"), this.getParam("WF"), epsilon, truncatedBPTT, tbpttBackwardLength, fwdPass, true, "WF", "RWF", "bF", this.gradientViews, this.maskArray, true, null, workspaceMgr);
        FwdPassReturn backPass = this.activateHelperDirectional(true, null, null, true, false, workspaceMgr);
        Pair<Gradient, INDArray> backwardsGradient = LSTMHelpers.backpropGradientHelper(this.conf, ((org.deeplearning4j.nn.conf.layers.GravesBidirectionalLSTM)this.layerConf()).getGateActivationFn(), this.input, this.getParam("RWB"), this.getParam("WB"), epsilon, truncatedBPTT, tbpttBackwardLength, backPass, false, "WB", "RWB", "bB", this.gradientViews, this.maskArray, true, null, workspaceMgr);
        DefaultGradient combinedGradient = new DefaultGradient();
        for (Map.Entry<String, INDArray> entry : ((Gradient)forwardsGradient.getFirst()).gradientForVariable().entrySet()) {
            combinedGradient.setGradientFor(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, INDArray> entry : ((Gradient)backwardsGradient.getFirst()).gradientForVariable().entrySet()) {
            combinedGradient.setGradientFor(entry.getKey(), entry.getValue());
        }
        DefaultGradient correctOrderedGradient = new DefaultGradient();
        for (String key : this.params.keySet()) {
            correctOrderedGradient.setGradientFor(key, combinedGradient.getGradientFor(key));
        }
        INDArray iNDArray = (INDArray)forwardsGradient.getSecond();
        INDArray backwardsEpsilon = (INDArray)backwardsGradient.getSecond();
        INDArray combinedEpsilon = iNDArray.addi(backwardsEpsilon);
        return new Pair((Object)correctOrderedGradient, (Object)combinedEpsilon);
    }

    @Override
    public INDArray activate(INDArray input, boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.setInput(input, workspaceMgr);
        return this.activateOutput(training, false, workspaceMgr);
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        return this.activateOutput(training, false, workspaceMgr);
    }

    private INDArray activateOutput(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        FwdPassReturn backwardsEval;
        FwdPassReturn forwardsEval;
        this.assertInputSet(false);
        if (this.cacheMode != CacheMode.NONE && this.cachedPassForward != null && this.cachedPassBackward != null) {
            forwardsEval = this.cachedPassForward;
            backwardsEval = this.cachedPassBackward;
            this.cachedPassBackward = null;
            this.cachedPassForward = null;
        } else {
            forwardsEval = LSTMHelpers.activateHelper(this, this.conf, ((org.deeplearning4j.nn.conf.layers.GravesBidirectionalLSTM)this.layerConf()).getGateActivationFn(), this.input, this.getParam("RWF"), this.getParam("WF"), this.getParam("bF"), training, null, null, forBackprop || this.cacheMode != CacheMode.NONE && training, true, "WF", this.maskArray, true, null, forBackprop ? this.cacheMode : CacheMode.NONE, workspaceMgr);
            backwardsEval = LSTMHelpers.activateHelper(this, this.conf, ((org.deeplearning4j.nn.conf.layers.GravesBidirectionalLSTM)this.layerConf()).getGateActivationFn(), this.input, this.getParam("RWB"), this.getParam("WB"), this.getParam("bB"), training, null, null, forBackprop || this.cacheMode != CacheMode.NONE && training, false, "WB", this.maskArray, true, null, forBackprop ? this.cacheMode : CacheMode.NONE, workspaceMgr);
            this.cachedPassForward = forwardsEval;
            this.cachedPassBackward = backwardsEval;
        }
        INDArray fwdOutput = forwardsEval.fwdPassOutput;
        INDArray backOutput = backwardsEval.fwdPassOutput;
        INDArray totalOutput = training && this.cacheMode != CacheMode.NONE && !forBackprop ? fwdOutput.add(backOutput) : fwdOutput.addi(backOutput);
        return totalOutput;
    }

    private FwdPassReturn activateHelperDirectional(boolean training, INDArray prevOutputActivations, INDArray prevMemCellState, boolean forBackprop, boolean forwards, LayerWorkspaceMgr workspaceMgr) {
        if (this.cacheMode == null) {
            this.cacheMode = CacheMode.NONE;
        }
        if (this.cacheMode != CacheMode.NONE && forwards && forBackprop && this.cachedPassForward != null) {
            FwdPassReturn ret = this.cachedPassForward;
            this.cachedPassForward = null;
            return ret;
        }
        if (this.cacheMode != CacheMode.NONE && !forwards && forBackprop) {
            FwdPassReturn ret = this.cachedPassBackward;
            this.cachedPassBackward = null;
            return ret;
        }
        String recurrentKey = "RWF";
        String inputKey = "WF";
        String biasKey = "bF";
        if (!forwards) {
            recurrentKey = "RWB";
            inputKey = "WB";
            biasKey = "bB";
        }
        return LSTMHelpers.activateHelper(this, this.conf, ((org.deeplearning4j.nn.conf.layers.GravesBidirectionalLSTM)this.layerConf()).getGateActivationFn(), this.input, this.getParam(recurrentKey), this.getParam(inputKey), this.getParam(biasKey), training, prevOutputActivations, prevMemCellState, forBackprop, forwards, inputKey, this.maskArray, true, null, forBackprop ? this.cacheMode : CacheMode.NONE, workspaceMgr);
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.RECURRENT;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public INDArray rnnTimeStep(INDArray input, LayerWorkspaceMgr workspaceMgr) {
        throw new UnsupportedOperationException("you can not time step a bidirectional RNN, it has to run on a batch of data all at once " + this.layerId());
    }

    @Override
    public INDArray rnnActivateUsingStoredState(INDArray input, boolean training, boolean storeLastForTBPTT, LayerWorkspaceMgr workspaceMgr) {
        throw new UnsupportedOperationException("Cannot set stored state: bidirectional RNNs don't have stored state " + this.layerId());
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        this.maskArray = maskArray;
        this.maskState = currentMaskState;
        return new Pair((Object)maskArray, (Object)MaskState.Active);
    }
}

