/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.SpaceToBatchLayer;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceToBatch
extends AbstractLayer<SpaceToBatchLayer> {
    private static final Logger log = LoggerFactory.getLogger(SpaceToBatch.class);

    public SpaceToBatch(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    private int[] getBlocks() {
        return ((SpaceToBatchLayer)this.layerConf()).getBlocks();
    }

    private int[][] getPadding() {
        return ((SpaceToBatchLayer)this.layerConf()).getPadding();
    }

    private INDArray getBlocksArray() {
        int[] intBlocks = ((SpaceToBatchLayer)this.layerConf()).getBlocks();
        return Nd4j.create((double[])new double[]{intBlocks[0], intBlocks[1]});
    }

    private INDArray getPaddingArray() {
        int[][] intPad = ((SpaceToBatchLayer)this.layerConf()).getPadding();
        return Nd4j.create((double[][])new double[][]{{intPad[0][0], intPad[0][1]}, {intPad[1][0], intPad[1][1]}});
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.CONVOLUTIONAL;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(true);
        INDArray input = this.input.castTo(this.dataType);
        long miniBatch = input.size(0);
        long inDepth = input.size(1);
        long inH = input.size(2);
        long inW = input.size(3);
        INDArray outEpsilon = workspaceMgr.createUninitialized(ArrayType.ACTIVATION_GRAD, input.dataType(), new long[]{miniBatch, inDepth, inH, inW}, 'c');
        DefaultGradient gradient = new DefaultGradient();
        DynamicCustomOp op = DynamicCustomOp.builder((String)"batch_to_space").addInputs(new INDArray[]{epsilon, this.getBlocksArray(), this.getPaddingArray()}).addOutputs(new INDArray[]{outEpsilon}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        outEpsilon = this.backpropDropOutIfPresent(outEpsilon);
        return new Pair((Object)gradient, (Object)outEpsilon);
    }

    protected INDArray preOutput(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        this.applyDropOutIfNecessary(training, null);
        if (this.input.rank() != 4) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to space to batch with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape [minibatchSize, channels, inputHeight, inputWidth]. " + this.layerId());
        }
        if (this.preOutput != null && forBackprop) {
            return this.preOutput;
        }
        long inMiniBatch = this.input.size(0);
        long depth = this.input.size(1);
        long inH = this.input.size(2);
        long inW = this.input.size(3);
        int[] blocks = this.getBlocks();
        int[][] padding = this.getPadding();
        long paddedH = inH + (long)padding[0][0] + (long)padding[0][1];
        long paddedW = inW + (long)padding[1][0] + (long)padding[1][1];
        long outH = paddedH / (long)blocks[0];
        long outW = paddedW / (long)blocks[1];
        long outMiniBatch = inMiniBatch * (long)blocks[0] * (long)blocks[1];
        INDArray out = workspaceMgr.create(ArrayType.ACTIVATIONS, this.input.dataType(), new long[]{outMiniBatch, depth, outH, outW}, 'c');
        DynamicCustomOp op = DynamicCustomOp.builder((String)"space_to_batch").addInputs(new INDArray[]{this.input, this.getBlocksArray(), this.getPaddingArray()}).addOutputs(new INDArray[]{out}).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        return out;
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        return this.preOutput(training, false, workspaceMgr);
    }

    @Override
    public double calcRegularizationScore(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not supported - no parameters");
    }

    @Override
    public long numParams() {
        return 0L;
    }

    @Override
    public double score() {
        return 0.0;
    }

    @Override
    public void update(INDArray gradient, String paramType) {
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public INDArray getParam(String param) {
        return this.params();
    }

    @Override
    public void setParams(INDArray params) {
    }
}

