/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers.recurrent;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.BaseRecurrentLayer;
import org.deeplearning4j.nn.conf.layers.LayerValidation;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.params.SimpleRnnParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class SimpleRnn
extends BaseRecurrentLayer {
    private boolean hasLayerNorm = false;

    protected SimpleRnn(Builder builder) {
        super(builder);
        this.hasLayerNorm = builder.hasLayerNorm;
    }

    private SimpleRnn() {
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        LayerValidation.assertNInNOutSet("SimpleRnn", this.getLayerName(), layerIndex, this.getNIn(), this.getNOut());
        org.deeplearning4j.nn.layers.recurrent.SimpleRnn ret = new org.deeplearning4j.nn.layers.recurrent.SimpleRnn(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return SimpleRnnParamInitializer.getInstance();
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        return null;
    }

    public boolean hasLayerNorm() {
        return this.hasLayerNorm;
    }

    public boolean isHasLayerNorm() {
        return this.hasLayerNorm;
    }

    public void setHasLayerNorm(boolean hasLayerNorm) {
        this.hasLayerNorm = hasLayerNorm;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleRnn)) {
            return false;
        }
        SimpleRnn other = (SimpleRnn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.isHasLayerNorm() == other.isHasLayerNorm();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SimpleRnn;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasLayerNorm() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "SimpleRnn(hasLayerNorm=" + this.isHasLayerNorm() + ")";
    }

    public static class Builder
    extends BaseRecurrentLayer.Builder<Builder> {
        private boolean hasLayerNorm = false;

        @Override
        public SimpleRnn build() {
            return new SimpleRnn(this);
        }

        public Builder hasLayerNorm(boolean hasLayerNorm) {
            this.hasLayerNorm = hasLayerNorm;
            return this;
        }

        public boolean isHasLayerNorm() {
            return this.hasLayerNorm;
        }

        public void setHasLayerNorm(boolean hasLayerNorm) {
            this.hasLayerNorm = hasLayerNorm;
        }
    }
}

