/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.NoParamLayer;
import org.deeplearning4j.nn.conf.layers.ZeroPaddingLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.params.EmptyParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.deeplearning4j.util.ValidationUtils;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ZeroPadding1DLayer
extends NoParamLayer {
    private int[] padding;

    private ZeroPadding1DLayer(Builder builder) {
        super(builder);
        this.padding = builder.padding;
    }

    public ZeroPadding1DLayer(int padding) {
        this(new Builder(padding));
    }

    public ZeroPadding1DLayer(int padLeft, int padRight) {
        this(new Builder(padLeft, padRight));
    }

    public ZeroPadding1DLayer(int[] padding) {
        this(new Builder(padding));
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        org.deeplearning4j.nn.layers.convolution.ZeroPadding1DLayer ret = new org.deeplearning4j.nn.layers.convolution.ZeroPadding1DLayer(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return EmptyParamInitializer.getInstance();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.RNN) {
            throw new IllegalStateException("Invalid input for 1D CNN layer (layer index = " + layerIndex + ", layer name = \"" + this.getLayerName() + "\"): expect RNN input type with size > 0. Got: " + inputType);
        }
        InputType.InputTypeRecurrent recurrent = (InputType.InputTypeRecurrent)inputType;
        return InputType.recurrent(recurrent.getSize(), recurrent.getTimeSeriesLength() + (long)this.padding[0] + (long)this.padding[1]);
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for ZeroPadding1DLayer layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreprocessorForInputTypeRnnLayers(inputType, this.getLayerName());
    }

    @Override
    public boolean isPretrainParam(String paramName) {
        throw new UnsupportedOperationException("ZeroPaddingLayer does not contain parameters");
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        InputType outputType = this.getOutputType(-1, inputType);
        return new LayerMemoryReport.Builder(this.layerName, ZeroPaddingLayer.class, inputType, outputType).standardMemory(0L, 0L).workingMemory(0L, 0L, MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    public int[] getPadding() {
        return this.padding;
    }

    public void setPadding(int[] padding) {
        this.padding = padding;
    }

    @Override
    public String toString() {
        return "ZeroPadding1DLayer(padding=" + Arrays.toString(this.getPadding()) + ")";
    }

    public ZeroPadding1DLayer() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZeroPadding1DLayer)) {
            return false;
        }
        ZeroPadding1DLayer other = (ZeroPadding1DLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.getPadding(), other.getPadding());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ZeroPadding1DLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getPadding());
        return result;
    }

    public static class Builder
    extends Layer.Builder<Builder> {
        private int[] padding = new int[]{0, 0};

        public void setPadding(int ... padding) {
            this.padding = ValidationUtils.validate2NonNegative(padding, false, "padding");
        }

        public Builder(int padding) {
            this(padding, padding);
        }

        public Builder(int padLeft, int padRight) {
            this(new int[]{padLeft, padRight});
        }

        public Builder(int ... padding) {
            if (padding == null) {
                throw new NullPointerException("padding is marked @NonNull but is null");
            }
            this.setPadding(padding);
        }

        @Override
        public ZeroPadding1DLayer build() {
            for (int p : this.padding) {
                if (p >= 0) continue;
                throw new IllegalStateException("Invalid zero padding layer config: padding [left, right] must be > 0 for all elements. Got: " + Arrays.toString(this.padding));
            }
            return new ZeroPadding1DLayer(this);
        }

        public int[] getPadding() {
            return this.padding;
        }
    }
}

