/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.LayerValidation;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.params.ConvolutionParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.deeplearning4j.util.ConvolutionUtils;
import org.deeplearning4j.util.ValidationUtils;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ConvolutionLayer
extends FeedForwardLayer {
    protected boolean hasBias = true;
    protected ConvolutionMode convolutionMode = ConvolutionMode.Truncate;
    protected int[] dilation = new int[]{1, 1};
    protected int[] kernelSize;
    protected int[] stride;
    protected int[] padding;
    protected boolean cudnnAllowFallback = true;
    protected AlgoMode cudnnAlgoMode = AlgoMode.PREFER_FASTEST;
    protected FwdAlgo cudnnFwdAlgo;
    protected BwdFilterAlgo cudnnBwdFilterAlgo;
    protected BwdDataAlgo cudnnBwdDataAlgo;

    protected ConvolutionLayer(BaseConvBuilder<?> builder) {
        super(builder);
        int dim = builder.convolutionDim;
        this.hasBias = builder.hasBias;
        this.convolutionMode = builder.convolutionMode;
        this.dilation = builder.dilation;
        if (builder.kernelSize.length != dim) {
            throw new IllegalArgumentException("Kernel argument should be a " + dim + "d array");
        }
        this.kernelSize = builder.kernelSize;
        if (builder.stride.length != dim) {
            throw new IllegalArgumentException("Strides argument should be a " + dim + "d array");
        }
        this.stride = builder.stride;
        if (builder.padding.length != dim) {
            throw new IllegalArgumentException("Padding argument should be a " + dim + "d array");
        }
        this.padding = builder.padding;
        if (builder.dilation.length != dim) {
            throw new IllegalArgumentException("Dilation argument should be a " + dim + "d array");
        }
        this.dilation = builder.dilation;
        this.cudnnAlgoMode = builder.cudnnAlgoMode;
        this.cudnnFwdAlgo = builder.cudnnFwdAlgo;
        this.cudnnBwdFilterAlgo = builder.cudnnBwdFilterAlgo;
        this.cudnnBwdDataAlgo = builder.cudnnBwdDataAlgo;
        this.cudnnAllowFallback = builder.cudnnAllowFallback;
        this.initializeConstraints(builder);
    }

    public boolean hasBias() {
        return this.hasBias;
    }

    @Override
    public ConvolutionLayer clone() {
        ConvolutionLayer clone = (ConvolutionLayer)super.clone();
        if (clone.kernelSize != null) {
            clone.kernelSize = (int[])clone.kernelSize.clone();
        }
        if (clone.stride != null) {
            clone.stride = (int[])clone.stride.clone();
        }
        if (clone.padding != null) {
            clone.padding = (int[])clone.padding.clone();
        }
        return clone;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        LayerValidation.assertNInNOutSet("ConvolutionLayer", this.getLayerName(), layerIndex, this.getNIn(), this.getNOut());
        org.deeplearning4j.nn.layers.convolution.ConvolutionLayer ret = new org.deeplearning4j.nn.layers.convolution.ConvolutionLayer(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return ConvolutionParamInitializer.getInstance();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN) {
            throw new IllegalStateException("Invalid input for Convolution layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN input, got " + inputType);
        }
        return InputTypeUtil.getOutputTypeCnnLayers(inputType, this.kernelSize, this.stride, this.padding, this.dilation, this.convolutionMode, this.nOut, layerIndex, this.getLayerName(), ConvolutionLayer.class);
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN) {
            throw new IllegalStateException("Invalid input for Convolution layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN input, got " + inputType);
        }
        if (this.nIn <= 0L || override) {
            InputType.InputTypeConvolutional c = (InputType.InputTypeConvolutional)inputType;
            this.nIn = c.getChannels();
        }
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for Convolution layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreProcessorForInputTypeCnnLayers(inputType, this.getLayerName());
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        long paramSize = this.initializer().numParams(this);
        int updaterStateSize = (int)this.getIUpdater().stateSize(paramSize);
        InputType.InputTypeConvolutional c = (InputType.InputTypeConvolutional)inputType;
        InputType.InputTypeConvolutional outputType = (InputType.InputTypeConvolutional)this.getOutputType(-1, inputType);
        long im2colSizePerEx = c.getChannels() * outputType.getHeight() * outputType.getWidth() * (long)this.kernelSize[0] * (long)this.kernelSize[1];
        HashMap<CacheMode, Long> trainWorkingMemoryPerEx = new HashMap<CacheMode, Long>();
        HashMap<CacheMode, Long> cachedPerEx = new HashMap<CacheMode, Long>();
        for (CacheMode cm : CacheMode.values()) {
            long trainWorkingSizePerEx;
            long cacheMemSizePerEx = 0L;
            if (cm == CacheMode.NONE) {
                trainWorkingSizePerEx = 2L * im2colSizePerEx;
            } else {
                cacheMemSizePerEx = im2colSizePerEx;
                trainWorkingSizePerEx = im2colSizePerEx;
            }
            if (this.getIDropout() != null) {
                trainWorkingSizePerEx += inputType.arrayElementsPerExample();
            }
            trainWorkingMemoryPerEx.put(cm, trainWorkingSizePerEx);
            cachedPerEx.put(cm, cacheMemSizePerEx);
        }
        return new LayerMemoryReport.Builder(this.layerName, ConvolutionLayer.class, inputType, outputType).standardMemory(paramSize, updaterStateSize).workingMemory(0L, im2colSizePerEx, MemoryReport.CACHE_MODE_ALL_ZEROS, trainWorkingMemoryPerEx).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, cachedPerEx).build();
    }

    public boolean isHasBias() {
        return this.hasBias;
    }

    public ConvolutionMode getConvolutionMode() {
        return this.convolutionMode;
    }

    public int[] getDilation() {
        return this.dilation;
    }

    public int[] getKernelSize() {
        return this.kernelSize;
    }

    public int[] getStride() {
        return this.stride;
    }

    public int[] getPadding() {
        return this.padding;
    }

    public boolean isCudnnAllowFallback() {
        return this.cudnnAllowFallback;
    }

    public AlgoMode getCudnnAlgoMode() {
        return this.cudnnAlgoMode;
    }

    public FwdAlgo getCudnnFwdAlgo() {
        return this.cudnnFwdAlgo;
    }

    public BwdFilterAlgo getCudnnBwdFilterAlgo() {
        return this.cudnnBwdFilterAlgo;
    }

    public BwdDataAlgo getCudnnBwdDataAlgo() {
        return this.cudnnBwdDataAlgo;
    }

    public void setHasBias(boolean hasBias) {
        this.hasBias = hasBias;
    }

    public void setConvolutionMode(ConvolutionMode convolutionMode) {
        this.convolutionMode = convolutionMode;
    }

    public void setDilation(int[] dilation) {
        this.dilation = dilation;
    }

    public void setKernelSize(int[] kernelSize) {
        this.kernelSize = kernelSize;
    }

    public void setStride(int[] stride) {
        this.stride = stride;
    }

    public void setPadding(int[] padding) {
        this.padding = padding;
    }

    public void setCudnnAllowFallback(boolean cudnnAllowFallback) {
        this.cudnnAllowFallback = cudnnAllowFallback;
    }

    public void setCudnnAlgoMode(AlgoMode cudnnAlgoMode) {
        this.cudnnAlgoMode = cudnnAlgoMode;
    }

    public void setCudnnFwdAlgo(FwdAlgo cudnnFwdAlgo) {
        this.cudnnFwdAlgo = cudnnFwdAlgo;
    }

    public void setCudnnBwdFilterAlgo(BwdFilterAlgo cudnnBwdFilterAlgo) {
        this.cudnnBwdFilterAlgo = cudnnBwdFilterAlgo;
    }

    public void setCudnnBwdDataAlgo(BwdDataAlgo cudnnBwdDataAlgo) {
        this.cudnnBwdDataAlgo = cudnnBwdDataAlgo;
    }

    public ConvolutionLayer() {
    }

    @Override
    public String toString() {
        return "ConvolutionLayer(super=" + super.toString() + ", hasBias=" + this.isHasBias() + ", convolutionMode=" + (Object)((Object)this.getConvolutionMode()) + ", dilation=" + Arrays.toString(this.getDilation()) + ", kernelSize=" + Arrays.toString(this.getKernelSize()) + ", stride=" + Arrays.toString(this.getStride()) + ", padding=" + Arrays.toString(this.getPadding()) + ", cudnnAllowFallback=" + this.isCudnnAllowFallback() + ", cudnnAlgoMode=" + (Object)((Object)this.getCudnnAlgoMode()) + ", cudnnFwdAlgo=" + (Object)((Object)this.getCudnnFwdAlgo()) + ", cudnnBwdFilterAlgo=" + (Object)((Object)this.getCudnnBwdFilterAlgo()) + ", cudnnBwdDataAlgo=" + (Object)((Object)this.getCudnnBwdDataAlgo()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvolutionLayer)) {
            return false;
        }
        ConvolutionLayer other = (ConvolutionLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isHasBias() != other.isHasBias()) {
            return false;
        }
        ConvolutionMode this$convolutionMode = this.getConvolutionMode();
        ConvolutionMode other$convolutionMode = other.getConvolutionMode();
        if (this$convolutionMode == null ? other$convolutionMode != null : !((Object)((Object)this$convolutionMode)).equals((Object)other$convolutionMode)) {
            return false;
        }
        if (!Arrays.equals(this.getDilation(), other.getDilation())) {
            return false;
        }
        if (!Arrays.equals(this.getKernelSize(), other.getKernelSize())) {
            return false;
        }
        if (!Arrays.equals(this.getStride(), other.getStride())) {
            return false;
        }
        if (!Arrays.equals(this.getPadding(), other.getPadding())) {
            return false;
        }
        if (this.isCudnnAllowFallback() != other.isCudnnAllowFallback()) {
            return false;
        }
        AlgoMode this$cudnnAlgoMode = this.getCudnnAlgoMode();
        AlgoMode other$cudnnAlgoMode = other.getCudnnAlgoMode();
        if (this$cudnnAlgoMode == null ? other$cudnnAlgoMode != null : !((Object)((Object)this$cudnnAlgoMode)).equals((Object)other$cudnnAlgoMode)) {
            return false;
        }
        FwdAlgo this$cudnnFwdAlgo = this.getCudnnFwdAlgo();
        FwdAlgo other$cudnnFwdAlgo = other.getCudnnFwdAlgo();
        if (this$cudnnFwdAlgo == null ? other$cudnnFwdAlgo != null : !((Object)((Object)this$cudnnFwdAlgo)).equals((Object)other$cudnnFwdAlgo)) {
            return false;
        }
        BwdFilterAlgo this$cudnnBwdFilterAlgo = this.getCudnnBwdFilterAlgo();
        BwdFilterAlgo other$cudnnBwdFilterAlgo = other.getCudnnBwdFilterAlgo();
        if (this$cudnnBwdFilterAlgo == null ? other$cudnnBwdFilterAlgo != null : !((Object)((Object)this$cudnnBwdFilterAlgo)).equals((Object)other$cudnnBwdFilterAlgo)) {
            return false;
        }
        BwdDataAlgo this$cudnnBwdDataAlgo = this.getCudnnBwdDataAlgo();
        BwdDataAlgo other$cudnnBwdDataAlgo = other.getCudnnBwdDataAlgo();
        return !(this$cudnnBwdDataAlgo == null ? other$cudnnBwdDataAlgo != null : !((Object)((Object)this$cudnnBwdDataAlgo)).equals((Object)other$cudnnBwdDataAlgo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConvolutionLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isHasBias() ? 79 : 97);
        ConvolutionMode $convolutionMode = this.getConvolutionMode();
        result = result * 59 + ($convolutionMode == null ? 43 : ((Object)((Object)$convolutionMode)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getDilation());
        result = result * 59 + Arrays.hashCode(this.getKernelSize());
        result = result * 59 + Arrays.hashCode(this.getStride());
        result = result * 59 + Arrays.hashCode(this.getPadding());
        result = result * 59 + (this.isCudnnAllowFallback() ? 79 : 97);
        AlgoMode $cudnnAlgoMode = this.getCudnnAlgoMode();
        result = result * 59 + ($cudnnAlgoMode == null ? 43 : ((Object)((Object)$cudnnAlgoMode)).hashCode());
        FwdAlgo $cudnnFwdAlgo = this.getCudnnFwdAlgo();
        result = result * 59 + ($cudnnFwdAlgo == null ? 43 : ((Object)((Object)$cudnnFwdAlgo)).hashCode());
        BwdFilterAlgo $cudnnBwdFilterAlgo = this.getCudnnBwdFilterAlgo();
        result = result * 59 + ($cudnnBwdFilterAlgo == null ? 43 : ((Object)((Object)$cudnnBwdFilterAlgo)).hashCode());
        BwdDataAlgo $cudnnBwdDataAlgo = this.getCudnnBwdDataAlgo();
        result = result * 59 + ($cudnnBwdDataAlgo == null ? 43 : ((Object)((Object)$cudnnBwdDataAlgo)).hashCode());
        return result;
    }

    public static abstract class BaseConvBuilder<T extends BaseConvBuilder<T>>
    extends FeedForwardLayer.Builder<T> {
        protected int convolutionDim = 2;
        protected boolean hasBias = true;
        protected ConvolutionMode convolutionMode;
        protected int[] dilation = new int[]{1, 1};
        public int[] kernelSize = new int[]{5, 5};
        protected int[] stride = new int[]{1, 1};
        protected int[] padding = new int[]{0, 0};
        protected AlgoMode cudnnAlgoMode = null;
        protected FwdAlgo cudnnFwdAlgo;
        protected BwdFilterAlgo cudnnBwdFilterAlgo;
        protected BwdDataAlgo cudnnBwdDataAlgo;
        protected boolean cudnnAllowFallback = true;

        protected BaseConvBuilder(int[] kernelSize, int[] stride, int[] padding, int[] dilation, int dim) {
            this.setKernelSize(kernelSize);
            this.setStride(stride);
            this.setPadding(padding);
            this.setDilation(dilation);
            this.setConvolutionDim(dim);
        }

        protected BaseConvBuilder(int[] kernelSize, int[] stride, int[] padding, int[] dilation) {
            this.setKernelSize(kernelSize);
            this.setStride(stride);
            this.setPadding(padding);
            this.setDilation(dilation);
        }

        protected BaseConvBuilder(int[] kernelSize, int[] stride, int[] padding, int dim) {
            this.setKernelSize(kernelSize);
            this.setStride(stride);
            this.setPadding(padding);
            this.setConvolutionDim(dim);
        }

        protected BaseConvBuilder(int[] kernelSize, int[] stride, int[] padding) {
            this.setKernelSize(kernelSize);
            this.setStride(stride);
            this.setPadding(padding);
        }

        protected BaseConvBuilder(int[] kernelSize, int[] stride, int dim) {
            this.setKernelSize(kernelSize);
            this.setStride(stride);
            this.setConvolutionDim(dim);
        }

        protected BaseConvBuilder(int[] kernelSize, int[] stride) {
            this.setKernelSize(kernelSize);
            this.setStride(stride);
        }

        protected BaseConvBuilder(int dim, int ... kernelSize) {
            this.setKernelSize(kernelSize);
            this.setConvolutionDim(dim);
        }

        protected BaseConvBuilder(int ... kernelSize) {
            this.setKernelSize(kernelSize);
        }

        protected BaseConvBuilder() {
        }

        public T hasBias(boolean hasBias) {
            this.setHasBias(hasBias);
            return (T)this;
        }

        public T convolutionMode(ConvolutionMode convolutionMode) {
            this.setConvolutionMode(convolutionMode);
            return (T)this;
        }

        public T dilation(int ... dilation) {
            this.setDilation(dilation);
            return (T)this;
        }

        public T kernelSize(int ... kernelSize) {
            this.setKernelSize(kernelSize);
            return (T)this;
        }

        public T stride(int ... stride) {
            this.setStride(stride);
            return (T)this;
        }

        public T padding(int ... padding) {
            this.setPadding(padding);
            return (T)this;
        }

        public T cudnnAlgoMode(AlgoMode cudnnAlgoMode) {
            this.setCudnnAlgoMode(cudnnAlgoMode);
            return (T)this;
        }

        public T cudnnFwdMode(FwdAlgo cudnnFwdAlgo) {
            this.setCudnnFwdAlgo(cudnnFwdAlgo);
            return (T)this;
        }

        public T cudnnBwdFilterMode(BwdFilterAlgo cudnnBwdFilterAlgo) {
            this.setCudnnBwdFilterAlgo(cudnnBwdFilterAlgo);
            return (T)this;
        }

        public T cudnnBwdDataMode(BwdDataAlgo cudnnBwdDataAlgo) {
            this.setCudnnBwdDataAlgo(cudnnBwdDataAlgo);
            return (T)this;
        }

        public T cudnnAllowFallback(boolean allowFallback) {
            this.setCudnnAllowFallback(allowFallback);
            return (T)this;
        }

        public int getConvolutionDim() {
            return this.convolutionDim;
        }

        public boolean isHasBias() {
            return this.hasBias;
        }

        public ConvolutionMode getConvolutionMode() {
            return this.convolutionMode;
        }

        public int[] getDilation() {
            return this.dilation;
        }

        public int[] getKernelSize() {
            return this.kernelSize;
        }

        public int[] getStride() {
            return this.stride;
        }

        public int[] getPadding() {
            return this.padding;
        }

        public AlgoMode getCudnnAlgoMode() {
            return this.cudnnAlgoMode;
        }

        public FwdAlgo getCudnnFwdAlgo() {
            return this.cudnnFwdAlgo;
        }

        public BwdFilterAlgo getCudnnBwdFilterAlgo() {
            return this.cudnnBwdFilterAlgo;
        }

        public BwdDataAlgo getCudnnBwdDataAlgo() {
            return this.cudnnBwdDataAlgo;
        }

        public boolean isCudnnAllowFallback() {
            return this.cudnnAllowFallback;
        }

        public void setConvolutionDim(int convolutionDim) {
            this.convolutionDim = convolutionDim;
        }

        public void setHasBias(boolean hasBias) {
            this.hasBias = hasBias;
        }

        public void setConvolutionMode(ConvolutionMode convolutionMode) {
            this.convolutionMode = convolutionMode;
        }

        public void setDilation(int[] dilation) {
            this.dilation = dilation;
        }

        public void setKernelSize(int[] kernelSize) {
            this.kernelSize = kernelSize;
        }

        public void setStride(int[] stride) {
            this.stride = stride;
        }

        public void setPadding(int[] padding) {
            this.padding = padding;
        }

        public void setCudnnAlgoMode(AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode = cudnnAlgoMode;
        }

        public void setCudnnFwdAlgo(FwdAlgo cudnnFwdAlgo) {
            this.cudnnFwdAlgo = cudnnFwdAlgo;
        }

        public void setCudnnBwdFilterAlgo(BwdFilterAlgo cudnnBwdFilterAlgo) {
            this.cudnnBwdFilterAlgo = cudnnBwdFilterAlgo;
        }

        public void setCudnnBwdDataAlgo(BwdDataAlgo cudnnBwdDataAlgo) {
            this.cudnnBwdDataAlgo = cudnnBwdDataAlgo;
        }

        public void setCudnnAllowFallback(boolean cudnnAllowFallback) {
            this.cudnnAllowFallback = cudnnAllowFallback;
        }
    }

    public static class Builder
    extends BaseConvBuilder<Builder> {
        public Builder(int[] kernelSize, int[] stride, int[] padding) {
            super(kernelSize, stride, padding);
        }

        public Builder(int[] kernelSize, int[] stride) {
            super(kernelSize, stride);
        }

        public Builder(int ... kernelSize) {
            super(kernelSize);
        }

        public Builder() {
        }

        @Override
        public Builder kernelSize(int ... kernelSize) {
            this.setKernelSize(kernelSize);
            return this;
        }

        @Override
        public Builder stride(int ... stride) {
            this.setStride(stride);
            return this;
        }

        @Override
        public Builder padding(int ... padding) {
            this.setPadding(padding);
            return this;
        }

        @Override
        public ConvolutionLayer build() {
            ConvolutionUtils.validateConvolutionModePadding(this.convolutionMode, this.padding);
            ConvolutionUtils.validateCnnKernelStridePadding(this.kernelSize, this.stride, this.padding);
            return new ConvolutionLayer(this);
        }

        @Override
        public void setKernelSize(int ... kernelSize) {
            this.kernelSize = ValidationUtils.validate2NonNegative(kernelSize, false, "kernelSize");
        }

        @Override
        public void setStride(int ... stride) {
            this.stride = ValidationUtils.validate2NonNegative(stride, false, "stride");
        }

        @Override
        public void setPadding(int ... padding) {
            this.padding = ValidationUtils.validate2NonNegative(padding, false, "padding");
        }

        @Override
        public void setDilation(int ... dilation) {
            this.dilation = ValidationUtils.validate2NonNegative(dilation, false, "dilation");
        }
    }

    public static enum BwdDataAlgo {
        ALGO_0,
        ALGO_1,
        FFT,
        FFT_TILING,
        WINOGRAD,
        WINOGRAD_NONFUSED,
        COUNT;

    }

    public static enum BwdFilterAlgo {
        ALGO_0,
        ALGO_1,
        FFT,
        ALGO_3,
        WINOGRAD,
        WINOGRAD_NONFUSED,
        FFT_TILING,
        COUNT;

    }

    public static enum FwdAlgo {
        IMPLICIT_GEMM,
        IMPLICIT_PRECOMP_GEMM,
        GEMM,
        DIRECT,
        FFT,
        FFT_TILING,
        WINOGRAD,
        WINOGRAD_NONFUSED,
        COUNT;

    }

    public static enum AlgoMode {
        NO_WORKSPACE,
        PREFER_FASTEST,
        USER_SPECIFIED;

    }
}

