/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.samediff.SameDiffLambdaLayer;
import org.deeplearning4j.nn.conf.layers.samediff.SameDiffLayer;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;

public class CapsuleStrengthLayer
extends SameDiffLambdaLayer {
    public CapsuleStrengthLayer(Builder builder) {
    }

    @Override
    public SDVariable defineLayer(SameDiff SD, SDVariable layerInput) {
        return SD.norm2("caps_strength", layerInput, new int[]{2});
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.RNN) {
            throw new IllegalStateException("Invalid input for Capsule Strength layer (layer name = \"" + this.layerName + "\"): expect RNN input.  Got: " + inputType);
        }
        InputType.InputTypeRecurrent ri = (InputType.InputTypeRecurrent)inputType;
        return InputType.feedForward(ri.getSize());
    }

    @Override
    public String toString() {
        return "CapsuleStrengthLayer()";
    }

    public CapsuleStrengthLayer() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CapsuleStrengthLayer)) {
            return false;
        }
        CapsuleStrengthLayer other = (CapsuleStrengthLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CapsuleStrengthLayer;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public static class Builder
    extends SameDiffLayer.Builder<Builder> {
        @Override
        public <E extends Layer> E build() {
            return (E)new CapsuleStrengthLayer(this);
        }
    }
}

