/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.constraint;

import java.util.Collections;
import java.util.Set;
import org.deeplearning4j.nn.conf.constraint.BaseConstraint;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Broadcast;

public class UnitNormConstraint
extends BaseConstraint {
    private UnitNormConstraint() {
    }

    public UnitNormConstraint(int ... dimensions) {
        this(Collections.emptySet(), dimensions);
    }

    public UnitNormConstraint(Set<String> paramNames, int ... dimensions) {
        super(paramNames, dimensions);
    }

    @Override
    public void apply(INDArray param) {
        INDArray norm2 = param.norm2(this.dimensions);
        Broadcast.div((INDArray)param, (INDArray)norm2, (INDArray)param, (int[])UnitNormConstraint.getBroadcastDims(this.dimensions, param.rank()));
    }

    @Override
    public UnitNormConstraint clone() {
        return new UnitNormConstraint((Set<String>)this.params, this.dimensions);
    }

    @Override
    public String toString() {
        return "UnitNormConstraint()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnitNormConstraint)) {
            return false;
        }
        UnitNormConstraint other = (UnitNormConstraint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UnitNormConstraint;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

