/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution.upsampling;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upsampling2D
extends AbstractLayer<org.deeplearning4j.nn.conf.layers.Upsampling2D> {
    private static final Logger log = LoggerFactory.getLogger(Upsampling2D.class);

    public Upsampling2D(NeuralNetConfiguration conf) {
        super(conf);
    }

    public Upsampling2D(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public double calcL2(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public double calcL1(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.UPSAMPLING;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(true);
        int miniBatch = (int)this.input.size(0);
        int inDepth = (int)this.input.size(1);
        int inH = (int)this.input.size(2);
        int inW = (int)this.input.size(3);
        INDArray reshapedEpsilon = workspaceMgr.createUninitialized(ArrayType.ACTIVATION_GRAD, new int[]{miniBatch, inDepth, inH, inW}, 'c');
        DefaultGradient gradient = new DefaultGradient();
        int[] intArgs = new int[]{1};
        DynamicCustomOp op = DynamicCustomOp.builder((String)"upsampling_bp").addIntegerArguments(intArgs).addInputs(new INDArray[]{this.input, epsilon}).addOutputs(new INDArray[]{reshapedEpsilon}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        reshapedEpsilon = this.backpropDropOutIfPresent(reshapedEpsilon);
        return new Pair((Object)gradient, (Object)reshapedEpsilon);
    }

    protected int[] getSize() {
        return ((org.deeplearning4j.nn.conf.layers.Upsampling2D)this.layerConf()).getSize();
    }

    protected INDArray preOutput(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        this.applyDropOutIfNecessary(training, workspaceMgr);
        if (this.input.rank() != 4) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to SubsamplingLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape [minibatchSize, channels, inputHeight, inputWidth]. " + this.layerId());
        }
        if (this.preOutput != null && forBackprop) {
            return this.preOutput;
        }
        int miniBatch = (int)this.input.size(0);
        int inDepth = (int)this.input.size(1);
        int inH = (int)this.input.size(2);
        int inW = (int)this.input.size(3);
        int[] size = this.getSize();
        int outH = inH * size[0];
        int outW = inW * size[1];
        INDArray reshapedOutput = workspaceMgr.createUninitialized(ArrayType.ACTIVATIONS, new int[]{miniBatch, inDepth, outH, outW}, 'c');
        int[] intArgs = new int[]{size[0], size[1], 1};
        DynamicCustomOp upsampling = DynamicCustomOp.builder((String)"upsampling2d").addIntegerArguments(intArgs).addInputs(new INDArray[]{this.input}).addOutputs(new INDArray[]{reshapedOutput}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)upsampling);
        return reshapedOutput;
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        this.applyDropOutIfNecessary(training, workspaceMgr);
        if (this.cacheMode == null) {
            this.cacheMode = CacheMode.NONE;
        }
        INDArray z = this.preOutput(training, false, workspaceMgr);
        if (training && this.cacheMode != CacheMode.NONE && workspaceMgr.hasConfiguration(ArrayType.FF_CACHE) && workspaceMgr.isWorkspaceOpen(ArrayType.FF_CACHE)) {
            try (MemoryWorkspace wsB = workspaceMgr.notifyScopeBorrowed(ArrayType.FF_CACHE);){
                this.preOutput = z.unsafeDuplication();
            }
        }
        return z;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not supported - no parameters");
    }

    @Override
    public void fit() {
    }

    @Override
    public long numParams() {
        return 0L;
    }

    @Override
    public void fit(INDArray input, LayerWorkspaceMgr workspaceMgr) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public double score() {
        return 0.0;
    }

    @Override
    public void update(INDArray gradient, String paramType) {
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public INDArray getParam(String param) {
        return this.params();
    }

    @Override
    public void setParams(INDArray params) {
    }
}

