/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.solvers;

import java.util.Collection;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.optimize.api.StepFunction;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.deeplearning4j.optimize.solvers.BaseOptimizer;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StochasticGradientDescent
extends BaseOptimizer {
    private static final Logger log = LoggerFactory.getLogger(StochasticGradientDescent.class);

    public StochasticGradientDescent(NeuralNetConfiguration conf, StepFunction stepFunction, Collection<TrainingListener> trainingListeners, Model model) {
        super(conf, stepFunction, trainingListeners, model);
    }

    @Override
    public boolean optimize(LayerWorkspaceMgr workspaceMgr) {
        Pair<Gradient, Double> pair = this.gradientAndScore(workspaceMgr);
        Gradient gradient = (Gradient)pair.getFirst();
        INDArray params = this.model.params();
        if (this.accumulator != null) {
            this.accumulator.storeUpdate(gradient.gradient());
            this.accumulator.applyUpdate(this.stepFunction, params, gradient.gradient());
        } else {
            this.stepFunction.step(params, gradient.gradient());
        }
        this.model.setParams(params);
        int iterationCount = BaseOptimizer.getIterationCount(this.model);
        int epochCount = BaseOptimizer.getEpochCount(this.model);
        try (MemoryWorkspace workspace = Nd4j.getMemoryManager().scopeOutOfWorkspaces();){
            for (TrainingListener listener : this.trainingListeners) {
                listener.iterationDone(this.model, iterationCount, epochCount);
            }
        }
        BaseOptimizer.incrementIterationCount(this.model, 1);
        StochasticGradientDescent.applyConstraints(this.model);
        return true;
    }

    @Override
    public void preProcessLine() {
    }

    @Override
    public void postStep(INDArray gradient) {
    }
}

