/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.workspace;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.bytedeco.javacpp.Pointer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.nd4j.linalg.api.memory.conf.WorkspaceConfiguration;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.workspace.BaseWorkspaceMgr;

public class LayerWorkspaceMgr
extends BaseWorkspaceMgr<ArrayType> {
    public static String CUDNN_WORKSPACE_KEY = "CUDNN_WORKSPACE";
    private static LayerWorkspaceMgr NO_WS_IMMUTABLE;
    protected Set<String> noLeverageOverride;
    protected Map<String, Pointer> helperWorkspacePointers;

    private LayerWorkspaceMgr() {
    }

    public LayerWorkspaceMgr(Set<ArrayType> scopeOutOfWs, Map<ArrayType, WorkspaceConfiguration> configMap, Map<ArrayType, String> workspaceNames) {
        super(scopeOutOfWs, configMap, workspaceNames);
        if (configMap != null) {
            Preconditions.checkArgument((boolean)configMap.keySet().equals(workspaceNames.keySet()), (Object)"Keys for config may and workspace names must match");
        }
    }

    public void setNoLeverageOverride(String wsName) {
        if (this.noLeverageOverride == null) {
            this.noLeverageOverride = new HashSet<String>();
        }
        this.noLeverageOverride.add(wsName);
    }

    public INDArray leverageTo(ArrayType arrayType, INDArray array) {
        if (this.noLeverageOverride != null && array.isAttached() && this.noLeverageOverride.contains(array.data().getParentWorkspace().getId())) {
            return array;
        }
        return super.leverageTo((Enum)arrayType, array);
    }

    public INDArray validateArrayLocation(@NonNull ArrayType arrayType, @NonNull INDArray array, boolean migrateIfInvalid, boolean exceptionIfDetached) {
        if (arrayType == null) {
            throw new NullPointerException("arrayType is marked @NonNull but is null");
        }
        if (array == null) {
            throw new NullPointerException("array is marked @NonNull but is null");
        }
        if (this.noLeverageOverride != null && array.isAttached() && this.noLeverageOverride.contains(array.data().getParentWorkspace().getId())) {
            return array;
        }
        return super.validateArrayLocation((Enum)arrayType, array, migrateIfInvalid, exceptionIfDetached);
    }

    public <T extends Pointer> T getHelperWorkspace(String key) {
        return (T)this.helperWorkspacePointers.get(key);
    }

    public void setHelperWorkspace(@NonNull String key, Pointer value) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        this.helperWorkspacePointers.put(key, value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static LayerWorkspaceMgr noWorkspaces(Map<String, Pointer> helperWorkspacePointers) {
        LayerWorkspaceMgr wsm = LayerWorkspaceMgr.noWorkspaces();
        wsm.setHelperWorkspacePointers(helperWorkspacePointers);
        return wsm;
    }

    public static LayerWorkspaceMgr noWorkspaces() {
        return LayerWorkspaceMgr.builder().defaultNoWorkspace().build();
    }

    public static LayerWorkspaceMgr noWorkspacesImmutable() {
        return NO_WS_IMMUTABLE;
    }

    public void setHelperWorkspacePointers(Map<String, Pointer> helperWorkspacePointers) {
        this.helperWorkspacePointers = helperWorkspacePointers;
    }

    public Map<String, Pointer> getHelperWorkspacePointers() {
        return this.helperWorkspacePointers;
    }

    static {
        HashSet<ArrayType> all = new HashSet<ArrayType>();
        Collections.addAll(all, ArrayType.values());
        NO_WS_IMMUTABLE = new LayerWorkspaceMgr(all, Collections.emptyMap(), Collections.emptyMap());
    }

    public static class Builder {
        private LayerWorkspaceMgr mgr = new LayerWorkspaceMgr();

        public Builder defaultNoWorkspace() {
            for (ArrayType t : ArrayType.values()) {
                if (this.mgr.configMap.containsKey((Object)t)) continue;
                this.mgr.setScopedOutFor(t);
            }
            return this;
        }

        public Builder noWorkspaceFor(ArrayType type) {
            this.mgr.setScopedOutFor(type);
            return this;
        }

        public Builder defaultWorkspace(String workspaceName, WorkspaceConfiguration configuration) {
            for (ArrayType t : ArrayType.values()) {
                if (this.mgr.configMap.containsKey((Object)t) || this.mgr.isScopedOut(t)) continue;
                this.with(t, workspaceName, configuration);
            }
            return this;
        }

        public Builder with(ArrayType type, String workspaceName, WorkspaceConfiguration configuration) {
            this.mgr.setConfiguration(type, configuration);
            this.mgr.setWorkspaceName(type, workspaceName);
            return this;
        }

        public LayerWorkspaceMgr build() {
            return this.mgr;
        }
    }
}

