/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.primitives.Pair;

public class ZeroPadding3DLayer
extends AbstractLayer<org.deeplearning4j.nn.conf.layers.ZeroPadding3DLayer> {
    private int[] padding;

    public ZeroPadding3DLayer(NeuralNetConfiguration conf) {
        super(conf);
        this.padding = ((org.deeplearning4j.nn.conf.layers.ZeroPadding3DLayer)conf.getLayer()).getPadding();
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.CONVOLUTIONAL;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(true);
        int[] inShape = this.input.shape();
        INDArray epsNext = epsilon.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval((int)this.padding[0], (int)(this.padding[0] + inShape[2])), NDArrayIndex.interval((int)this.padding[2], (int)(this.padding[2] + inShape[3])), NDArrayIndex.interval((int)this.padding[4], (int)(this.padding[4] + inShape[4]))});
        epsNext = workspaceMgr.leverageTo(ArrayType.ACTIVATION_GRAD, epsNext);
        return new Pair((Object)new DefaultGradient(), (Object)epsNext);
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        int[] inShape = this.input.shape();
        int outD = inShape[2] + this.padding[0] + this.padding[1];
        int outH = inShape[3] + this.padding[2] + this.padding[3];
        int outW = inShape[4] + this.padding[4] + this.padding[5];
        int[] outShape = new int[]{inShape[0], inShape[1], outD, outH, outW};
        INDArray out = workspaceMgr.create(ArrayType.ACTIVATIONS, outShape, 'c');
        out.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval((int)this.padding[0], (int)(this.padding[0] + inShape[2])), NDArrayIndex.interval((int)this.padding[2], (int)(this.padding[2] + inShape[3])), NDArrayIndex.interval((int)this.padding[4], (int)(this.padding[4] + inShape[4]))}, this.input);
        return out;
    }

    @Override
    public Layer clone() {
        return new ZeroPadding3DLayer(this.conf.clone());
    }

    @Override
    public double calcL1(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public double calcL2(boolean backpropParamsOnly) {
        return 0.0;
    }
}

