/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.graph.vertex.impl.rnn;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.BaseGraphVertex;
import org.deeplearning4j.nn.graph.vertex.VertexIndices;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.primitives.Pair;

public class LastTimeStepVertex
extends BaseGraphVertex {
    private String inputName;
    private int inputIdx;
    private int[] fwdPassShape;
    private int[] fwdPassTimeSteps;

    public LastTimeStepVertex(ComputationGraph graph, String name, int vertexIndex, String inputName) {
        this(graph, name, vertexIndex, null, null, inputName);
    }

    public LastTimeStepVertex(ComputationGraph graph, String name, int vertexIndex, VertexIndices[] inputVertices, VertexIndices[] outputVertices, String inputName) {
        super(graph, name, vertexIndex, inputVertices, outputVertices);
        this.inputName = inputName;
        this.inputIdx = graph.getConfiguration().getNetworkInputs().indexOf(inputName);
        if (this.inputIdx == -1) {
            throw new IllegalArgumentException("Invalid input name: \"" + inputName + "\" not found in list of network inputs (" + graph.getConfiguration().getNetworkInputs() + ")");
        }
    }

    @Override
    public boolean hasLayer() {
        return false;
    }

    @Override
    public Layer getLayer() {
        return null;
    }

    @Override
    public INDArray doForward(boolean training, LayerWorkspaceMgr workspaceMgr) {
        INDArray out;
        INDArray[] inputMaskArrays = this.graph.getInputMaskArrays();
        INDArray mask = inputMaskArrays != null ? inputMaskArrays[this.inputIdx] : null;
        this.fwdPassShape = this.inputs[0].shape();
        if (mask == null) {
            int lastTS = this.inputs[0].size(2) - 1;
            out = this.inputs[0].get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.point((int)lastTS)});
            out = workspaceMgr.dup(ArrayType.ACTIVATIONS, out);
            this.fwdPassTimeSteps = null;
        } else {
            int i;
            int[] outShape = new int[]{this.inputs[0].size(0), this.inputs[0].size(1)};
            out = workspaceMgr.create(ArrayType.ACTIVATIONS, outShape);
            int maxTsLength = this.fwdPassShape[2];
            INDArray row = Nd4j.linspace((int)0, (int)(maxTsLength - 1), (int)maxTsLength);
            INDArray temp = mask.mulRowVector(row);
            INDArray lastElementIdx = Nd4j.argMax((INDArray)temp, (int[])new int[]{1});
            this.fwdPassTimeSteps = new int[this.fwdPassShape[0]];
            for (i = 0; i < this.fwdPassTimeSteps.length; ++i) {
                this.fwdPassTimeSteps[i] = (int)lastElementIdx.getDouble(i);
            }
            for (i = 0; i < this.fwdPassTimeSteps.length; ++i) {
                out.putRow(i, this.inputs[0].get(new INDArrayIndex[]{NDArrayIndex.point((int)i), NDArrayIndex.all(), NDArrayIndex.point((int)this.fwdPassTimeSteps[i])}));
            }
        }
        return out;
    }

    @Override
    public Pair<Gradient, INDArray[]> doBackward(boolean tbptt, LayerWorkspaceMgr workspaceMgr) {
        INDArray epsilonsOut = workspaceMgr.create(ArrayType.ACTIVATION_GRAD, this.fwdPassShape, 'f');
        if (this.fwdPassTimeSteps == null) {
            epsilonsOut.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.point((int)(this.fwdPassShape[2] - 1))}, this.epsilon);
        } else {
            for (int i = 0; i < this.fwdPassTimeSteps.length; ++i) {
                epsilonsOut.put(new INDArrayIndex[]{NDArrayIndex.point((int)i), NDArrayIndex.all(), NDArrayIndex.point((int)this.fwdPassTimeSteps[i])}, this.epsilon.getRow(i));
            }
        }
        return new Pair(null, (Object)new INDArray[]{epsilonsOut});
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray backpropGradientsViewArray) {
        if (backpropGradientsViewArray != null) {
            throw new RuntimeException("Vertex does not have gradients; gradients view array cannot be set here");
        }
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArrays(INDArray[] maskArrays, MaskState currentMaskState, int minibatchSize) {
        return new Pair(null, (Object)currentMaskState);
    }

    @Override
    public String toString() {
        return "LastTimeStepVertex(inputName=" + this.inputName + ")";
    }
}

