/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers.misc;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.params.ElementWiseParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ElementWiseMultiplicationLayer
extends FeedForwardLayer {
    protected ElementWiseMultiplicationLayer() {
    }

    protected ElementWiseMultiplicationLayer(Builder builder) {
        super(builder);
    }

    @Override
    public ElementWiseMultiplicationLayer clone() {
        ElementWiseMultiplicationLayer clone = (ElementWiseMultiplicationLayer)super.clone();
        return clone;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        if (this.nIn != this.nOut) {
            throw new IllegalStateException("Element wise layer must have the same input and output size. Got nIn=" + this.nIn + ", nOut=" + this.nOut);
        }
        org.deeplearning4j.nn.layers.feedforward.elementwise.ElementWiseMultiplicationLayer ret = new org.deeplearning4j.nn.layers.feedforward.elementwise.ElementWiseMultiplicationLayer(conf);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return ElementWiseParamInitializer.getInstance();
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        InputType outputType = this.getOutputType(-1, inputType);
        int numParams = this.initializer().numParams(this);
        int updaterStateSize = (int)this.getIUpdater().stateSize((long)numParams);
        int trainSizeFixed = 0;
        int trainSizeVariable = 0;
        if (this.getIDropout() != null) {
            trainSizeVariable += inputType.arrayElementsPerExample();
        }
        return new LayerMemoryReport.Builder(this.layerName, ElementWiseMultiplicationLayer.class, inputType, outputType).standardMemory(numParams, updaterStateSize).workingMemory(0L, 0L, trainSizeFixed, trainSizeVariable += outputType.arrayElementsPerExample()).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    @Override
    public String toString() {
        return "ElementWiseMultiplicationLayer(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElementWiseMultiplicationLayer)) {
            return false;
        }
        ElementWiseMultiplicationLayer other = (ElementWiseMultiplicationLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ElementWiseMultiplicationLayer;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public static class Builder
    extends FeedForwardLayer.Builder<Builder> {
        @Override
        public ElementWiseMultiplicationLayer build() {
            return new ElementWiseMultiplicationLayer(this);
        }
    }
}

