/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers.convolutional;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import lombok.NonNull;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.NoParamLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.layers.convolution.Cropping3DLayer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.ndarray.INDArray;

public class Cropping3D
extends NoParamLayer {
    private int[] cropping;

    public Cropping3D(int cropDepth, int cropHeight, int cropWidth) {
        this(cropDepth, cropDepth, cropHeight, cropHeight, cropWidth, cropWidth);
    }

    public Cropping3D(int cropLeftD, int cropRightD, int cropLeftH, int cropRightH, int cropLeftW, int cropRightW) {
        this(new Builder(cropLeftD, cropRightD, cropLeftH, cropRightH, cropLeftW, cropRightW));
    }

    public Cropping3D(int[] cropping) {
        this(new Builder(cropping));
    }

    protected Cropping3D(Builder builder) {
        super(builder);
        this.cropping = builder.cropping;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        Cropping3DLayer ret = new Cropping3DLayer(conf);
        ret.setListeners(iterationListeners);
        ret.setIndex(layerIndex);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN3D) {
            throw new IllegalStateException("Invalid input for 3D cropping layer (layer index = " + layerIndex + ", layer name = \"" + this.getLayerName() + "\"): expect CNN3D input type with size > 0. Got: " + inputType);
        }
        InputType.InputTypeConvolutional3D c = (InputType.InputTypeConvolutional3D)inputType;
        return InputType.convolutional3D(c.getDepth() - this.cropping[0] - this.cropping[1], c.getHeight() - this.cropping[2] - this.cropping[3], c.getWidth() - this.cropping[4] - this.cropping[5], c.getChannels());
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        Preconditions.checkArgument((inputType != null ? 1 : 0) != 0, (Object)("Invalid input for Cropping3D layer (layer name=\"" + this.getLayerName() + "\"): InputType is null"));
        return InputTypeUtil.getPreProcessorForInputTypeCnn3DLayers(inputType, this.getLayerName());
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        return null;
    }

    public int[] getCropping() {
        return this.cropping;
    }

    public void setCropping(int[] cropping) {
        this.cropping = cropping;
    }

    @Override
    public String toString() {
        return "Cropping3D(cropping=" + Arrays.toString(this.getCropping()) + ")";
    }

    public Cropping3D() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cropping3D)) {
            return false;
        }
        Cropping3D other = (Cropping3D)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.getCropping(), other.getCropping());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Cropping3D;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getCropping());
        return result;
    }

    public static class Builder
    extends Layer.Builder<Builder> {
        private int[] cropping = new int[]{0, 0, 0, 0, 0, 0};

        public Builder() {
        }

        public Builder(@NonNull int[] cropping) {
            if (cropping == null) {
                throw new NullPointerException("cropping");
            }
            Preconditions.checkArgument((cropping.length == 6 || cropping.length == 3 ? 1 : 0) != 0, (Object)("Either 3 or 6 cropping values, got " + cropping.length + " values: " + Arrays.toString(cropping)));
            this.cropping = cropping.length == 3 ? new int[]{cropping[0], cropping[0], cropping[1], cropping[1], cropping[2], cropping[2]} : cropping;
        }

        public Builder(int cropDepth, int cropHeight, int cropWidth) {
            this(cropDepth, cropDepth, cropHeight, cropHeight, cropWidth, cropWidth);
        }

        public Builder(int cropLeftD, int cropRightD, int cropLeftH, int cropRightH, int cropLeftW, int cropRightW) {
            this.cropping = new int[]{cropLeftD, cropRightD, cropLeftH, cropRightH, cropLeftW, cropRightW};
            Preconditions.checkArgument((cropLeftD >= 0 && cropLeftH >= 0 && cropLeftW >= 0 && cropRightD >= 0 && cropRightH >= 0 && cropRightW >= 0 ? 1 : 0) != 0, (Object)("Invalid arguments: crop dimensions must be > 0. Got " + Arrays.toString(this.cropping)));
        }

        @Override
        public Cropping3D build() {
            return new Cropping3D(this);
        }
    }
}

