/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.params.EmptyParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ZeroPadding3DLayer
extends Layer {
    private int[] padding;

    private ZeroPadding3DLayer(Builder builder) {
        super(builder);
        this.padding = builder.padding;
    }

    @Override
    public org.deeplearning4j.nn.api.Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        org.deeplearning4j.nn.layers.convolution.ZeroPadding3DLayer ret = new org.deeplearning4j.nn.layers.convolution.ZeroPadding3DLayer(conf);
        ret.setListeners(iterationListeners);
        ret.setIndex(layerIndex);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return EmptyParamInitializer.getInstance();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN3D) {
            throw new IllegalStateException("Invalid input for 3D CNN layer (layer index = " + layerIndex + ", layer name = \"" + this.getLayerName() + "\"): expect CNN3D input type with size > 0. Got: " + inputType);
        }
        InputType.InputTypeConvolutional3D c = (InputType.InputTypeConvolutional3D)inputType;
        return InputType.convolutional3D(c.getDepth() + this.padding[0] + this.padding[1], c.getHeight() + this.padding[2] + this.padding[3], c.getWidth() + this.padding[4] + this.padding[5], c.getChannels());
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for ZeroPadding3DLayer layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreProcessorForInputTypeCnn3DLayers(inputType, this.getLayerName());
    }

    @Override
    public double getL1ByParam(String paramName) {
        return 0.0;
    }

    @Override
    public double getL2ByParam(String paramName) {
        return 0.0;
    }

    @Override
    public boolean isPretrainParam(String paramName) {
        throw new UnsupportedOperationException("ZeroPadding3DLayer does not contain parameters");
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        InputType outputType = this.getOutputType(-1, inputType);
        return new LayerMemoryReport.Builder(this.layerName, ZeroPadding3DLayer.class, inputType, outputType).standardMemory(0L, 0L).workingMemory(0L, 0L, MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    public int[] getPadding() {
        return this.padding;
    }

    public void setPadding(int[] padding) {
        this.padding = padding;
    }

    @Override
    public String toString() {
        return "ZeroPadding3DLayer(padding=" + Arrays.toString(this.getPadding()) + ")";
    }

    public ZeroPadding3DLayer() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZeroPadding3DLayer)) {
            return false;
        }
        ZeroPadding3DLayer other = (ZeroPadding3DLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.getPadding(), other.getPadding());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ZeroPadding3DLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getPadding());
        return result;
    }

    public static class Builder
    extends Layer.Builder<Builder> {
        private int[] padding = new int[]{0, 0, 0, 0, 0, 0};

        public Builder(int padding) {
            this(padding, padding, padding, padding, padding, padding);
        }

        public Builder(int padDepth, int padHeight, int padWidth) {
            this(padDepth, padDepth, padHeight, padHeight, padWidth, padWidth);
        }

        public Builder(int padLeftD, int padRightD, int padLeftH, int padRightH, int padLeftW, int padRightW) {
            this(new int[]{padLeftD, padRightD, padLeftH, padRightH, padLeftW, padRightW});
        }

        public Builder(int[] padding) {
            if (padding.length == 3) {
                this.padding = new int[]{padding[0], padding[0], padding[1], padding[1], padding[2], padding[2]};
            } else if (padding.length == 6) {
                this.padding = padding;
            } else if (padding.length == 1) {
                this.padding = new int[]{padding[0], padding[0], padding[0], padding[0], padding[0], padding[0]};
            } else {
                throw new IllegalStateException("Padding length has to be either 1, 3 or 6, got " + padding.length);
            }
        }

        @Override
        public ZeroPadding3DLayer build() {
            for (int p : this.padding) {
                if (p >= 0) continue;
                throw new IllegalStateException("Invalid zero padding layer config: padding [left, right] must be > 0 for all elements. Got: " + Arrays.toString(this.padding));
            }
            return new ZeroPadding3DLayer(this);
        }
    }
}

