/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.params.DefaultParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.ndarray.INDArray;

public class EmbeddingSequenceLayer
extends FeedForwardLayer {
    private int inputLength = 1;
    private boolean hasBias = false;
    private boolean inferInputLength = false;

    private EmbeddingSequenceLayer(Builder builder) {
        super(builder);
        this.hasBias = builder.hasBias;
        this.inputLength = builder.inputLength;
        this.inferInputLength = builder.inferInputLength;
        this.initializeConstraints(builder);
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        org.deeplearning4j.nn.layers.feedforward.embedding.EmbeddingSequenceLayer ret = new org.deeplearning4j.nn.layers.feedforward.embedding.EmbeddingSequenceLayer(conf);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.FF) {
            throw new IllegalStateException("Invalid input for Embedding layer (layer index = " + layerIndex + ", layer name = \"" + this.getLayerName() + "\"): expect FFN input type. Got: " + inputType);
        }
        return InputType.recurrent(this.nOut, this.inputLength);
    }

    @Override
    public ParamInitializer initializer() {
        return DefaultParamInitializer.getInstance();
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        InputType outputType = this.getOutputType(-1, inputType);
        int actElementsPerEx = outputType.arrayElementsPerExample();
        int numParams = this.initializer().numParams(this);
        int updaterStateSize = (int)this.getIUpdater().stateSize((long)numParams);
        return new LayerMemoryReport.Builder(this.layerName, EmbeddingSequenceLayer.class, inputType, outputType).standardMemory(numParams, updaterStateSize).workingMemory(0L, 0L, 0L, actElementsPerEx).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    public boolean hasBias() {
        return this.hasBias;
    }

    public int getInputLength() {
        return this.inputLength;
    }

    public boolean isHasBias() {
        return this.hasBias;
    }

    public boolean isInferInputLength() {
        return this.inferInputLength;
    }

    public void setInputLength(int inputLength) {
        this.inputLength = inputLength;
    }

    public void setHasBias(boolean hasBias) {
        this.hasBias = hasBias;
    }

    public void setInferInputLength(boolean inferInputLength) {
        this.inferInputLength = inferInputLength;
    }

    public EmbeddingSequenceLayer() {
    }

    @Override
    public String toString() {
        return "EmbeddingSequenceLayer(super=" + super.toString() + ", inputLength=" + this.getInputLength() + ", hasBias=" + this.isHasBias() + ", inferInputLength=" + this.isInferInputLength() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmbeddingSequenceLayer)) {
            return false;
        }
        EmbeddingSequenceLayer other = (EmbeddingSequenceLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getInputLength() != other.getInputLength()) {
            return false;
        }
        if (this.isHasBias() != other.isHasBias()) {
            return false;
        }
        return this.isInferInputLength() == other.isInferInputLength();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EmbeddingSequenceLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getInputLength();
        result = result * 59 + (this.isHasBias() ? 79 : 97);
        result = result * 59 + (this.isInferInputLength() ? 79 : 97);
        return result;
    }

    public static class Builder
    extends FeedForwardLayer.Builder<Builder> {
        private boolean hasBias = false;
        private int inputLength = 1;
        private boolean inferInputLength = false;

        public Builder hasBias(boolean hasBias) {
            this.hasBias = hasBias;
            return this;
        }

        public Builder inputLength(int inputLength) {
            this.inputLength = inputLength;
            return this;
        }

        public Builder inferInputLength(boolean inferInputLength) {
            this.inferInputLength = inferInputLength;
            return this;
        }

        @Override
        public EmbeddingSequenceLayer build() {
            return new EmbeddingSequenceLayer(this);
        }
    }
}

