/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.samediff.AbstractSameDiffLayer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SameDiffParamInitializer
implements ParamInitializer {
    private static final Logger log = LoggerFactory.getLogger(SameDiffParamInitializer.class);
    private static final SameDiffParamInitializer INSTANCE = new SameDiffParamInitializer();

    public static SameDiffParamInitializer getInstance() {
        return INSTANCE;
    }

    @Override
    public int numParams(NeuralNetConfiguration conf) {
        return this.numParams(conf.getLayer());
    }

    @Override
    public int numParams(Layer layer) {
        AbstractSameDiffLayer sd = (AbstractSameDiffLayer)layer;
        Map<String, int[]> m = sd.getLayerParams().getParamShapes();
        int n = 0;
        for (int[] arr : m.values()) {
            n += ArrayUtil.prod((int[])arr);
        }
        return n;
    }

    @Override
    public List<String> paramKeys(Layer layer) {
        AbstractSameDiffLayer sd = (AbstractSameDiffLayer)layer;
        return sd.getLayerParams().getParameterKeys();
    }

    @Override
    public List<String> weightKeys(Layer layer) {
        AbstractSameDiffLayer sd = (AbstractSameDiffLayer)layer;
        return sd.getLayerParams().getWeightParameterKeys();
    }

    @Override
    public List<String> biasKeys(Layer layer) {
        AbstractSameDiffLayer sd = (AbstractSameDiffLayer)layer;
        return sd.getLayerParams().getBiasParameterKeys();
    }

    @Override
    public boolean isWeightParam(Layer layer, String key) {
        return this.weightKeys(layer).contains(key);
    }

    @Override
    public boolean isBiasParam(Layer layer, String key) {
        return this.biasKeys(layer).contains(key);
    }

    @Override
    public Map<String, INDArray> init(NeuralNetConfiguration conf, INDArray paramsView, boolean initializeParams) {
        AbstractSameDiffLayer sd = (AbstractSameDiffLayer)conf.getLayer();
        Map<String, INDArray> out = this.subsetAndReshape(sd.getLayerParams().getParameterKeys(), sd.getLayerParams().getParamShapes(), paramsView, sd);
        if (initializeParams) {
            sd.initializeParameters(out);
        }
        for (String s : sd.getLayerParams().getParameterKeys()) {
            conf.addVariable(s);
        }
        return out;
    }

    @Override
    public Map<String, INDArray> getGradientsFromFlattened(NeuralNetConfiguration conf, INDArray gradientView) {
        AbstractSameDiffLayer sd = (AbstractSameDiffLayer)conf.getLayer();
        return this.subsetAndReshape(sd.getLayerParams().getParameterKeys(), sd.getLayerParams().getParamShapes(), gradientView, sd);
    }

    private Map<String, INDArray> subsetAndReshape(List<String> params, Map<String, int[]> paramShapes, INDArray view, AbstractSameDiffLayer sdl) {
        LinkedHashMap<String, INDArray> out = new LinkedHashMap<String, INDArray>();
        int soFar = 0;
        for (String s : params) {
            int[] sh = paramShapes.get(s);
            int length = ArrayUtil.prod((int[])sh);
            INDArray sub = view.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)soFar, (int)(soFar + length))});
            if (!Arrays.equals(sub.shape(), sh)) {
                sub = sub.reshape(sdl.paramReshapeOrder(s), sh);
            }
            out.put(s, sub);
            soFar += length;
        }
        return out;
    }
}

