/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.distribution.Distributions;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.weights.WeightInitUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class ConvolutionParamInitializer
implements ParamInitializer {
    private static final ConvolutionParamInitializer INSTANCE = new ConvolutionParamInitializer();
    public static final String WEIGHT_KEY = "W";
    public static final String BIAS_KEY = "b";

    public static ConvolutionParamInitializer getInstance() {
        return INSTANCE;
    }

    @Override
    public int numParams(NeuralNetConfiguration conf) {
        return this.numParams(conf.getLayer());
    }

    @Override
    public int numParams(Layer l) {
        ConvolutionLayer layerConf = (ConvolutionLayer)l;
        int[] kernel = layerConf.getKernelSize();
        int nIn = layerConf.getNIn();
        int nOut = layerConf.getNOut();
        return nIn * nOut * kernel[0] * kernel[1] + (layerConf.hasBias() ? nOut : 0);
    }

    @Override
    public List<String> paramKeys(Layer layer) {
        ConvolutionLayer layerConf = (ConvolutionLayer)layer;
        if (layerConf.hasBias()) {
            return Arrays.asList(WEIGHT_KEY, BIAS_KEY);
        }
        return this.weightKeys(layer);
    }

    @Override
    public List<String> weightKeys(Layer layer) {
        return Collections.singletonList(WEIGHT_KEY);
    }

    @Override
    public List<String> biasKeys(Layer layer) {
        ConvolutionLayer layerConf = (ConvolutionLayer)layer;
        if (layerConf.hasBias()) {
            return Collections.singletonList(BIAS_KEY);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isWeightParam(Layer layer, String key) {
        return WEIGHT_KEY.equals(key);
    }

    @Override
    public boolean isBiasParam(Layer layer, String key) {
        return BIAS_KEY.equals(key);
    }

    @Override
    public Map<String, INDArray> init(NeuralNetConfiguration conf, INDArray paramsView, boolean initializeParams) {
        ConvolutionLayer layer = (ConvolutionLayer)conf.getLayer();
        if (layer.getKernelSize().length != 2) {
            throw new IllegalArgumentException("Filter size must be == 2");
        }
        Map<String, INDArray> params = Collections.synchronizedMap(new LinkedHashMap());
        ConvolutionLayer layerConf = (ConvolutionLayer)conf.getLayer();
        int nOut = layerConf.getNOut();
        if (layer.hasBias()) {
            INDArray biasView = paramsView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)0, (int)nOut)});
            INDArray weightView = paramsView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)nOut, (int)this.numParams(conf))});
            params.put(BIAS_KEY, this.createBias(conf, biasView, initializeParams));
            params.put(WEIGHT_KEY, this.createWeightMatrix(conf, weightView, initializeParams));
            conf.addVariable(WEIGHT_KEY);
            conf.addVariable(BIAS_KEY);
        } else {
            INDArray weightView = paramsView;
            params.put(WEIGHT_KEY, this.createWeightMatrix(conf, weightView, initializeParams));
            conf.addVariable(WEIGHT_KEY);
        }
        return params;
    }

    @Override
    public Map<String, INDArray> getGradientsFromFlattened(NeuralNetConfiguration conf, INDArray gradientView) {
        ConvolutionLayer layerConf = (ConvolutionLayer)conf.getLayer();
        int[] kernel = layerConf.getKernelSize();
        int nIn = layerConf.getNIn();
        int nOut = layerConf.getNOut();
        LinkedHashMap<String, INDArray> out = new LinkedHashMap<String, INDArray>();
        if (layerConf.hasBias()) {
            INDArray biasGradientView = gradientView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)0, (int)nOut)});
            INDArray weightGradientView = gradientView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)nOut, (int)this.numParams(conf))}).reshape('c', new int[]{nOut, nIn, kernel[0], kernel[1]});
            out.put(BIAS_KEY, biasGradientView);
            out.put(WEIGHT_KEY, weightGradientView);
        } else {
            INDArray weightGradientView = gradientView.reshape('c', new int[]{nOut, nIn, kernel[0], kernel[1]});
            out.put(WEIGHT_KEY, weightGradientView);
        }
        return out;
    }

    protected INDArray createBias(NeuralNetConfiguration conf, INDArray biasView, boolean initializeParams) {
        ConvolutionLayer layerConf = (ConvolutionLayer)conf.getLayer();
        if (initializeParams) {
            biasView.assign((Number)layerConf.getBiasInit());
        }
        return biasView;
    }

    protected INDArray createWeightMatrix(NeuralNetConfiguration conf, INDArray weightView, boolean initializeParams) {
        ConvolutionLayer layerConf = (ConvolutionLayer)conf.getLayer();
        if (initializeParams) {
            Distribution dist = Distributions.createDistribution(layerConf.getDist());
            int[] kernel = layerConf.getKernelSize();
            int[] stride = layerConf.getStride();
            int inputDepth = layerConf.getNIn();
            int outputDepth = layerConf.getNOut();
            double fanIn = inputDepth * kernel[0] * kernel[1];
            double fanOut = (double)(outputDepth * kernel[0] * kernel[1]) / ((double)stride[0] * (double)stride[1]);
            int[] weightsShape = new int[]{outputDepth, inputDepth, kernel[0], kernel[1]};
            return WeightInitUtil.initWeights(fanIn, fanOut, weightsShape, layerConf.getWeightInit(), dist, 'c', weightView);
        }
        int[] kernel = layerConf.getKernelSize();
        return WeightInitUtil.reshapeWeights(new int[]{layerConf.getNOut(), layerConf.getNIn(), kernel[0], kernel[1]}, weightView, 'c');
    }
}

