/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.feedforward.elementwise;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.primitives.Pair;

public class ElementWiseMultiplicationLayer
extends BaseLayer<org.deeplearning4j.nn.conf.layers.misc.ElementWiseMultiplicationLayer> {
    public ElementWiseMultiplicationLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public ElementWiseMultiplicationLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        INDArray z = this.preOutput(true);
        INDArray delta = (INDArray)((org.deeplearning4j.nn.conf.layers.misc.ElementWiseMultiplicationLayer)this.layerConf()).getActivationFn().backprop(z, epsilon).getFirst();
        if (this.maskArray != null) {
            this.applyMask(delta);
        }
        DefaultGradient ret = new DefaultGradient();
        INDArray weightGrad = (INDArray)this.gradientViews.get("W");
        weightGrad.subi(weightGrad);
        weightGrad.addi(this.input.mul(delta).sum(new int[]{0}));
        INDArray biasGrad = (INDArray)this.gradientViews.get("b");
        delta.sum(biasGrad, new int[]{0});
        ret.gradientForVariable().put("W", weightGrad);
        ret.gradientForVariable().put("b", biasGrad);
        INDArray epsilonNext = delta.mulRowVector((INDArray)this.params.get("W"));
        return new Pair((Object)ret, (Object)epsilonNext);
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public INDArray preOutput(boolean training) {
        INDArray b = this.getParam("b");
        INDArray W = this.getParam("W");
        if (this.input.columns() != W.columns()) {
            throw new DL4JInvalidInputException("Input size (" + this.input.columns() + " columns; shape = " + Arrays.toString(this.input.shape()) + ") is invalid: does not match layer input size (layer # inputs = " + W.shapeInfoToString() + ") " + this.layerId());
        }
        this.applyDropOutIfNecessary(training);
        INDArray ret = Nd4j.zeros((int)this.input.rows(), (int)this.input.columns());
        for (int row = 0; row < this.input.rows(); ++row) {
            ret.put(new INDArrayIndex[]{NDArrayIndex.point((int)row), NDArrayIndex.all()}, this.input.getRow(row).mul(W).addRowVector(b));
        }
        if (this.maskArray != null) {
            this.applyMask(ret);
        }
        return ret;
    }
}

