/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.graph.vertex.impl;

import java.util.Arrays;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.BaseGraphVertex;
import org.deeplearning4j.nn.graph.vertex.VertexIndices;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.transforms.Or;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.primitives.Pair;

public class MergeVertex
extends BaseGraphVertex {
    private int[][] forwardPassShapes;
    private int fwdPassRank;

    public MergeVertex(ComputationGraph graph, String name, int vertexIndex) {
        this(graph, name, vertexIndex, null, null);
    }

    public MergeVertex(ComputationGraph graph, String name, int vertexIndex, VertexIndices[] inputVertices, VertexIndices[] outputVertices) {
        super(graph, name, vertexIndex, inputVertices, outputVertices);
    }

    @Override
    public String toString() {
        return "MergeVertex(id=" + this.getVertexIndex() + ",name=\"" + this.getVertexName() + "\")";
    }

    @Override
    public boolean hasLayer() {
        return false;
    }

    @Override
    public Layer getLayer() {
        return null;
    }

    @Override
    public INDArray doForward(boolean training) {
        INDArray out;
        if (!this.canDoForward()) {
            throw new IllegalStateException("Cannot do forward pass: inputs not set");
        }
        if (this.inputs.length == 1) {
            int[] shape = this.inputs[0].shape();
            this.forwardPassShapes = new int[][]{Arrays.copyOf(shape, shape.length)};
            return this.inputs[0];
        }
        this.forwardPassShapes = new int[this.inputs.length][0];
        int nExamples = this.inputs[0].size(0);
        int nOut = 0;
        this.fwdPassRank = this.inputs[0].rank();
        for (int i = 0; i < this.inputs.length; ++i) {
            int[] currShape = this.inputs[i].shape();
            if (this.fwdPassRank != currShape.length) {
                throw new IllegalStateException("Cannot merge activations with different ranks: first activations have rank " + this.fwdPassRank + ", activations[" + i + "] have rank " + currShape.length + " (shape=" + Arrays.toString(currShape) + ")");
            }
            this.forwardPassShapes[i] = Arrays.copyOf(currShape, currShape.length);
            if (currShape[0] != nExamples) {
                throw new IllegalStateException("Cannot merge activations with different number of examples (activations[0] shape: " + Arrays.toString(this.inputs[0].shape()) + ", activations[" + i + "] shape: " + Arrays.toString(this.inputs[i].shape()));
            }
            nOut += currShape[1];
        }
        boolean nOutCumulative = false;
        switch (this.inputs[0].rank()) {
            case 2: {
                out = Nd4j.hstack((INDArray[])this.inputs);
                break;
            }
            case 3: {
                out = Nd4j.hstack((INDArray[])this.inputs);
                break;
            }
            case 4: {
                this.fwdPassRank = 4;
                out = Nd4j.hstack((INDArray[])this.inputs);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot merge activations with rank 4 or more");
            }
        }
        return out;
    }

    @Override
    public Pair<Gradient, INDArray[]> doBackward(boolean tbptt) {
        if (!this.canDoBackward()) {
            throw new IllegalStateException("Cannot do backward pass: errors not set");
        }
        if (this.forwardPassShapes.length == 1) {
            return new Pair(null, (Object)new INDArray[]{this.epsilon});
        }
        INDArray[] out = new INDArray[this.forwardPassShapes.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = Nd4j.createUninitialized((int[])this.forwardPassShapes[i]);
        }
        int cumulative = 0;
        switch (this.fwdPassRank) {
            case 2: {
                for (int i = 0; i < this.forwardPassShapes.length; ++i) {
                    out[i].assign(this.epsilon.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)cumulative, (int)(cumulative + this.forwardPassShapes[i][1]))}));
                    cumulative += this.forwardPassShapes[i][1];
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.forwardPassShapes.length; ++i) {
                    out[i].assign(this.epsilon.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)cumulative, (int)(cumulative + this.forwardPassShapes[i][1])), NDArrayIndex.all()}));
                    cumulative += this.forwardPassShapes[i][1];
                }
                break;
            }
            case 4: {
                for (int i = 0; i < this.forwardPassShapes.length; ++i) {
                    out[i].assign(this.epsilon.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)cumulative, (int)(cumulative + this.forwardPassShapes[i][1])), NDArrayIndex.all(), NDArrayIndex.all()}));
                    cumulative += this.forwardPassShapes[i][1];
                }
                break;
            }
            default: {
                throw new RuntimeException("Invalid rank during forward pass (not 2, 3, 4)");
            }
        }
        return new Pair(null, (Object)out);
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray backpropGradientsViewArray) {
        if (backpropGradientsViewArray != null) {
            throw new RuntimeException("Vertex does not have gradients; gradients view array cannot be set here");
        }
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArrays(INDArray[] maskArrays, MaskState currentMaskState, int minibatchSize) {
        if (maskArrays == null) {
            return new Pair(null, (Object)currentMaskState);
        }
        for (INDArray arr : maskArrays) {
            if (arr != null) continue;
            return new Pair(null, (Object)currentMaskState);
        }
        if (maskArrays.length == 1) {
            return new Pair((Object)maskArrays[0], (Object)currentMaskState);
        }
        INDArray ret = maskArrays[0].dup(maskArrays[0].ordering());
        Nd4j.getExecutioner().exec((Op)new Or(maskArrays[0], maskArrays[1], ret));
        for (int i = 2; i < maskArrays.length; ++i) {
            Nd4j.getExecutioner().exec((Op)new Or(maskArrays[i], ret, ret));
        }
        return new Pair((Object)ret, (Object)currentMaskState);
    }
}

