/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.serde;

import java.io.IOException;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.layers.BaseLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.nd4j.linalg.learning.config.AdaDelta;
import org.nd4j.linalg.learning.config.AdaGrad;
import org.nd4j.linalg.learning.config.AdaMax;
import org.nd4j.linalg.learning.config.Adam;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.config.Nadam;
import org.nd4j.linalg.learning.config.Nesterovs;
import org.nd4j.linalg.learning.config.RmsProp;
import org.nd4j.linalg.learning.config.Sgd;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.databind.JsonDeserializer;
import org.nd4j.shade.jackson.databind.JsonMappingException;
import org.nd4j.shade.jackson.databind.deser.ResolvableDeserializer;
import org.nd4j.shade.jackson.databind.deser.std.StdDeserializer;
import org.nd4j.shade.jackson.databind.node.ObjectNode;

public abstract class BaseNetConfigDeserializer<T>
extends StdDeserializer<T>
implements ResolvableDeserializer {
    protected final JsonDeserializer<?> defaultDeserializer;

    public BaseNetConfigDeserializer(JsonDeserializer<?> defaultDeserializer, Class<T> deserializedType) {
        super(deserializedType);
        this.defaultDeserializer = defaultDeserializer;
    }

    public abstract T deserialize(JsonParser var1, DeserializationContext var2) throws IOException, JsonProcessingException;

    protected boolean requiresIUpdaterFromLegacy(Layer[] layers) {
        for (Layer l : layers) {
            BaseLayer bl;
            if (!(l instanceof BaseLayer) || (bl = (BaseLayer)l).getIUpdater() != null || bl.initializer().numParams(bl) <= 0) continue;
            return true;
        }
        return false;
    }

    protected boolean requiresDropoutFromLegacy(Layer[] layers) {
        for (Layer l : layers) {
            if (l.getIDropout() == null) continue;
            return false;
        }
        return true;
    }

    protected void handleUpdaterBackwardCompatibility(BaseLayer layer, ObjectNode on) {
        String updaterName;
        if (on != null && on.has("updater") && (updaterName = on.get("updater").asText()) != null) {
            Updater u = Updater.valueOf(updaterName);
            IUpdater iu = u.getIUpdaterWithDefaultConfig();
            double lr = on.get("learningRate").asDouble();
            double eps = on.has("epsilon") ? on.get("epsilon").asDouble() : Double.NaN;
            double rho = on.get("rho").asDouble();
            switch (u) {
                case SGD: {
                    ((Sgd)iu).setLearningRate(lr);
                    break;
                }
                case ADAM: {
                    if (Double.isNaN(eps)) {
                        eps = 1.0E-8;
                    }
                    ((Adam)iu).setLearningRate(lr);
                    ((Adam)iu).setBeta1(on.get("adamMeanDecay").asDouble());
                    ((Adam)iu).setBeta2(on.get("adamVarDecay").asDouble());
                    ((Adam)iu).setEpsilon(eps);
                    break;
                }
                case ADAMAX: {
                    if (Double.isNaN(eps)) {
                        eps = 1.0E-8;
                    }
                    ((AdaMax)iu).setLearningRate(lr);
                    ((AdaMax)iu).setBeta1(on.get("adamMeanDecay").asDouble());
                    ((AdaMax)iu).setBeta2(on.get("adamVarDecay").asDouble());
                    ((AdaMax)iu).setEpsilon(eps);
                    break;
                }
                case ADADELTA: {
                    if (Double.isNaN(eps)) {
                        eps = 1.0E-6;
                    }
                    ((AdaDelta)iu).setRho(rho);
                    ((AdaDelta)iu).setEpsilon(eps);
                    break;
                }
                case NESTEROVS: {
                    ((Nesterovs)iu).setLearningRate(lr);
                    ((Nesterovs)iu).setMomentum(on.get("momentum").asDouble());
                    break;
                }
                case NADAM: {
                    if (Double.isNaN(eps)) {
                        eps = 1.0E-8;
                    }
                    ((Nadam)iu).setLearningRate(lr);
                    ((Nadam)iu).setBeta1(on.get("adamMeanDecay").asDouble());
                    ((Nadam)iu).setBeta2(on.get("adamVarDecay").asDouble());
                    ((Nadam)iu).setEpsilon(eps);
                    break;
                }
                case ADAGRAD: {
                    if (Double.isNaN(eps)) {
                        eps = 1.0E-6;
                    }
                    ((AdaGrad)iu).setLearningRate(lr);
                    ((AdaGrad)iu).setEpsilon(eps);
                    break;
                }
                case RMSPROP: {
                    if (Double.isNaN(eps)) {
                        eps = 1.0E-8;
                    }
                    ((RmsProp)iu).setLearningRate(lr);
                    ((RmsProp)iu).setEpsilon(eps);
                    ((RmsProp)iu).setRmsDecay(on.get("rmsDecay").asDouble());
                    break;
                }
            }
            layer.setIUpdater(iu);
        }
    }

    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        ((ResolvableDeserializer)this.defaultDeserializer).resolve(ctxt);
    }
}

