/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers.convolutional;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import lombok.NonNull;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.NoParamLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.layers.convolution.Cropping2DLayer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.linalg.api.ndarray.INDArray;

public class Cropping2D
extends NoParamLayer {
    private int[] cropping;

    public Cropping2D(int cropTopBottom, int cropLeftRight) {
        this(cropTopBottom, cropTopBottom, cropLeftRight, cropLeftRight);
    }

    public Cropping2D(int cropTop, int cropBottom, int cropLeft, int cropRight) {
        this(new Builder(cropTop, cropBottom, cropLeft, cropRight));
    }

    public Cropping2D(int[] cropping) {
        this(new Builder(cropping));
    }

    protected Cropping2D(Builder builder) {
        super(builder);
        this.cropping = builder.cropping;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<IterationListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        Cropping2DLayer ret = new Cropping2DLayer(conf);
        ret.setListeners(iterationListeners);
        ret.setIndex(layerIndex);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        int[] hwd = ConvolutionUtils.getHWDFromInputType(inputType);
        int outH = hwd[0] - this.cropping[0] - this.cropping[1];
        int outW = hwd[1] - this.cropping[2] - this.cropping[3];
        return InputType.convolutional(outH, outW, hwd[2]);
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        Preconditions.checkArgument((inputType != null ? 1 : 0) != 0, (Object)("Invalid input for Cropping2D layer (layer name=\"" + this.getLayerName() + "\"): InputType is null"));
        return InputTypeUtil.getPreProcessorForInputTypeCnnLayers(inputType, this.getLayerName());
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        return null;
    }

    public int[] getCropping() {
        return this.cropping;
    }

    public void setCropping(int[] cropping) {
        this.cropping = cropping;
    }

    @Override
    public String toString() {
        return "Cropping2D(cropping=" + Arrays.toString(this.getCropping()) + ")";
    }

    public Cropping2D() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cropping2D)) {
            return false;
        }
        Cropping2D other = (Cropping2D)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.getCropping(), other.getCropping());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Cropping2D;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getCropping());
        return result;
    }

    public static class Builder
    extends Layer.Builder<Builder> {
        private int[] cropping = new int[]{0, 0, 0, 0};

        public Builder() {
        }

        public Builder(@NonNull int[] cropping) {
            if (cropping == null) {
                throw new NullPointerException("cropping");
            }
            Preconditions.checkArgument((cropping.length == 4 || cropping.length == 2 ? 1 : 0) != 0, (Object)("Either 2 or 4 cropping values,  i.e. (top/bottom. left/right) or (top, bottom, left, right) must be provided. Got " + cropping.length + " values: " + Arrays.toString(cropping)));
            this.cropping = cropping.length == 2 ? new int[]{cropping[0], cropping[0], cropping[1], cropping[1]} : cropping;
        }

        public Builder(int cropTopBottom, int cropLeftRight) {
            this(cropTopBottom, cropTopBottom, cropLeftRight, cropLeftRight);
        }

        public Builder(int cropTop, int cropBottom, int cropLeft, int cropRight) {
            this.cropping = new int[]{cropTop, cropBottom, cropLeft, cropRight};
            Preconditions.checkArgument((cropTop >= 0 && cropBottom >= 0 && cropLeft >= 0 && cropRight >= 0 ? 1 : 0) != 0, (Object)("Invalid arguments: crop dimensions must be > 0. Got [t,b,l,r] = " + Arrays.toString(this.cropping)));
        }

        @Override
        public Cropping2D build() {
            return new Cropping2D(this);
        }
    }
}

