/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.io.Serializable;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.weightnoise.IWeightNoise;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.learning.config.IUpdater;

public abstract class BaseLayer
extends Layer
implements Serializable,
Cloneable {
    protected IActivation activationFn;
    protected WeightInit weightInit;
    protected double biasInit;
    protected Distribution dist;
    protected double l1;
    protected double l2;
    protected double l1Bias;
    protected double l2Bias;
    protected IUpdater iUpdater;
    protected IUpdater biasUpdater;
    protected IWeightNoise weightNoise;
    protected GradientNormalization gradientNormalization = GradientNormalization.None;
    protected double gradientNormalizationThreshold = 1.0;

    public BaseLayer(Builder builder) {
        super(builder);
        this.layerName = builder.layerName;
        this.activationFn = builder.activationFn;
        this.weightInit = builder.weightInit;
        this.biasInit = builder.biasInit;
        this.dist = builder.dist;
        this.l1 = builder.l1;
        this.l2 = builder.l2;
        this.l1Bias = builder.l1Bias;
        this.l2Bias = builder.l2Bias;
        this.iUpdater = builder.iupdater;
        this.biasUpdater = builder.biasUpdater;
        this.gradientNormalization = builder.gradientNormalization;
        this.gradientNormalizationThreshold = builder.gradientNormalizationThreshold;
        this.weightNoise = builder.weightNoise;
    }

    @Override
    public void resetLayerDefaultConfig() {
        this.setIUpdater(null);
        this.setWeightInit(null);
        this.setBiasInit(Double.NaN);
        this.setDist(null);
        this.setL1(Double.NaN);
        this.setL2(Double.NaN);
        this.setGradientNormalization(GradientNormalization.None);
        this.setGradientNormalizationThreshold(1.0);
        this.iUpdater = null;
        this.biasUpdater = null;
    }

    @Override
    public BaseLayer clone() {
        BaseLayer clone = (BaseLayer)super.clone();
        if (clone.dist != null) {
            clone.dist = clone.dist.clone();
        }
        return clone;
    }

    @Override
    public IUpdater getUpdaterByParam(String paramName) {
        if (this.biasUpdater != null && this.initializer().isBiasParam(this, paramName)) {
            return this.biasUpdater;
        }
        return this.iUpdater;
    }

    public IActivation getActivationFn() {
        return this.activationFn;
    }

    public WeightInit getWeightInit() {
        return this.weightInit;
    }

    public double getBiasInit() {
        return this.biasInit;
    }

    public Distribution getDist() {
        return this.dist;
    }

    public double getL1() {
        return this.l1;
    }

    public double getL2() {
        return this.l2;
    }

    public double getL1Bias() {
        return this.l1Bias;
    }

    public double getL2Bias() {
        return this.l2Bias;
    }

    public IUpdater getIUpdater() {
        return this.iUpdater;
    }

    public IUpdater getBiasUpdater() {
        return this.biasUpdater;
    }

    public IWeightNoise getWeightNoise() {
        return this.weightNoise;
    }

    public GradientNormalization getGradientNormalization() {
        return this.gradientNormalization;
    }

    public double getGradientNormalizationThreshold() {
        return this.gradientNormalizationThreshold;
    }

    public void setActivationFn(IActivation activationFn) {
        this.activationFn = activationFn;
    }

    public void setWeightInit(WeightInit weightInit) {
        this.weightInit = weightInit;
    }

    public void setBiasInit(double biasInit) {
        this.biasInit = biasInit;
    }

    public void setDist(Distribution dist) {
        this.dist = dist;
    }

    public void setL1(double l1) {
        this.l1 = l1;
    }

    public void setL2(double l2) {
        this.l2 = l2;
    }

    public void setL1Bias(double l1Bias) {
        this.l1Bias = l1Bias;
    }

    public void setL2Bias(double l2Bias) {
        this.l2Bias = l2Bias;
    }

    public void setIUpdater(IUpdater iUpdater) {
        this.iUpdater = iUpdater;
    }

    public void setBiasUpdater(IUpdater biasUpdater) {
        this.biasUpdater = biasUpdater;
    }

    public void setWeightNoise(IWeightNoise weightNoise) {
        this.weightNoise = weightNoise;
    }

    public void setGradientNormalization(GradientNormalization gradientNormalization) {
        this.gradientNormalization = gradientNormalization;
    }

    public void setGradientNormalizationThreshold(double gradientNormalizationThreshold) {
        this.gradientNormalizationThreshold = gradientNormalizationThreshold;
    }

    @Override
    public String toString() {
        return "BaseLayer(activationFn=" + this.getActivationFn() + ", weightInit=" + (Object)((Object)this.getWeightInit()) + ", biasInit=" + this.getBiasInit() + ", dist=" + this.getDist() + ", l1=" + this.getL1() + ", l2=" + this.getL2() + ", l1Bias=" + this.getL1Bias() + ", l2Bias=" + this.getL2Bias() + ", iUpdater=" + this.getIUpdater() + ", biasUpdater=" + this.getBiasUpdater() + ", weightNoise=" + this.getWeightNoise() + ", gradientNormalization=" + (Object)((Object)this.getGradientNormalization()) + ", gradientNormalizationThreshold=" + this.getGradientNormalizationThreshold() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseLayer)) {
            return false;
        }
        BaseLayer other = (BaseLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IActivation this$activationFn = this.getActivationFn();
        IActivation other$activationFn = other.getActivationFn();
        if (this$activationFn == null ? other$activationFn != null : !this$activationFn.equals(other$activationFn)) {
            return false;
        }
        WeightInit this$weightInit = this.getWeightInit();
        WeightInit other$weightInit = other.getWeightInit();
        if (this$weightInit == null ? other$weightInit != null : !((Object)((Object)this$weightInit)).equals((Object)other$weightInit)) {
            return false;
        }
        if (Double.compare(this.getBiasInit(), other.getBiasInit()) != 0) {
            return false;
        }
        Distribution this$dist = this.getDist();
        Distribution other$dist = other.getDist();
        if (this$dist == null ? other$dist != null : !this$dist.equals(other$dist)) {
            return false;
        }
        if (Double.compare(this.getL1(), other.getL1()) != 0) {
            return false;
        }
        if (Double.compare(this.getL2(), other.getL2()) != 0) {
            return false;
        }
        if (Double.compare(this.getL1Bias(), other.getL1Bias()) != 0) {
            return false;
        }
        if (Double.compare(this.getL2Bias(), other.getL2Bias()) != 0) {
            return false;
        }
        IUpdater this$iUpdater = this.getIUpdater();
        IUpdater other$iUpdater = other.getIUpdater();
        if (this$iUpdater == null ? other$iUpdater != null : !this$iUpdater.equals(other$iUpdater)) {
            return false;
        }
        IUpdater this$biasUpdater = this.getBiasUpdater();
        IUpdater other$biasUpdater = other.getBiasUpdater();
        if (this$biasUpdater == null ? other$biasUpdater != null : !this$biasUpdater.equals(other$biasUpdater)) {
            return false;
        }
        IWeightNoise this$weightNoise = this.getWeightNoise();
        IWeightNoise other$weightNoise = other.getWeightNoise();
        if (this$weightNoise == null ? other$weightNoise != null : !this$weightNoise.equals(other$weightNoise)) {
            return false;
        }
        GradientNormalization this$gradientNormalization = this.getGradientNormalization();
        GradientNormalization other$gradientNormalization = other.getGradientNormalization();
        if (this$gradientNormalization == null ? other$gradientNormalization != null : !((Object)((Object)this$gradientNormalization)).equals((Object)other$gradientNormalization)) {
            return false;
        }
        return Double.compare(this.getGradientNormalizationThreshold(), other.getGradientNormalizationThreshold()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        IActivation $activationFn = this.getActivationFn();
        result = result * 59 + ($activationFn == null ? 43 : $activationFn.hashCode());
        WeightInit $weightInit = this.getWeightInit();
        result = result * 59 + ($weightInit == null ? 43 : ((Object)((Object)$weightInit)).hashCode());
        long $biasInit = Double.doubleToLongBits(this.getBiasInit());
        result = result * 59 + (int)($biasInit >>> 32 ^ $biasInit);
        Distribution $dist = this.getDist();
        result = result * 59 + ($dist == null ? 43 : $dist.hashCode());
        long $l1 = Double.doubleToLongBits(this.getL1());
        result = result * 59 + (int)($l1 >>> 32 ^ $l1);
        long $l2 = Double.doubleToLongBits(this.getL2());
        result = result * 59 + (int)($l2 >>> 32 ^ $l2);
        long $l1Bias = Double.doubleToLongBits(this.getL1Bias());
        result = result * 59 + (int)($l1Bias >>> 32 ^ $l1Bias);
        long $l2Bias = Double.doubleToLongBits(this.getL2Bias());
        result = result * 59 + (int)($l2Bias >>> 32 ^ $l2Bias);
        IUpdater $iUpdater = this.getIUpdater();
        result = result * 59 + ($iUpdater == null ? 43 : $iUpdater.hashCode());
        IUpdater $biasUpdater = this.getBiasUpdater();
        result = result * 59 + ($biasUpdater == null ? 43 : $biasUpdater.hashCode());
        IWeightNoise $weightNoise = this.getWeightNoise();
        result = result * 59 + ($weightNoise == null ? 43 : $weightNoise.hashCode());
        GradientNormalization $gradientNormalization = this.getGradientNormalization();
        result = result * 59 + ($gradientNormalization == null ? 43 : ((Object)((Object)$gradientNormalization)).hashCode());
        long $gradientNormalizationThreshold = Double.doubleToLongBits(this.getGradientNormalizationThreshold());
        result = result * 59 + (int)($gradientNormalizationThreshold >>> 32 ^ $gradientNormalizationThreshold);
        return result;
    }

    public BaseLayer() {
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Layer.Builder<T> {
        protected IActivation activationFn = null;
        protected WeightInit weightInit = null;
        protected double biasInit = Double.NaN;
        protected Distribution dist = null;
        protected double l1 = Double.NaN;
        protected double l2 = Double.NaN;
        protected double l1Bias = Double.NaN;
        protected double l2Bias = Double.NaN;
        protected IUpdater iupdater = null;
        protected IUpdater biasUpdater = null;
        protected GradientNormalization gradientNormalization = null;
        protected double gradientNormalizationThreshold = Double.NaN;
        protected IWeightNoise weightNoise;

        public T activation(IActivation activationFunction) {
            this.activationFn = activationFunction;
            return (T)this;
        }

        public T activation(Activation activation) {
            return this.activation(activation.getActivationFunction());
        }

        public T weightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
            return (T)this;
        }

        public T weightInit(Distribution distribution) {
            this.weightInit(WeightInit.DISTRIBUTION);
            return this.dist(distribution);
        }

        public T biasInit(double biasInit) {
            this.biasInit = biasInit;
            return (T)this;
        }

        public T dist(Distribution dist) {
            this.dist = dist;
            return (T)this;
        }

        public T l1(double l1) {
            this.l1 = l1;
            return (T)this;
        }

        public T l2(double l2) {
            this.l2 = l2;
            return (T)this;
        }

        public T l1Bias(double l1Bias) {
            this.l1Bias = l1Bias;
            return (T)this;
        }

        public T l2Bias(double l2Bias) {
            this.l2Bias = l2Bias;
            return (T)this;
        }

        @Deprecated
        public T updater(Updater updater) {
            return this.updater(updater.getIUpdaterWithDefaultConfig());
        }

        public T updater(IUpdater updater) {
            this.iupdater = updater;
            return (T)this;
        }

        public T biasUpdater(IUpdater biasUpdater) {
            this.biasUpdater = biasUpdater;
            return (T)this;
        }

        public T gradientNormalization(GradientNormalization gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
            return (T)this;
        }

        public T gradientNormalizationThreshold(double threshold) {
            this.gradientNormalizationThreshold = threshold;
            return (T)this;
        }

        public T weightNoise(IWeightNoise weightNoise) {
            this.weightNoise = weightNoise;
            return (T)this;
        }
    }
}

