/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.eval.curves;

import java.util.Arrays;
import org.deeplearning4j.eval.curves.BaseHistogram;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class Histogram
extends BaseHistogram {
    private final String title;
    private final double lower;
    private final double upper;
    private final int[] binCounts;

    public Histogram(@JsonProperty(value="title") String title, @JsonProperty(value="lower") double lower, @JsonProperty(value="upper") double upper, @JsonProperty(value="binCounts") int[] binCounts) {
        this.title = title;
        this.lower = lower;
        this.upper = upper;
        this.binCounts = binCounts;
    }

    @Override
    public int numPoints() {
        return this.binCounts.length;
    }

    @Override
    public double[] getBinLowerBounds() {
        double step = 1.0 / (double)this.binCounts.length;
        double[] out = new double[this.binCounts.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = (double)i * step;
        }
        return out;
    }

    @Override
    public double[] getBinUpperBounds() {
        double step = 1.0 / (double)this.binCounts.length;
        double[] out = new double[this.binCounts.length];
        for (int i = 0; i < out.length - 1; ++i) {
            out[i] = (double)(i + 1) * step;
        }
        out[out.length - 1] = 1.0;
        return out;
    }

    @Override
    public double[] getBinMidValues() {
        double step = 1.0 / (double)this.binCounts.length;
        double[] out = new double[this.binCounts.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = ((double)i + 0.5) * step;
        }
        return out;
    }

    public static Histogram fromJson(String json) {
        return BaseHistogram.fromJson(json, Histogram.class);
    }

    public static Histogram fromYaml(String yaml) {
        return BaseHistogram.fromYaml(yaml, Histogram.class);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public double getLower() {
        return this.lower;
    }

    public double getUpper() {
        return this.upper;
    }

    @Override
    public int[] getBinCounts() {
        return this.binCounts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Histogram)) {
            return false;
        }
        Histogram other = (Histogram)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        if (Double.compare(this.getLower(), other.getLower()) != 0) {
            return false;
        }
        if (Double.compare(this.getUpper(), other.getUpper()) != 0) {
            return false;
        }
        return Arrays.equals(this.getBinCounts(), other.getBinCounts());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Histogram;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        long $lower = Double.doubleToLongBits(this.getLower());
        result = result * 59 + (int)($lower >>> 32 ^ $lower);
        long $upper = Double.doubleToLongBits(this.getUpper());
        result = result * 59 + (int)($upper >>> 32 ^ $upper);
        result = result * 59 + Arrays.hashCode(this.getBinCounts());
        return result;
    }

    public String toString() {
        return "Histogram(title=" + this.getTitle() + ", lower=" + this.getLower() + ", upper=" + this.getUpper() + ", binCounts=" + Arrays.toString(this.getBinCounts()) + ")";
    }
}

