/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.listeners;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.BaseTrainingListener;

public class CollectScoresIterationListener
extends BaseTrainingListener {
    private int frequency;
    private int iterationCount = 0;
    ScoreStat scoreVsIter = new ScoreStat();

    public CollectScoresIterationListener() {
        this(1);
    }

    public CollectScoresIterationListener(int frequency) {
        if (frequency <= 0) {
            frequency = 1;
        }
        this.frequency = frequency;
    }

    @Override
    public void iterationDone(Model model, int iteration, int epoch) {
        if (++this.iterationCount % this.frequency == 0) {
            double score = model.score();
            this.scoreVsIter.reallocateGuard();
            this.scoreVsIter.addScore(iteration, score);
        }
    }

    public ScoreStat getScoreVsIter() {
        return this.scoreVsIter;
    }

    public void exportScores(OutputStream outputStream) throws IOException {
        this.exportScores(outputStream, "\t");
    }

    public void exportScores(OutputStream outputStream, String delimiter) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("Iteration").append(delimiter).append("Score");
        int largeBuckets = this.scoreVsIter.indexes.size();
        for (int j = 0; j < largeBuckets; ++j) {
            long[] indexes = (long[])this.scoreVsIter.indexes.get(j);
            double[] scores = (double[])this.scoreVsIter.scores.get(j);
            int effectiveLength = j < largeBuckets - 1 ? indexes.length : this.scoreVsIter.position;
            for (int i = 0; i < effectiveLength; ++i) {
                sb.append("\n").append(indexes[i]).append(delimiter).append(scores[i]);
            }
        }
        outputStream.write(sb.toString().getBytes("UTF-8"));
    }

    public void exportScores(File file) throws IOException {
        this.exportScores(file, "\t");
    }

    public void exportScores(File file, String delimiter) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.exportScores(fos, delimiter);
        }
    }

    public static class ScoreStat {
        public static final int BUCKET_LENGTH = 10000;
        private int position = 0;
        private int bucketNumber = 1;
        private List<long[]> indexes = new ArrayList<long[]>(1);
        private List<double[]> scores;

        public ScoreStat() {
            this.indexes.add(new long[10000]);
            this.scores = new ArrayList<double[]>(1);
            this.scores.add(new double[10000]);
        }

        public List<long[]> getIndexes() {
            return this.indexes;
        }

        public List<double[]> getScores() {
            return this.scores;
        }

        public long[] getEffectiveIndexes() {
            return Arrays.copyOfRange(this.indexes.get(0), 0, this.position);
        }

        public double[] getEffectiveScores() {
            return Arrays.copyOfRange(this.scores.get(0), 0, this.position);
        }

        private void reallocateGuard() {
            if (this.position >= 10000 * this.bucketNumber) {
                long fullLength = 10000L * (long)this.bucketNumber;
                if (this.position == Integer.MAX_VALUE || fullLength >= Integer.MAX_VALUE) {
                    this.position = 0;
                    long[] newIndexes = new long[10000];
                    double[] newScores = new double[10000];
                    this.indexes.add(newIndexes);
                    this.scores.add(newScores);
                } else {
                    long[] newIndexes = new long[(int)fullLength + 10000];
                    double[] newScores = new double[(int)fullLength + 10000];
                    System.arraycopy(this.indexes.get(this.indexes.size() - 1), 0, newIndexes, 0, (int)fullLength);
                    System.arraycopy(this.scores.get(this.scores.size() - 1), 0, newScores, 0, (int)fullLength);
                    this.scores.remove(this.scores.size() - 1);
                    this.indexes.remove(this.indexes.size() - 1);
                    int lastIndex = this.scores.size() == 0 ? 0 : this.scores.size() - 1;
                    this.scores.add(lastIndex, newScores);
                    this.indexes.add(lastIndex, newIndexes);
                }
                ++this.bucketNumber;
            }
        }

        public void addScore(long index, double score) {
            this.reallocateGuard();
            this.scores.get((int)(this.scores.size() - 1))[this.position] = score;
            this.indexes.get((int)(this.scores.size() - 1))[this.position] = index;
            ++this.position;
        }
    }
}

