/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.DepthwiseConvolution2D;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.weights.WeightInitUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class DepthwiseConvolutionParamInitializer
implements ParamInitializer {
    private static final DepthwiseConvolutionParamInitializer INSTANCE = new DepthwiseConvolutionParamInitializer();
    public static final String WEIGHT_KEY = "W";
    public static final String BIAS_KEY = "b";

    public static DepthwiseConvolutionParamInitializer getInstance() {
        return INSTANCE;
    }

    @Override
    public long numParams(NeuralNetConfiguration conf) {
        return this.numParams(conf.getLayer());
    }

    @Override
    public long numParams(Layer l) {
        DepthwiseConvolution2D layerConf = (DepthwiseConvolution2D)l;
        long depthWiseParams = this.numDepthWiseParams(layerConf);
        long biasParams = this.numBiasParams(layerConf);
        return depthWiseParams + biasParams;
    }

    private long numBiasParams(DepthwiseConvolution2D layerConf) {
        long nOut = layerConf.getNOut();
        return layerConf.hasBias() ? nOut : 0L;
    }

    private long numDepthWiseParams(DepthwiseConvolution2D layerConf) {
        int[] kernel = layerConf.getKernelSize();
        long nIn = layerConf.getNIn();
        int depthMultiplier = layerConf.getDepthMultiplier();
        return nIn * (long)depthMultiplier * (long)kernel[0] * (long)kernel[1];
    }

    @Override
    public List<String> paramKeys(Layer layer) {
        DepthwiseConvolution2D layerConf = (DepthwiseConvolution2D)layer;
        if (layerConf.hasBias()) {
            return Arrays.asList(WEIGHT_KEY, BIAS_KEY);
        }
        return this.weightKeys(layer);
    }

    @Override
    public List<String> weightKeys(Layer layer) {
        return Arrays.asList(WEIGHT_KEY);
    }

    @Override
    public List<String> biasKeys(Layer layer) {
        DepthwiseConvolution2D layerConf = (DepthwiseConvolution2D)layer;
        if (layerConf.hasBias()) {
            return Collections.singletonList(BIAS_KEY);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isWeightParam(Layer layer, String key) {
        return WEIGHT_KEY.equals(key);
    }

    @Override
    public boolean isBiasParam(Layer layer, String key) {
        return BIAS_KEY.equals(key);
    }

    @Override
    public Map<String, INDArray> init(NeuralNetConfiguration conf, INDArray paramsView, boolean initializeParams) {
        DepthwiseConvolution2D layer = (DepthwiseConvolution2D)conf.getLayer();
        if (layer.getKernelSize().length != 2) {
            throw new IllegalArgumentException("Filter size must be == 2");
        }
        Map<String, INDArray> params = Collections.synchronizedMap(new LinkedHashMap());
        DepthwiseConvolution2D layerConf = (DepthwiseConvolution2D)conf.getLayer();
        long depthWiseParams = this.numDepthWiseParams(layerConf);
        long biasParams = this.numBiasParams(layerConf);
        INDArray depthWiseWeightView = paramsView.get(new INDArrayIndex[]{NDArrayIndex.interval((long)0L, (long)0L, (boolean)true), NDArrayIndex.interval((long)biasParams, (long)(biasParams + depthWiseParams))});
        params.put(WEIGHT_KEY, this.createDepthWiseWeightMatrix(conf, depthWiseWeightView, initializeParams));
        conf.addVariable(WEIGHT_KEY);
        if (layer.hasBias()) {
            INDArray biasView = paramsView.get(new INDArrayIndex[]{NDArrayIndex.interval((long)0L, (long)0L, (boolean)true), NDArrayIndex.interval((long)0L, (long)biasParams)});
            params.put(BIAS_KEY, this.createBias(conf, biasView, initializeParams));
            conf.addVariable(BIAS_KEY);
        }
        return params;
    }

    @Override
    public Map<String, INDArray> getGradientsFromFlattened(NeuralNetConfiguration conf, INDArray gradientView) {
        DepthwiseConvolution2D layerConf = (DepthwiseConvolution2D)conf.getLayer();
        int[] kernel = layerConf.getKernelSize();
        long nIn = layerConf.getNIn();
        int depthMultiplier = layerConf.getDepthMultiplier();
        long nOut = layerConf.getNOut();
        LinkedHashMap<String, INDArray> out = new LinkedHashMap<String, INDArray>();
        long depthWiseParams = this.numDepthWiseParams(layerConf);
        long biasParams = this.numBiasParams(layerConf);
        INDArray depthWiseWeightGradientView = gradientView.get(new INDArrayIndex[]{NDArrayIndex.interval((long)0L, (long)0L, (boolean)true), NDArrayIndex.interval((long)biasParams, (long)(biasParams + depthWiseParams))}).reshape('c', new long[]{kernel[0], kernel[1], nIn, depthMultiplier});
        out.put(WEIGHT_KEY, depthWiseWeightGradientView);
        if (layerConf.hasBias()) {
            INDArray biasGradientView = gradientView.get(new INDArrayIndex[]{NDArrayIndex.interval((long)0L, (long)0L, (boolean)true), NDArrayIndex.interval((long)0L, (long)nOut)});
            out.put(BIAS_KEY, biasGradientView);
        }
        return out;
    }

    protected INDArray createBias(NeuralNetConfiguration conf, INDArray biasView, boolean initializeParams) {
        DepthwiseConvolution2D layerConf = (DepthwiseConvolution2D)conf.getLayer();
        if (initializeParams) {
            biasView.assign((Number)layerConf.getBiasInit());
        }
        return biasView;
    }

    protected INDArray createDepthWiseWeightMatrix(NeuralNetConfiguration conf, INDArray weightView, boolean initializeParams) {
        DepthwiseConvolution2D layerConf = (DepthwiseConvolution2D)conf.getLayer();
        int depthMultiplier = layerConf.getDepthMultiplier();
        if (initializeParams) {
            int[] kernel = layerConf.getKernelSize();
            int[] stride = layerConf.getStride();
            long inputDepth = layerConf.getNIn();
            double fanIn = inputDepth * (long)kernel[0] * (long)kernel[1];
            double fanOut = (double)(depthMultiplier * kernel[0] * kernel[1]) / ((double)stride[0] * (double)stride[1]);
            long[] weightsShape = new long[]{kernel[0], kernel[1], inputDepth, depthMultiplier};
            return layerConf.getWeightInitFn().init(fanIn, fanOut, weightsShape, 'c', weightView);
        }
        int[] kernel = layerConf.getKernelSize();
        return WeightInitUtil.reshapeWeights(new long[]{kernel[0], kernel[1], layerConf.getNIn(), depthMultiplier}, weightView, 'c');
    }
}

