/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers.convolutional;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import lombok.NonNull;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.NoParamLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.layers.convolution.Cropping2DLayer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.deeplearning4j.util.ConvolutionUtils;
import org.deeplearning4j.util.ValidationUtils;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class Cropping2D
extends NoParamLayer {
    private int[] cropping;
    private CNN2DFormat dataFormat = CNN2DFormat.NCHW;

    public Cropping2D(int cropTopBottom, int cropLeftRight) {
        this(cropTopBottom, cropTopBottom, cropLeftRight, cropLeftRight);
    }

    public Cropping2D(CNN2DFormat dataFormat, int cropTopBottom, int cropLeftRight) {
        this(dataFormat, cropTopBottom, cropTopBottom, cropLeftRight, cropLeftRight);
    }

    public Cropping2D(int cropTop, int cropBottom, int cropLeft, int cropRight) {
        this(CNN2DFormat.NCHW, cropTop, cropBottom, cropLeft, cropRight);
    }

    public Cropping2D(CNN2DFormat format, int cropTop, int cropBottom, int cropLeft, int cropRight) {
        this(new Builder(cropTop, cropBottom, cropLeft, cropRight).dataFormat(format));
    }

    public Cropping2D(int[] cropping) {
        this(new Builder(cropping));
    }

    protected Cropping2D(Builder builder) {
        super(builder);
        this.cropping = builder.cropping;
        this.dataFormat = builder.cnn2DFormat;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        Cropping2DLayer ret = new Cropping2DLayer(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        int[] hwd = ConvolutionUtils.getHWDFromInputType(inputType);
        int outH = hwd[0] - this.cropping[0] - this.cropping[1];
        int outW = hwd[1] - this.cropping[2] - this.cropping[3];
        InputType.InputTypeConvolutional c = (InputType.InputTypeConvolutional)inputType;
        return InputType.convolutional(outH, outW, hwd[2], c.getFormat());
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        Preconditions.checkArgument((inputType != null ? 1 : 0) != 0, (String)("Invalid input for Cropping2D layer (layer name=\"" + this.getLayerName() + "\"): InputType is null"));
        return InputTypeUtil.getPreProcessorForInputTypeCnnLayers(inputType, this.getLayerName());
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        return null;
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
        this.dataFormat = ((InputType.InputTypeConvolutional)inputType).getFormat();
    }

    public int[] getCropping() {
        return this.cropping;
    }

    public CNN2DFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setCropping(int[] cropping) {
        this.cropping = cropping;
    }

    public void setDataFormat(CNN2DFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    @Override
    public String toString() {
        return "Cropping2D(cropping=" + Arrays.toString(this.getCropping()) + ", dataFormat=" + this.getDataFormat() + ")";
    }

    public Cropping2D() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cropping2D)) {
            return false;
        }
        Cropping2D other = (Cropping2D)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.equals(this.getCropping(), other.getCropping())) {
            return false;
        }
        CNN2DFormat this$dataFormat = this.getDataFormat();
        CNN2DFormat other$dataFormat = other.getDataFormat();
        return !(this$dataFormat == null ? other$dataFormat != null : !this$dataFormat.equals(other$dataFormat));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Cropping2D;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getCropping());
        CNN2DFormat $dataFormat = this.getDataFormat();
        result = result * 59 + ($dataFormat == null ? 43 : $dataFormat.hashCode());
        return result;
    }

    public static class Builder
    extends Layer.Builder<Builder> {
        private int[] cropping = new int[]{0, 0, 0, 0};
        private CNN2DFormat cnn2DFormat = CNN2DFormat.NCHW;

        public Builder dataFormat(CNN2DFormat format) {
            this.cnn2DFormat = format;
            return this;
        }

        public void setCropping(int ... cropping) {
            this.cropping = ValidationUtils.validate4NonNegative(cropping, "cropping");
        }

        public Builder() {
        }

        public Builder(@NonNull int[] cropping) {
            if (cropping == null) {
                throw new NullPointerException("cropping is marked non-null but is null");
            }
            this.setCropping(cropping);
        }

        public Builder(int cropTopBottom, int cropLeftRight) {
            this(cropTopBottom, cropTopBottom, cropLeftRight, cropLeftRight);
        }

        public Builder(int cropTop, int cropBottom, int cropLeft, int cropRight) {
            this.setCropping(cropTop, cropBottom, cropLeft, cropRight);
        }

        @Override
        public Cropping2D build() {
            return new Cropping2D(this);
        }

        public int[] getCropping() {
            return this.cropping;
        }

        public CNN2DFormat getCnn2DFormat() {
            return this.cnn2DFormat;
        }

        public void setCnn2DFormat(CNN2DFormat cnn2DFormat) {
            this.cnn2DFormat = cnn2DFormat;
        }
    }
}

