/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.NoParamLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.deeplearning4j.util.ConvolutionUtils;
import org.deeplearning4j.util.ValidationUtils;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ZeroPaddingLayer
extends NoParamLayer {
    private int[] padding;
    private CNN2DFormat dataFormat = CNN2DFormat.NCHW;

    public ZeroPaddingLayer(int padTopBottom, int padLeftRight) {
        this(new Builder(padTopBottom, padLeftRight));
    }

    public ZeroPaddingLayer(int padTop, int padBottom, int padLeft, int padRight) {
        this(new Builder(padTop, padBottom, padLeft, padRight));
    }

    private ZeroPaddingLayer(Builder builder) {
        super(builder);
        if (builder.padding == null || builder.padding.length != 4) {
            throw new IllegalArgumentException("Invalid padding values: must have exactly 4 values [top, bottom, left, right]. Got: " + (builder.padding == null ? null : Arrays.toString(builder.padding)));
        }
        this.padding = builder.padding;
        this.dataFormat = builder.cnn2DFormat;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        org.deeplearning4j.nn.layers.convolution.ZeroPaddingLayer ret = new org.deeplearning4j.nn.layers.convolution.ZeroPaddingLayer(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        int[] hwd = ConvolutionUtils.getHWDFromInputType(inputType);
        int outH = hwd[0] + this.padding[0] + this.padding[1];
        int outW = hwd[1] + this.padding[2] + this.padding[3];
        InputType.InputTypeConvolutional c = (InputType.InputTypeConvolutional)inputType;
        return InputType.convolutional(outH, outW, hwd[2], c.getFormat());
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        Preconditions.checkArgument((inputType != null ? 1 : 0) != 0, (String)("Invalid input for ZeroPaddingLayer layer (layer name=\"" + this.getLayerName() + "\"): InputType is null"));
        return InputTypeUtil.getPreProcessorForInputTypeCnnLayers(inputType, this.getLayerName());
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        InputType outputType = this.getOutputType(-1, inputType);
        return new LayerMemoryReport.Builder(this.layerName, ZeroPaddingLayer.class, inputType, outputType).standardMemory(0L, 0L).workingMemory(0L, 0L, MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
        InputType.InputTypeConvolutional c = (InputType.InputTypeConvolutional)inputType;
        this.dataFormat = c.getFormat();
    }

    public int[] getPadding() {
        return this.padding;
    }

    public CNN2DFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setPadding(int[] padding) {
        this.padding = padding;
    }

    public void setDataFormat(CNN2DFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    @Override
    public String toString() {
        return "ZeroPaddingLayer(padding=" + Arrays.toString(this.getPadding()) + ", dataFormat=" + this.getDataFormat() + ")";
    }

    public ZeroPaddingLayer() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZeroPaddingLayer)) {
            return false;
        }
        ZeroPaddingLayer other = (ZeroPaddingLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.equals(this.getPadding(), other.getPadding())) {
            return false;
        }
        CNN2DFormat this$dataFormat = this.getDataFormat();
        CNN2DFormat other$dataFormat = other.getDataFormat();
        return !(this$dataFormat == null ? other$dataFormat != null : !this$dataFormat.equals(other$dataFormat));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ZeroPaddingLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getPadding());
        CNN2DFormat $dataFormat = this.getDataFormat();
        result = result * 59 + ($dataFormat == null ? 43 : $dataFormat.hashCode());
        return result;
    }

    public static class Builder
    extends Layer.Builder<Builder> {
        private int[] padding = new int[]{0, 0, 0, 0};
        private CNN2DFormat cnn2DFormat = CNN2DFormat.NCHW;

        public Builder dataFormat(CNN2DFormat format) {
            this.cnn2DFormat = format;
            return this;
        }

        public void setPadding(int ... padding) {
            this.padding = ValidationUtils.validate4NonNegative(padding, "padding");
        }

        public Builder(int padHeight, int padWidth) {
            this(padHeight, padHeight, padWidth, padWidth);
        }

        public Builder(int padTop, int padBottom, int padLeft, int padRight) {
            this(new int[]{padTop, padBottom, padLeft, padRight});
        }

        public Builder(int[] padding) {
            this.setPadding(padding);
        }

        @Override
        public ZeroPaddingLayer build() {
            for (int p : this.padding) {
                if (p >= 0) continue;
                throw new IllegalStateException("Invalid zero padding layer config: padding [top, bottom, left, right] must be > 0 for all elements. Got: " + Arrays.toString(this.padding));
            }
            return new ZeroPaddingLayer(this);
        }

        public int[] getPadding() {
            return this.padding;
        }

        public CNN2DFormat getCnn2DFormat() {
            return this.cnn2DFormat;
        }

        public void setCnn2DFormat(CNN2DFormat cnn2DFormat) {
            this.cnn2DFormat = cnn2DFormat;
        }
    }
}

