/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.NoParamLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.layers.convolution.SpaceToBatch;
import org.deeplearning4j.nn.params.EmptyParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.deeplearning4j.util.ValidationUtils;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class SpaceToBatchLayer
extends NoParamLayer {
    protected int[] blocks;
    protected int[][] padding;
    protected CNN2DFormat format = CNN2DFormat.NCHW;

    protected SpaceToBatchLayer(Builder builder) {
        super(builder);
        this.blocks = builder.blocks;
        this.padding = builder.padding;
        this.format = builder.format;
    }

    @Override
    public SpaceToBatchLayer clone() {
        return (SpaceToBatchLayer)super.clone();
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        SpaceToBatch ret = new SpaceToBatch(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        InputType.InputTypeConvolutional c = (InputType.InputTypeConvolutional)inputType;
        InputType.InputTypeConvolutional outputType = (InputType.InputTypeConvolutional)this.getOutputType(-1, inputType);
        return new LayerMemoryReport.Builder(this.layerName, SpaceToBatchLayer.class, inputType, outputType).standardMemory(0L, 0L).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN) {
            throw new IllegalStateException("Invalid input for Subsampling layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN input, got " + inputType);
        }
        InputType.InputTypeConvolutional i = (InputType.InputTypeConvolutional)inputType;
        return InputType.convolutional((i.getHeight() + (long)this.padding[0][0] + (long)this.padding[0][1]) / (long)this.blocks[0], (i.getWidth() + (long)this.padding[1][0] + (long)this.padding[1][1]) / (long)this.blocks[1], i.getChannels(), i.getFormat());
    }

    @Override
    public ParamInitializer initializer() {
        return EmptyParamInitializer.getInstance();
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
        Preconditions.checkState((inputType.getType() == InputType.Type.CNN ? 1 : 0) != 0, (String)"Only CNN input types can be used with SpaceToBatchLayer, got %s", (Object)inputType);
        this.format = ((InputType.InputTypeConvolutional)inputType).getFormat();
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for space to batch layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreProcessorForInputTypeCnnLayers(inputType, this.getLayerName());
    }

    @Override
    public boolean isPretrainParam(String paramName) {
        throw new UnsupportedOperationException("SpaceToBatchLayer does not contain parameters");
    }

    public int[] getBlocks() {
        return this.blocks;
    }

    public int[][] getPadding() {
        return this.padding;
    }

    public CNN2DFormat getFormat() {
        return this.format;
    }

    public void setBlocks(int[] blocks) {
        this.blocks = blocks;
    }

    public void setPadding(int[][] padding) {
        this.padding = padding;
    }

    public void setFormat(CNN2DFormat format) {
        this.format = format;
    }

    public SpaceToBatchLayer() {
    }

    @Override
    public String toString() {
        return "SpaceToBatchLayer(super=" + super.toString() + ", blocks=" + Arrays.toString(this.getBlocks()) + ", padding=" + Arrays.deepToString((Object[])this.getPadding()) + ", format=" + this.getFormat() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpaceToBatchLayer)) {
            return false;
        }
        SpaceToBatchLayer other = (SpaceToBatchLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.equals(this.getBlocks(), other.getBlocks())) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.getPadding(), (Object[])other.getPadding())) {
            return false;
        }
        CNN2DFormat this$format = this.getFormat();
        CNN2DFormat other$format = other.getFormat();
        return !(this$format == null ? other$format != null : !this$format.equals(other$format));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SpaceToBatchLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getBlocks());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getPadding());
        CNN2DFormat $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        return result;
    }

    public static class Builder<T extends Builder<T>>
    extends Layer.Builder<T> {
        protected int[] blocks;
        protected int[][] padding;
        protected CNN2DFormat format = CNN2DFormat.NCHW;

        public void setBlocks(int ... blocks) {
            this.blocks = ValidationUtils.validate2NonNegative(blocks, false, "blocks");
        }

        public void setPadding(int[][] padding) {
            this.padding = ValidationUtils.validate2x2NonNegative(padding, "padding");
        }

        public Builder(int[] blocks) {
            this.setBlocks(blocks);
            this.setPadding(new int[][]{{0, 0}, {0, 0}});
        }

        public Builder(int[] blocks, int[][] padding) {
            this.setBlocks(blocks);
            this.setPadding(padding);
        }

        public T dataFormat(CNN2DFormat format) {
            this.format = format;
            return (T)this;
        }

        public T blocks(int ... blocks) {
            this.setBlocks(blocks);
            return (T)this;
        }

        public T padding(int[][] padding) {
            this.setPadding(padding);
            return (T)this;
        }

        @Override
        public T name(String layerName) {
            this.setLayerName(layerName);
            return (T)this;
        }

        @Override
        public SpaceToBatchLayer build() {
            if (this.padding == null) {
                this.setPadding(new int[][]{{0, 0}, {0, 0}});
            }
            return new SpaceToBatchLayer(this);
        }

        public Builder() {
        }

        public int[] getBlocks() {
            return this.blocks;
        }

        public int[][] getPadding() {
            return this.padding;
        }

        public CNN2DFormat getFormat() {
            return this.format;
        }

        public void setFormat(CNN2DFormat format) {
            this.format = format;
        }
    }
}

