/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.dropout.Dropout;
import org.deeplearning4j.nn.conf.dropout.IDropout;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.conf.layers.BaseLayer;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.LayerValidation;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.conf.layers.misc.FrozenLayer;
import org.deeplearning4j.nn.conf.layers.misc.FrozenLayerWithBackprop;
import org.deeplearning4j.nn.conf.layers.recurrent.Bidirectional;
import org.deeplearning4j.nn.conf.layers.samediff.AbstractSameDiffLayer;
import org.deeplearning4j.nn.conf.layers.wrapper.BaseWrapperLayer;
import org.deeplearning4j.nn.conf.serde.JsonMappers;
import org.deeplearning4j.nn.conf.stepfunctions.StepFunction;
import org.deeplearning4j.nn.conf.weightnoise.IWeightNoise;
import org.deeplearning4j.nn.weights.IWeightInit;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.nn.weights.WeightInitDistribution;
import org.deeplearning4j.nn.weights.WeightInitXavier;
import org.deeplearning4j.util.NetworkUtils;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.activations.impl.ActivationSigmoid;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.config.Sgd;
import org.nd4j.linalg.learning.regularization.L1Regularization;
import org.nd4j.linalg.learning.regularization.L2Regularization;
import org.nd4j.linalg.learning.regularization.Regularization;
import org.nd4j.linalg.learning.regularization.WeightDecay;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeuralNetConfiguration
implements Serializable,
Cloneable {
    private static final Logger log = LoggerFactory.getLogger(NeuralNetConfiguration.class);
    protected Layer layer;
    protected boolean miniBatch = true;
    protected int maxNumLineSearchIterations;
    protected long seed;
    protected OptimizationAlgorithm optimizationAlgo;
    protected List<String> variables = new ArrayList<String>();
    protected StepFunction stepFunction;
    protected boolean minimize = true;
    protected CacheMode cacheMode;
    protected DataType dataType = DataType.FLOAT;
    protected int iterationCount = 0;
    protected int epochCount = 0;

    public NeuralNetConfiguration clone() {
        try {
            NeuralNetConfiguration clone = (NeuralNetConfiguration)super.clone();
            if (clone.layer != null) {
                clone.layer = clone.layer.clone();
            }
            if (clone.stepFunction != null) {
                clone.stepFunction = clone.stepFunction.clone();
            }
            if (clone.variables != null) {
                clone.variables = new ArrayList<String>(clone.variables);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> variables() {
        return new ArrayList<String>(this.variables);
    }

    public List<String> variables(boolean copy) {
        if (copy) {
            return this.variables();
        }
        return this.variables;
    }

    public void addVariable(String variable) {
        if (!this.variables.contains(variable)) {
            this.variables.add(variable);
        }
    }

    public void clearVariables() {
        this.variables.clear();
    }

    public String toYaml() {
        ObjectMapper mapper = NeuralNetConfiguration.mapperYaml();
        try {
            String ret = mapper.writeValueAsString((Object)this);
            return ret;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static NeuralNetConfiguration fromYaml(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapperYaml();
        try {
            NeuralNetConfiguration ret = (NeuralNetConfiguration)mapper.readValue(json, NeuralNetConfiguration.class);
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJson() {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static NeuralNetConfiguration fromJson(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            NeuralNetConfiguration ret = (NeuralNetConfiguration)mapper.readValue(json, NeuralNetConfiguration.class);
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectMapper mapperYaml() {
        return JsonMappers.getMapperYaml();
    }

    public static ObjectMapper mapper() {
        return JsonMappers.getMapper();
    }

    public Layer getLayer() {
        return this.layer;
    }

    public boolean isMiniBatch() {
        return this.miniBatch;
    }

    public int getMaxNumLineSearchIterations() {
        return this.maxNumLineSearchIterations;
    }

    public long getSeed() {
        return this.seed;
    }

    public OptimizationAlgorithm getOptimizationAlgo() {
        return this.optimizationAlgo;
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public StepFunction getStepFunction() {
        return this.stepFunction;
    }

    public boolean isMinimize() {
        return this.minimize;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public int getEpochCount() {
        return this.epochCount;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public void setMiniBatch(boolean miniBatch) {
        this.miniBatch = miniBatch;
    }

    public void setMaxNumLineSearchIterations(int maxNumLineSearchIterations) {
        this.maxNumLineSearchIterations = maxNumLineSearchIterations;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setOptimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
        this.optimizationAlgo = optimizationAlgo;
    }

    public void setVariables(List<String> variables) {
        this.variables = variables;
    }

    public void setStepFunction(StepFunction stepFunction) {
        this.stepFunction = stepFunction;
    }

    public void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public void setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    public void setEpochCount(int epochCount) {
        this.epochCount = epochCount;
    }

    public String toString() {
        return "NeuralNetConfiguration(layer=" + this.getLayer() + ", miniBatch=" + this.isMiniBatch() + ", maxNumLineSearchIterations=" + this.getMaxNumLineSearchIterations() + ", seed=" + this.getSeed() + ", optimizationAlgo=" + (Object)((Object)this.getOptimizationAlgo()) + ", variables=" + this.getVariables() + ", stepFunction=" + this.getStepFunction() + ", minimize=" + this.isMinimize() + ", cacheMode=" + (Object)((Object)this.getCacheMode()) + ", dataType=" + this.getDataType() + ", iterationCount=" + this.getIterationCount() + ", epochCount=" + this.getEpochCount() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NeuralNetConfiguration)) {
            return false;
        }
        NeuralNetConfiguration other = (NeuralNetConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isMiniBatch() != other.isMiniBatch()) {
            return false;
        }
        if (this.getMaxNumLineSearchIterations() != other.getMaxNumLineSearchIterations()) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        if (this.isMinimize() != other.isMinimize()) {
            return false;
        }
        Layer this$layer = this.getLayer();
        Layer other$layer = other.getLayer();
        if (this$layer == null ? other$layer != null : !((Object)this$layer).equals(other$layer)) {
            return false;
        }
        OptimizationAlgorithm this$optimizationAlgo = this.getOptimizationAlgo();
        OptimizationAlgorithm other$optimizationAlgo = other.getOptimizationAlgo();
        if (this$optimizationAlgo == null ? other$optimizationAlgo != null : !((Object)((Object)this$optimizationAlgo)).equals((Object)other$optimizationAlgo)) {
            return false;
        }
        List<String> this$variables = this.getVariables();
        List<String> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        StepFunction this$stepFunction = this.getStepFunction();
        StepFunction other$stepFunction = other.getStepFunction();
        if (this$stepFunction == null ? other$stepFunction != null : !this$stepFunction.equals(other$stepFunction)) {
            return false;
        }
        CacheMode this$cacheMode = this.getCacheMode();
        CacheMode other$cacheMode = other.getCacheMode();
        if (this$cacheMode == null ? other$cacheMode != null : !((Object)((Object)this$cacheMode)).equals((Object)other$cacheMode)) {
            return false;
        }
        DataType this$dataType = this.getDataType();
        DataType other$dataType = other.getDataType();
        return !(this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NeuralNetConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMiniBatch() ? 79 : 97);
        result = result * 59 + this.getMaxNumLineSearchIterations();
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        result = result * 59 + (this.isMinimize() ? 79 : 97);
        Layer $layer = this.getLayer();
        result = result * 59 + ($layer == null ? 43 : ((Object)$layer).hashCode());
        OptimizationAlgorithm $optimizationAlgo = this.getOptimizationAlgo();
        result = result * 59 + ($optimizationAlgo == null ? 43 : ((Object)((Object)$optimizationAlgo)).hashCode());
        List<String> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        StepFunction $stepFunction = this.getStepFunction();
        result = result * 59 + ($stepFunction == null ? 43 : $stepFunction.hashCode());
        CacheMode $cacheMode = this.getCacheMode();
        result = result * 59 + ($cacheMode == null ? 43 : ((Object)((Object)$cacheMode)).hashCode());
        DataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        return result;
    }

    public static class Builder
    implements Cloneable {
        protected IActivation activationFn = new ActivationSigmoid();
        protected IWeightInit weightInitFn = new WeightInitXavier();
        protected double biasInit = 0.0;
        protected double gainInit = 1.0;
        protected List<Regularization> regularization = new ArrayList<Regularization>();
        protected List<Regularization> regularizationBias = new ArrayList<Regularization>();
        protected IDropout idropOut;
        protected IWeightNoise weightNoise;
        protected IUpdater iUpdater = new Sgd();
        protected IUpdater biasUpdater = null;
        protected Layer layer;
        protected boolean miniBatch = true;
        protected int maxNumLineSearchIterations = 5;
        protected long seed = System.currentTimeMillis();
        protected OptimizationAlgorithm optimizationAlgo = OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT;
        protected StepFunction stepFunction = null;
        protected boolean minimize = true;
        protected GradientNormalization gradientNormalization = GradientNormalization.None;
        protected double gradientNormalizationThreshold = 1.0;
        protected List<LayerConstraint> allParamConstraints;
        protected List<LayerConstraint> weightConstraints;
        protected List<LayerConstraint> biasConstraints;
        protected WorkspaceMode trainingWorkspaceMode = WorkspaceMode.ENABLED;
        protected WorkspaceMode inferenceWorkspaceMode = WorkspaceMode.ENABLED;
        protected boolean setTWM = false;
        protected boolean setIWM = false;
        protected CacheMode cacheMode = CacheMode.NONE;
        protected DataType dataType = DataType.FLOAT;
        protected ConvolutionMode convolutionMode = ConvolutionMode.Truncate;
        protected ConvolutionLayer.AlgoMode cudnnAlgoMode = ConvolutionLayer.AlgoMode.PREFER_FASTEST;

        public Builder() {
        }

        public Builder(NeuralNetConfiguration newConf) {
            if (newConf != null) {
                this.minimize = newConf.minimize;
                this.maxNumLineSearchIterations = newConf.maxNumLineSearchIterations;
                this.layer = newConf.layer;
                this.optimizationAlgo = newConf.optimizationAlgo;
                this.seed = newConf.seed;
                this.stepFunction = newConf.stepFunction;
                this.miniBatch = newConf.miniBatch;
            }
        }

        public Builder miniBatch(boolean miniBatch) {
            this.miniBatch = miniBatch;
            return this;
        }

        public Builder trainingWorkspaceMode(@NonNull WorkspaceMode workspaceMode) {
            if (workspaceMode == null) {
                throw new NullPointerException("workspaceMode is marked non-null but is null");
            }
            this.trainingWorkspaceMode = workspaceMode;
            this.setTWM = true;
            return this;
        }

        public Builder inferenceWorkspaceMode(@NonNull WorkspaceMode workspaceMode) {
            if (workspaceMode == null) {
                throw new NullPointerException("workspaceMode is marked non-null but is null");
            }
            this.inferenceWorkspaceMode = workspaceMode;
            this.setIWM = true;
            return this;
        }

        public Builder cacheMode(@NonNull CacheMode cacheMode) {
            if (cacheMode == null) {
                throw new NullPointerException("cacheMode is marked non-null but is null");
            }
            this.cacheMode = cacheMode;
            return this;
        }

        public Builder minimize(boolean minimize) {
            this.minimize = minimize;
            return this;
        }

        public Builder maxNumLineSearchIterations(int maxNumLineSearchIterations) {
            this.maxNumLineSearchIterations = maxNumLineSearchIterations;
            return this;
        }

        public Builder layer(Layer layer) {
            this.layer = layer;
            return this;
        }

        @Deprecated
        public Builder stepFunction(StepFunction stepFunction) {
            this.stepFunction = stepFunction;
            return this;
        }

        public ListBuilder list() {
            return new ListBuilder(this);
        }

        public ListBuilder list(Layer ... layers) {
            if (layers == null || layers.length == 0) {
                throw new IllegalArgumentException("Cannot create network with no layers");
            }
            HashMap<Integer, Builder> layerMap = new HashMap<Integer, Builder>();
            for (int i = 0; i < layers.length; ++i) {
                Builder b = this.clone();
                b.layer(layers[i]);
                layerMap.put(i, b);
            }
            return new ListBuilder(this, layerMap);
        }

        public ComputationGraphConfiguration.GraphBuilder graphBuilder() {
            return new ComputationGraphConfiguration.GraphBuilder(this);
        }

        public Builder seed(long seed) {
            this.seed = seed;
            Nd4j.getRandom().setSeed(seed);
            return this;
        }

        public Builder optimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
            this.optimizationAlgo = optimizationAlgo;
            return this;
        }

        public Builder clone() {
            try {
                Builder clone = (Builder)super.clone();
                if (clone.layer != null) {
                    clone.layer = clone.layer.clone();
                }
                if (clone.stepFunction != null) {
                    clone.stepFunction = clone.stepFunction.clone();
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public Builder activation(IActivation activationFunction) {
            this.activationFn = activationFunction;
            return this;
        }

        public Builder activation(Activation activation) {
            return this.activation(activation.getActivationFunction());
        }

        public Builder weightInit(IWeightInit weightInit) {
            this.weightInitFn = weightInit;
            return this;
        }

        public Builder weightInit(WeightInit weightInit) {
            if (weightInit == WeightInit.DISTRIBUTION) {
                // empty if block
            }
            this.weightInitFn = weightInit.getWeightInitFunction();
            return this;
        }

        public Builder weightInit(Distribution distribution) {
            return this.weightInit(new WeightInitDistribution(distribution));
        }

        public Builder biasInit(double biasInit) {
            this.biasInit = biasInit;
            return this;
        }

        @Deprecated
        public Builder dist(Distribution dist) {
            return this.weightInit(dist);
        }

        public Builder l1(double l1) {
            NetworkUtils.removeInstances(this.regularization, L1Regularization.class);
            if (l1 > 0.0) {
                this.regularization.add((Regularization)new L1Regularization(l1));
            }
            return this;
        }

        public Builder l2(double l2) {
            NetworkUtils.removeInstances(this.regularization, L2Regularization.class);
            if (l2 > 0.0) {
                NetworkUtils.removeInstancesWithWarning(this.regularization, WeightDecay.class, "WeightDecay regularization removed: incompatible with added L2 regularization");
                this.regularization.add((Regularization)new L2Regularization(l2));
            }
            return this;
        }

        public Builder l1Bias(double l1Bias) {
            NetworkUtils.removeInstances(this.regularizationBias, L1Regularization.class);
            if (l1Bias > 0.0) {
                this.regularizationBias.add((Regularization)new L1Regularization(l1Bias));
            }
            return this;
        }

        public Builder l2Bias(double l2Bias) {
            NetworkUtils.removeInstances(this.regularizationBias, L2Regularization.class);
            if (l2Bias > 0.0) {
                NetworkUtils.removeInstancesWithWarning(this.regularizationBias, WeightDecay.class, "L2 bias regularization removed: incompatible with added WeightDecay regularization");
                this.regularizationBias.add((Regularization)new L2Regularization(l2Bias));
            }
            return this;
        }

        public Builder weightDecay(double coefficient) {
            return this.weightDecay(coefficient, true);
        }

        public Builder weightDecay(double coefficient, boolean applyLR) {
            NetworkUtils.removeInstances(this.regularization, WeightDecay.class);
            if (coefficient > 0.0) {
                NetworkUtils.removeInstancesWithWarning(this.regularization, L2Regularization.class, "L2 regularization removed: incompatible with added WeightDecay regularization");
                this.regularization.add((Regularization)new WeightDecay(coefficient, applyLR));
            }
            return this;
        }

        public Builder weightDecayBias(double coefficient) {
            return this.weightDecayBias(coefficient, true);
        }

        public Builder weightDecayBias(double coefficient, boolean applyLR) {
            NetworkUtils.removeInstances(this.regularizationBias, WeightDecay.class);
            if (coefficient > 0.0) {
                NetworkUtils.removeInstancesWithWarning(this.regularizationBias, L2Regularization.class, "L2 bias regularization removed: incompatible with added WeightDecay regularization");
                this.regularizationBias.add((Regularization)new WeightDecay(coefficient, applyLR));
            }
            return this;
        }

        public Builder regularization(List<Regularization> regularization) {
            this.regularization = regularization;
            return this;
        }

        public Builder regularizationBias(List<Regularization> regularizationBias) {
            this.regularizationBias = regularizationBias;
            return this;
        }

        public Builder dropOut(double inputRetainProbability) {
            if (inputRetainProbability == 0.0) {
                return this.dropOut(null);
            }
            return this.dropOut(new Dropout(inputRetainProbability));
        }

        public Builder dropOut(IDropout dropout) {
            this.idropOut = dropout == null ? null : dropout.clone();
            return this;
        }

        public Builder weightNoise(IWeightNoise weightNoise) {
            this.weightNoise = weightNoise;
            return this;
        }

        @Deprecated
        public Builder updater(Updater updater) {
            return this.updater(updater.getIUpdaterWithDefaultConfig());
        }

        public Builder updater(IUpdater updater) {
            this.iUpdater = updater;
            return this;
        }

        public Builder biasUpdater(IUpdater updater) {
            this.biasUpdater = updater;
            return this;
        }

        public Builder gradientNormalization(GradientNormalization gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
            return this;
        }

        public Builder gradientNormalizationThreshold(double threshold) {
            this.gradientNormalizationThreshold = threshold;
            return this;
        }

        public Builder convolutionMode(ConvolutionMode convolutionMode) {
            this.convolutionMode = convolutionMode;
            return this;
        }

        public Builder cudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode = cudnnAlgoMode;
            return this;
        }

        public Builder constrainAllParameters(LayerConstraint ... constraints) {
            this.allParamConstraints = Arrays.asList(constraints);
            return this;
        }

        public Builder constrainBias(LayerConstraint ... constraints) {
            this.biasConstraints = Arrays.asList(constraints);
            return this;
        }

        public Builder constrainWeights(LayerConstraint ... constraints) {
            this.weightConstraints = Arrays.asList(constraints);
            return this;
        }

        public Builder dataType(@NonNull DataType dataType) {
            if (dataType == null) {
                throw new NullPointerException("dataType is marked non-null but is null");
            }
            Preconditions.checkState((dataType == DataType.DOUBLE || dataType == DataType.FLOAT || dataType == DataType.HALF ? 1 : 0) != 0, (String)"Data type must be a floating point type: one of DOUBLE, FLOAT, or HALF. Got datatype: %s", (Object)dataType);
            this.dataType = dataType;
            return this;
        }

        public NeuralNetConfiguration build() {
            NeuralNetConfiguration conf = new NeuralNetConfiguration();
            conf.minimize = this.minimize;
            conf.maxNumLineSearchIterations = this.maxNumLineSearchIterations;
            conf.layer = this.layer;
            conf.optimizationAlgo = this.optimizationAlgo;
            conf.seed = this.seed;
            conf.stepFunction = this.stepFunction;
            conf.miniBatch = this.miniBatch;
            conf.cacheMode = this.cacheMode;
            conf.dataType = this.dataType;
            this.configureLayer(this.layer);
            if (this.layer instanceof FrozenLayer) {
                this.configureLayer(((FrozenLayer)this.layer).getLayer());
            }
            if (this.layer instanceof FrozenLayerWithBackprop) {
                this.configureLayer(((FrozenLayerWithBackprop)this.layer).getUnderlying());
            }
            return conf;
        }

        private void configureLayer(Layer layer) {
            SubsamplingLayer sl;
            String layerName = layer == null || layer.getLayerName() == null ? "Layer not named" : layer.getLayerName();
            if (layer instanceof AbstractSameDiffLayer) {
                AbstractSameDiffLayer sdl = (AbstractSameDiffLayer)layer;
                sdl.applyGlobalConfig(this);
            }
            if (layer != null) {
                this.copyConfigToLayer(layerName, layer);
            }
            if (layer instanceof FrozenLayer) {
                this.copyConfigToLayer(layerName, ((FrozenLayer)layer).getLayer());
            }
            if (layer instanceof FrozenLayerWithBackprop) {
                this.copyConfigToLayer(layerName, ((FrozenLayerWithBackprop)layer).getUnderlying());
            }
            if (layer instanceof Bidirectional) {
                Bidirectional b = (Bidirectional)layer;
                this.copyConfigToLayer(b.getFwd().getLayerName(), b.getFwd());
                this.copyConfigToLayer(b.getBwd().getLayerName(), b.getBwd());
            }
            if (layer instanceof BaseWrapperLayer) {
                BaseWrapperLayer bwr = (BaseWrapperLayer)layer;
                this.configureLayer(bwr.getUnderlying());
            }
            if (layer instanceof ConvolutionLayer) {
                ConvolutionLayer cl = (ConvolutionLayer)layer;
                if (cl.getConvolutionMode() == null) {
                    cl.setConvolutionMode(this.convolutionMode);
                }
                if (cl.getCudnnAlgoMode() == null) {
                    cl.setCudnnAlgoMode(this.cudnnAlgoMode);
                }
            }
            if (layer instanceof SubsamplingLayer && (sl = (SubsamplingLayer)layer).getConvolutionMode() == null) {
                sl.setConvolutionMode(this.convolutionMode);
            }
            LayerValidation.generalValidation(layerName, layer, this.idropOut, this.regularization, this.regularizationBias, this.allParamConstraints, this.weightConstraints, this.biasConstraints);
        }

        private void copyConfigToLayer(String layerName, Layer layer) {
            ActivationLayer al;
            if (layer.getIDropout() == null) {
                layer.setIDropout(this.idropOut == null ? null : this.idropOut.clone());
            }
            if (layer instanceof BaseLayer) {
                BaseLayer bLayer = (BaseLayer)layer;
                if (bLayer.getRegularization() == null || bLayer.getRegularization().isEmpty()) {
                    bLayer.setRegularization(new ArrayList<Regularization>(this.regularization));
                }
                if (bLayer.getRegularizationBias() == null || bLayer.getRegularizationBias().isEmpty()) {
                    bLayer.setRegularizationBias(new ArrayList<Regularization>(this.regularizationBias));
                }
                if (bLayer.getActivationFn() == null) {
                    bLayer.setActivationFn(this.activationFn);
                }
                if (bLayer.getWeightInitFn() == null) {
                    bLayer.setWeightInitFn(this.weightInitFn);
                }
                if (Double.isNaN(bLayer.getBiasInit())) {
                    bLayer.setBiasInit(this.biasInit);
                }
                if (Double.isNaN(bLayer.getGainInit())) {
                    bLayer.setGainInit(this.gainInit);
                }
                if (this.weightNoise != null && ((BaseLayer)layer).getWeightNoise() == null) {
                    ((BaseLayer)layer).setWeightNoise(this.weightNoise.clone());
                }
                if (this.iUpdater != null && bLayer.getIUpdater() == null) {
                    bLayer.setIUpdater(this.iUpdater.clone());
                }
                if (this.biasUpdater != null && bLayer.getBiasUpdater() == null) {
                    bLayer.setBiasUpdater(this.biasUpdater.clone());
                }
                if (bLayer.getIUpdater() == null && this.iUpdater == null && bLayer.initializer().numParams(bLayer) > 0L) {
                    Sgd u = new Sgd();
                    bLayer.setIUpdater((IUpdater)u);
                    log.warn("*** No updater configuration is set for layer {} - defaulting to {} ***", (Object)layerName, (Object)u);
                }
                if (bLayer.getGradientNormalization() == null) {
                    bLayer.setGradientNormalization(this.gradientNormalization);
                }
                if (Double.isNaN(bLayer.getGradientNormalizationThreshold())) {
                    bLayer.setGradientNormalizationThreshold(this.gradientNormalizationThreshold);
                }
            }
            if (layer instanceof ActivationLayer && (al = (ActivationLayer)layer).getActivationFn() == null) {
                al.setActivationFn(this.activationFn);
            }
        }

        public IActivation getActivationFn() {
            return this.activationFn;
        }

        public IWeightInit getWeightInitFn() {
            return this.weightInitFn;
        }

        public double getBiasInit() {
            return this.biasInit;
        }

        public double getGainInit() {
            return this.gainInit;
        }

        public List<Regularization> getRegularization() {
            return this.regularization;
        }

        public List<Regularization> getRegularizationBias() {
            return this.regularizationBias;
        }

        public IDropout getIdropOut() {
            return this.idropOut;
        }

        public IWeightNoise getWeightNoise() {
            return this.weightNoise;
        }

        public IUpdater getIUpdater() {
            return this.iUpdater;
        }

        public IUpdater getBiasUpdater() {
            return this.biasUpdater;
        }

        public Layer getLayer() {
            return this.layer;
        }

        public boolean isMiniBatch() {
            return this.miniBatch;
        }

        public int getMaxNumLineSearchIterations() {
            return this.maxNumLineSearchIterations;
        }

        public long getSeed() {
            return this.seed;
        }

        public OptimizationAlgorithm getOptimizationAlgo() {
            return this.optimizationAlgo;
        }

        public StepFunction getStepFunction() {
            return this.stepFunction;
        }

        public boolean isMinimize() {
            return this.minimize;
        }

        public GradientNormalization getGradientNormalization() {
            return this.gradientNormalization;
        }

        public double getGradientNormalizationThreshold() {
            return this.gradientNormalizationThreshold;
        }

        public List<LayerConstraint> getAllParamConstraints() {
            return this.allParamConstraints;
        }

        public List<LayerConstraint> getWeightConstraints() {
            return this.weightConstraints;
        }

        public List<LayerConstraint> getBiasConstraints() {
            return this.biasConstraints;
        }

        public WorkspaceMode getTrainingWorkspaceMode() {
            return this.trainingWorkspaceMode;
        }

        public WorkspaceMode getInferenceWorkspaceMode() {
            return this.inferenceWorkspaceMode;
        }

        public boolean isSetTWM() {
            return this.setTWM;
        }

        public boolean isSetIWM() {
            return this.setIWM;
        }

        public CacheMode getCacheMode() {
            return this.cacheMode;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public ConvolutionMode getConvolutionMode() {
            return this.convolutionMode;
        }

        public ConvolutionLayer.AlgoMode getCudnnAlgoMode() {
            return this.cudnnAlgoMode;
        }

        public void setActivationFn(IActivation activationFn) {
            this.activationFn = activationFn;
        }

        public void setWeightInitFn(IWeightInit weightInitFn) {
            this.weightInitFn = weightInitFn;
        }

        public void setBiasInit(double biasInit) {
            this.biasInit = biasInit;
        }

        public void setGainInit(double gainInit) {
            this.gainInit = gainInit;
        }

        public void setRegularization(List<Regularization> regularization) {
            this.regularization = regularization;
        }

        public void setRegularizationBias(List<Regularization> regularizationBias) {
            this.regularizationBias = regularizationBias;
        }

        public void setIdropOut(IDropout idropOut) {
            this.idropOut = idropOut;
        }

        public void setWeightNoise(IWeightNoise weightNoise) {
            this.weightNoise = weightNoise;
        }

        public void setIUpdater(IUpdater iUpdater) {
            this.iUpdater = iUpdater;
        }

        public void setBiasUpdater(IUpdater biasUpdater) {
            this.biasUpdater = biasUpdater;
        }

        public void setLayer(Layer layer) {
            this.layer = layer;
        }

        public void setMiniBatch(boolean miniBatch) {
            this.miniBatch = miniBatch;
        }

        public void setMaxNumLineSearchIterations(int maxNumLineSearchIterations) {
            this.maxNumLineSearchIterations = maxNumLineSearchIterations;
        }

        public void setSeed(long seed) {
            this.seed = seed;
        }

        public void setOptimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
            this.optimizationAlgo = optimizationAlgo;
        }

        public void setStepFunction(StepFunction stepFunction) {
            this.stepFunction = stepFunction;
        }

        public void setMinimize(boolean minimize) {
            this.minimize = minimize;
        }

        public void setGradientNormalization(GradientNormalization gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
        }

        public void setGradientNormalizationThreshold(double gradientNormalizationThreshold) {
            this.gradientNormalizationThreshold = gradientNormalizationThreshold;
        }

        public void setAllParamConstraints(List<LayerConstraint> allParamConstraints) {
            this.allParamConstraints = allParamConstraints;
        }

        public void setWeightConstraints(List<LayerConstraint> weightConstraints) {
            this.weightConstraints = weightConstraints;
        }

        public void setBiasConstraints(List<LayerConstraint> biasConstraints) {
            this.biasConstraints = biasConstraints;
        }

        public void setTrainingWorkspaceMode(WorkspaceMode trainingWorkspaceMode) {
            this.trainingWorkspaceMode = trainingWorkspaceMode;
        }

        public void setInferenceWorkspaceMode(WorkspaceMode inferenceWorkspaceMode) {
            this.inferenceWorkspaceMode = inferenceWorkspaceMode;
        }

        public void setSetTWM(boolean setTWM) {
            this.setTWM = setTWM;
        }

        public void setSetIWM(boolean setIWM) {
            this.setIWM = setIWM;
        }

        public void setCacheMode(CacheMode cacheMode) {
            this.cacheMode = cacheMode;
        }

        public void setDataType(DataType dataType) {
            this.dataType = dataType;
        }

        public void setConvolutionMode(ConvolutionMode convolutionMode) {
            this.convolutionMode = convolutionMode;
        }

        public void setCudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode = cudnnAlgoMode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getBiasInit(), other.getBiasInit()) != 0) {
                return false;
            }
            if (Double.compare(this.getGainInit(), other.getGainInit()) != 0) {
                return false;
            }
            if (this.isMiniBatch() != other.isMiniBatch()) {
                return false;
            }
            if (this.getMaxNumLineSearchIterations() != other.getMaxNumLineSearchIterations()) {
                return false;
            }
            if (this.getSeed() != other.getSeed()) {
                return false;
            }
            if (this.isMinimize() != other.isMinimize()) {
                return false;
            }
            if (Double.compare(this.getGradientNormalizationThreshold(), other.getGradientNormalizationThreshold()) != 0) {
                return false;
            }
            if (this.isSetTWM() != other.isSetTWM()) {
                return false;
            }
            if (this.isSetIWM() != other.isSetIWM()) {
                return false;
            }
            IActivation this$activationFn = this.getActivationFn();
            IActivation other$activationFn = other.getActivationFn();
            if (this$activationFn == null ? other$activationFn != null : !this$activationFn.equals(other$activationFn)) {
                return false;
            }
            IWeightInit this$weightInitFn = this.getWeightInitFn();
            IWeightInit other$weightInitFn = other.getWeightInitFn();
            if (this$weightInitFn == null ? other$weightInitFn != null : !this$weightInitFn.equals(other$weightInitFn)) {
                return false;
            }
            List<Regularization> this$regularization = this.getRegularization();
            List<Regularization> other$regularization = other.getRegularization();
            if (this$regularization == null ? other$regularization != null : !((Object)this$regularization).equals(other$regularization)) {
                return false;
            }
            List<Regularization> this$regularizationBias = this.getRegularizationBias();
            List<Regularization> other$regularizationBias = other.getRegularizationBias();
            if (this$regularizationBias == null ? other$regularizationBias != null : !((Object)this$regularizationBias).equals(other$regularizationBias)) {
                return false;
            }
            IDropout this$idropOut = this.getIdropOut();
            IDropout other$idropOut = other.getIdropOut();
            if (this$idropOut == null ? other$idropOut != null : !this$idropOut.equals(other$idropOut)) {
                return false;
            }
            IWeightNoise this$weightNoise = this.getWeightNoise();
            IWeightNoise other$weightNoise = other.getWeightNoise();
            if (this$weightNoise == null ? other$weightNoise != null : !this$weightNoise.equals(other$weightNoise)) {
                return false;
            }
            IUpdater this$iUpdater = this.getIUpdater();
            IUpdater other$iUpdater = other.getIUpdater();
            if (this$iUpdater == null ? other$iUpdater != null : !this$iUpdater.equals(other$iUpdater)) {
                return false;
            }
            IUpdater this$biasUpdater = this.getBiasUpdater();
            IUpdater other$biasUpdater = other.getBiasUpdater();
            if (this$biasUpdater == null ? other$biasUpdater != null : !this$biasUpdater.equals(other$biasUpdater)) {
                return false;
            }
            Layer this$layer = this.getLayer();
            Layer other$layer = other.getLayer();
            if (this$layer == null ? other$layer != null : !((Object)this$layer).equals(other$layer)) {
                return false;
            }
            OptimizationAlgorithm this$optimizationAlgo = this.getOptimizationAlgo();
            OptimizationAlgorithm other$optimizationAlgo = other.getOptimizationAlgo();
            if (this$optimizationAlgo == null ? other$optimizationAlgo != null : !((Object)((Object)this$optimizationAlgo)).equals((Object)other$optimizationAlgo)) {
                return false;
            }
            StepFunction this$stepFunction = this.getStepFunction();
            StepFunction other$stepFunction = other.getStepFunction();
            if (this$stepFunction == null ? other$stepFunction != null : !this$stepFunction.equals(other$stepFunction)) {
                return false;
            }
            GradientNormalization this$gradientNormalization = this.getGradientNormalization();
            GradientNormalization other$gradientNormalization = other.getGradientNormalization();
            if (this$gradientNormalization == null ? other$gradientNormalization != null : !((Object)((Object)this$gradientNormalization)).equals((Object)other$gradientNormalization)) {
                return false;
            }
            List<LayerConstraint> this$allParamConstraints = this.getAllParamConstraints();
            List<LayerConstraint> other$allParamConstraints = other.getAllParamConstraints();
            if (this$allParamConstraints == null ? other$allParamConstraints != null : !((Object)this$allParamConstraints).equals(other$allParamConstraints)) {
                return false;
            }
            List<LayerConstraint> this$weightConstraints = this.getWeightConstraints();
            List<LayerConstraint> other$weightConstraints = other.getWeightConstraints();
            if (this$weightConstraints == null ? other$weightConstraints != null : !((Object)this$weightConstraints).equals(other$weightConstraints)) {
                return false;
            }
            List<LayerConstraint> this$biasConstraints = this.getBiasConstraints();
            List<LayerConstraint> other$biasConstraints = other.getBiasConstraints();
            if (this$biasConstraints == null ? other$biasConstraints != null : !((Object)this$biasConstraints).equals(other$biasConstraints)) {
                return false;
            }
            WorkspaceMode this$trainingWorkspaceMode = this.getTrainingWorkspaceMode();
            WorkspaceMode other$trainingWorkspaceMode = other.getTrainingWorkspaceMode();
            if (this$trainingWorkspaceMode == null ? other$trainingWorkspaceMode != null : !((Object)((Object)this$trainingWorkspaceMode)).equals((Object)other$trainingWorkspaceMode)) {
                return false;
            }
            WorkspaceMode this$inferenceWorkspaceMode = this.getInferenceWorkspaceMode();
            WorkspaceMode other$inferenceWorkspaceMode = other.getInferenceWorkspaceMode();
            if (this$inferenceWorkspaceMode == null ? other$inferenceWorkspaceMode != null : !((Object)((Object)this$inferenceWorkspaceMode)).equals((Object)other$inferenceWorkspaceMode)) {
                return false;
            }
            CacheMode this$cacheMode = this.getCacheMode();
            CacheMode other$cacheMode = other.getCacheMode();
            if (this$cacheMode == null ? other$cacheMode != null : !((Object)((Object)this$cacheMode)).equals((Object)other$cacheMode)) {
                return false;
            }
            DataType this$dataType = this.getDataType();
            DataType other$dataType = other.getDataType();
            if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
                return false;
            }
            ConvolutionMode this$convolutionMode = this.getConvolutionMode();
            ConvolutionMode other$convolutionMode = other.getConvolutionMode();
            if (this$convolutionMode == null ? other$convolutionMode != null : !((Object)((Object)this$convolutionMode)).equals((Object)other$convolutionMode)) {
                return false;
            }
            ConvolutionLayer.AlgoMode this$cudnnAlgoMode = this.getCudnnAlgoMode();
            ConvolutionLayer.AlgoMode other$cudnnAlgoMode = other.getCudnnAlgoMode();
            return !(this$cudnnAlgoMode == null ? other$cudnnAlgoMode != null : !((Object)((Object)this$cudnnAlgoMode)).equals((Object)other$cudnnAlgoMode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $biasInit = Double.doubleToLongBits(this.getBiasInit());
            result = result * 59 + (int)($biasInit >>> 32 ^ $biasInit);
            long $gainInit = Double.doubleToLongBits(this.getGainInit());
            result = result * 59 + (int)($gainInit >>> 32 ^ $gainInit);
            result = result * 59 + (this.isMiniBatch() ? 79 : 97);
            result = result * 59 + this.getMaxNumLineSearchIterations();
            long $seed = this.getSeed();
            result = result * 59 + (int)($seed >>> 32 ^ $seed);
            result = result * 59 + (this.isMinimize() ? 79 : 97);
            long $gradientNormalizationThreshold = Double.doubleToLongBits(this.getGradientNormalizationThreshold());
            result = result * 59 + (int)($gradientNormalizationThreshold >>> 32 ^ $gradientNormalizationThreshold);
            result = result * 59 + (this.isSetTWM() ? 79 : 97);
            result = result * 59 + (this.isSetIWM() ? 79 : 97);
            IActivation $activationFn = this.getActivationFn();
            result = result * 59 + ($activationFn == null ? 43 : $activationFn.hashCode());
            IWeightInit $weightInitFn = this.getWeightInitFn();
            result = result * 59 + ($weightInitFn == null ? 43 : $weightInitFn.hashCode());
            List<Regularization> $regularization = this.getRegularization();
            result = result * 59 + ($regularization == null ? 43 : ((Object)$regularization).hashCode());
            List<Regularization> $regularizationBias = this.getRegularizationBias();
            result = result * 59 + ($regularizationBias == null ? 43 : ((Object)$regularizationBias).hashCode());
            IDropout $idropOut = this.getIdropOut();
            result = result * 59 + ($idropOut == null ? 43 : $idropOut.hashCode());
            IWeightNoise $weightNoise = this.getWeightNoise();
            result = result * 59 + ($weightNoise == null ? 43 : $weightNoise.hashCode());
            IUpdater $iUpdater = this.getIUpdater();
            result = result * 59 + ($iUpdater == null ? 43 : $iUpdater.hashCode());
            IUpdater $biasUpdater = this.getBiasUpdater();
            result = result * 59 + ($biasUpdater == null ? 43 : $biasUpdater.hashCode());
            Layer $layer = this.getLayer();
            result = result * 59 + ($layer == null ? 43 : ((Object)$layer).hashCode());
            OptimizationAlgorithm $optimizationAlgo = this.getOptimizationAlgo();
            result = result * 59 + ($optimizationAlgo == null ? 43 : ((Object)((Object)$optimizationAlgo)).hashCode());
            StepFunction $stepFunction = this.getStepFunction();
            result = result * 59 + ($stepFunction == null ? 43 : $stepFunction.hashCode());
            GradientNormalization $gradientNormalization = this.getGradientNormalization();
            result = result * 59 + ($gradientNormalization == null ? 43 : ((Object)((Object)$gradientNormalization)).hashCode());
            List<LayerConstraint> $allParamConstraints = this.getAllParamConstraints();
            result = result * 59 + ($allParamConstraints == null ? 43 : ((Object)$allParamConstraints).hashCode());
            List<LayerConstraint> $weightConstraints = this.getWeightConstraints();
            result = result * 59 + ($weightConstraints == null ? 43 : ((Object)$weightConstraints).hashCode());
            List<LayerConstraint> $biasConstraints = this.getBiasConstraints();
            result = result * 59 + ($biasConstraints == null ? 43 : ((Object)$biasConstraints).hashCode());
            WorkspaceMode $trainingWorkspaceMode = this.getTrainingWorkspaceMode();
            result = result * 59 + ($trainingWorkspaceMode == null ? 43 : ((Object)((Object)$trainingWorkspaceMode)).hashCode());
            WorkspaceMode $inferenceWorkspaceMode = this.getInferenceWorkspaceMode();
            result = result * 59 + ($inferenceWorkspaceMode == null ? 43 : ((Object)((Object)$inferenceWorkspaceMode)).hashCode());
            CacheMode $cacheMode = this.getCacheMode();
            result = result * 59 + ($cacheMode == null ? 43 : ((Object)((Object)$cacheMode)).hashCode());
            DataType $dataType = this.getDataType();
            result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
            ConvolutionMode $convolutionMode = this.getConvolutionMode();
            result = result * 59 + ($convolutionMode == null ? 43 : ((Object)((Object)$convolutionMode)).hashCode());
            ConvolutionLayer.AlgoMode $cudnnAlgoMode = this.getCudnnAlgoMode();
            result = result * 59 + ($cudnnAlgoMode == null ? 43 : ((Object)((Object)$cudnnAlgoMode)).hashCode());
            return result;
        }

        public String toString() {
            return "NeuralNetConfiguration.Builder(activationFn=" + this.getActivationFn() + ", weightInitFn=" + this.getWeightInitFn() + ", biasInit=" + this.getBiasInit() + ", gainInit=" + this.getGainInit() + ", regularization=" + this.getRegularization() + ", regularizationBias=" + this.getRegularizationBias() + ", idropOut=" + this.getIdropOut() + ", weightNoise=" + this.getWeightNoise() + ", iUpdater=" + this.getIUpdater() + ", biasUpdater=" + this.getBiasUpdater() + ", layer=" + this.getLayer() + ", miniBatch=" + this.isMiniBatch() + ", maxNumLineSearchIterations=" + this.getMaxNumLineSearchIterations() + ", seed=" + this.getSeed() + ", optimizationAlgo=" + (Object)((Object)this.getOptimizationAlgo()) + ", stepFunction=" + this.getStepFunction() + ", minimize=" + this.isMinimize() + ", gradientNormalization=" + (Object)((Object)this.getGradientNormalization()) + ", gradientNormalizationThreshold=" + this.getGradientNormalizationThreshold() + ", allParamConstraints=" + this.getAllParamConstraints() + ", weightConstraints=" + this.getWeightConstraints() + ", biasConstraints=" + this.getBiasConstraints() + ", trainingWorkspaceMode=" + (Object)((Object)this.getTrainingWorkspaceMode()) + ", inferenceWorkspaceMode=" + (Object)((Object)this.getInferenceWorkspaceMode()) + ", setTWM=" + this.isSetTWM() + ", setIWM=" + this.isSetIWM() + ", cacheMode=" + (Object)((Object)this.getCacheMode()) + ", dataType=" + this.getDataType() + ", convolutionMode=" + (Object)((Object)this.getConvolutionMode()) + ", cudnnAlgoMode=" + (Object)((Object)this.getCudnnAlgoMode()) + ")";
        }
    }

    public static class ListBuilder
    extends MultiLayerConfiguration.Builder {
        private int layerCounter = -1;
        private Map<Integer, Builder> layerwise;
        private Builder globalConfig;

        public ListBuilder(Builder globalConfig, Map<Integer, Builder> layerMap) {
            this.globalConfig = globalConfig;
            this.layerwise = layerMap;
        }

        public ListBuilder(Builder globalConfig) {
            this(globalConfig, new HashMap<Integer, Builder>());
        }

        public ListBuilder layer(int ind, @NonNull Layer layer) {
            if (layer == null) {
                throw new NullPointerException("layer is marked non-null but is null");
            }
            if (this.layerwise.containsKey(ind)) {
                log.info("Layer index {} already exists, layer of type {} will be replace by layer type {}", new Object[]{ind, this.layerwise.get(ind).getClass().getSimpleName(), layer.getClass().getSimpleName()});
                this.layerwise.get(ind).layer(layer);
            } else {
                this.layerwise.put(ind, this.globalConfig.clone().layer(layer));
            }
            if (this.layerCounter < ind) {
                this.layerCounter = ind;
            }
            return this;
        }

        public ListBuilder layer(Layer layer) {
            return this.layer(++this.layerCounter, layer);
        }

        public Map<Integer, Builder> getLayerwise() {
            return this.layerwise;
        }

        @Override
        public ListBuilder setInputType(InputType inputType) {
            return (ListBuilder)super.setInputType(inputType);
        }

        public InputTypeBuilder inputType() {
            return new InputTypeBuilder();
        }

        public List<InputType> getLayerActivationTypes() {
            MultiLayerConfiguration conf;
            Preconditions.checkState((this.inputType != null ? 1 : 0) != 0, (String)"Can only calculate activation types if input type hasbeen set. Use setInputType(InputType)");
            try {
                conf = this.build();
            }
            catch (Exception e) {
                throw new RuntimeException("Error calculating layer activation types: error instantiating MultiLayerConfiguration", e);
            }
            return conf.getLayerActivationTypes(this.inputType);
        }

        @Override
        public MultiLayerConfiguration build() {
            ArrayList<NeuralNetConfiguration> list = new ArrayList<NeuralNetConfiguration>();
            if (this.layerwise.isEmpty()) {
                throw new IllegalStateException("Invalid configuration: no layers defined");
            }
            for (int i = 0; i < this.layerwise.size(); ++i) {
                if (this.layerwise.get(i) == null) {
                    throw new IllegalStateException("Invalid configuration: layer number " + i + " not specified. Expect layer numbers to be 0 to " + (this.layerwise.size() - 1) + " inclusive (number of layers defined: " + this.layerwise.size() + ")");
                }
                if (this.layerwise.get(i).getLayer() == null) {
                    throw new IllegalStateException("Cannot construct network: Layer config forlayer with index " + i + " is not defined)");
                }
                if (this.layerwise.get(i).getLayer().getLayerName() == null) {
                    this.layerwise.get(i).getLayer().setLayerName("layer" + i);
                }
                list.add(this.layerwise.get(i).build());
            }
            WorkspaceMode wsmTrain = this.globalConfig.setTWM ? this.globalConfig.trainingWorkspaceMode : this.trainingWorkspaceMode;
            WorkspaceMode wsmTest = this.globalConfig.setIWM ? this.globalConfig.inferenceWorkspaceMode : this.inferenceWorkspaceMode;
            return new MultiLayerConfiguration.Builder().inputPreProcessors(this.inputPreProcessors).backpropType(this.backpropType).tBPTTForwardLength(this.tbpttFwdLength).tBPTTBackwardLength(this.tbpttBackLength).setInputType(this.inputType).trainingWorkspaceMode(wsmTrain).cacheMode(this.globalConfig.cacheMode).inferenceWorkspaceMode(wsmTest).confs(list).validateOutputLayerConfig(this.validateOutputConfig).dataType(this.globalConfig.dataType).build();
        }

        public class InputTypeBuilder {
            public ListBuilder convolutional(int height, int width, int depth) {
                return ListBuilder.this.setInputType(InputType.convolutional(height, width, depth));
            }

            public ListBuilder convolutionalFlat(int height, int width, int depth) {
                return ListBuilder.this.setInputType(InputType.convolutionalFlat(height, width, depth));
            }

            public ListBuilder feedForward(int size) {
                return ListBuilder.this.setInputType(InputType.feedForward(size));
            }

            public ListBuilder recurrent(int size) {
                return ListBuilder.this.setInputType(InputType.recurrent(size));
            }
        }
    }
}

