/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.earlystopping;

import java.io.Serializable;
import java.util.Map;
import org.deeplearning4j.nn.api.Model;

public class EarlyStoppingResult<T extends Model>
implements Serializable {
    private TerminationReason terminationReason;
    private String terminationDetails;
    private Map<Integer, Double> scoreVsEpoch;
    private int bestModelEpoch;
    private double bestModelScore;
    private int totalEpochs;
    private T bestModel;

    public EarlyStoppingResult(TerminationReason terminationReason, String terminationDetails, Map<Integer, Double> scoreVsEpoch, int bestModelEpoch, double bestModelScore, int totalEpochs, T bestModel) {
        this.terminationReason = terminationReason;
        this.terminationDetails = terminationDetails;
        this.scoreVsEpoch = scoreVsEpoch;
        this.bestModelEpoch = bestModelEpoch;
        this.bestModelScore = bestModelScore;
        this.totalEpochs = totalEpochs;
        this.bestModel = bestModel;
    }

    public String toString() {
        return "EarlyStoppingResult(terminationReason=" + (Object)((Object)this.terminationReason) + ",details=" + this.terminationDetails + ",bestModelEpoch=" + this.bestModelEpoch + ",bestModelScore=" + this.bestModelScore + ",totalEpochs=" + this.totalEpochs + ")";
    }

    public T getBestModel() {
        return this.bestModel;
    }

    public TerminationReason getTerminationReason() {
        return this.terminationReason;
    }

    public String getTerminationDetails() {
        return this.terminationDetails;
    }

    public Map<Integer, Double> getScoreVsEpoch() {
        return this.scoreVsEpoch;
    }

    public int getBestModelEpoch() {
        return this.bestModelEpoch;
    }

    public double getBestModelScore() {
        return this.bestModelScore;
    }

    public int getTotalEpochs() {
        return this.totalEpochs;
    }

    public void setTerminationReason(TerminationReason terminationReason) {
        this.terminationReason = terminationReason;
    }

    public void setTerminationDetails(String terminationDetails) {
        this.terminationDetails = terminationDetails;
    }

    public void setScoreVsEpoch(Map<Integer, Double> scoreVsEpoch) {
        this.scoreVsEpoch = scoreVsEpoch;
    }

    public void setBestModelEpoch(int bestModelEpoch) {
        this.bestModelEpoch = bestModelEpoch;
    }

    public void setBestModelScore(double bestModelScore) {
        this.bestModelScore = bestModelScore;
    }

    public void setTotalEpochs(int totalEpochs) {
        this.totalEpochs = totalEpochs;
    }

    public void setBestModel(T bestModel) {
        this.bestModel = bestModel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EarlyStoppingResult)) {
            return false;
        }
        EarlyStoppingResult other = (EarlyStoppingResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBestModelEpoch() != other.getBestModelEpoch()) {
            return false;
        }
        if (Double.compare(this.getBestModelScore(), other.getBestModelScore()) != 0) {
            return false;
        }
        if (this.getTotalEpochs() != other.getTotalEpochs()) {
            return false;
        }
        TerminationReason this$terminationReason = this.getTerminationReason();
        TerminationReason other$terminationReason = other.getTerminationReason();
        if (this$terminationReason == null ? other$terminationReason != null : !((Object)((Object)this$terminationReason)).equals((Object)other$terminationReason)) {
            return false;
        }
        String this$terminationDetails = this.getTerminationDetails();
        String other$terminationDetails = other.getTerminationDetails();
        if (this$terminationDetails == null ? other$terminationDetails != null : !this$terminationDetails.equals(other$terminationDetails)) {
            return false;
        }
        Map<Integer, Double> this$scoreVsEpoch = this.getScoreVsEpoch();
        Map<Integer, Double> other$scoreVsEpoch = other.getScoreVsEpoch();
        if (this$scoreVsEpoch == null ? other$scoreVsEpoch != null : !((Object)this$scoreVsEpoch).equals(other$scoreVsEpoch)) {
            return false;
        }
        T this$bestModel = this.getBestModel();
        T other$bestModel = other.getBestModel();
        return !(this$bestModel == null ? other$bestModel != null : !this$bestModel.equals(other$bestModel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EarlyStoppingResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBestModelEpoch();
        long $bestModelScore = Double.doubleToLongBits(this.getBestModelScore());
        result = result * 59 + (int)($bestModelScore >>> 32 ^ $bestModelScore);
        result = result * 59 + this.getTotalEpochs();
        TerminationReason $terminationReason = this.getTerminationReason();
        result = result * 59 + ($terminationReason == null ? 43 : ((Object)((Object)$terminationReason)).hashCode());
        String $terminationDetails = this.getTerminationDetails();
        result = result * 59 + ($terminationDetails == null ? 43 : $terminationDetails.hashCode());
        Map<Integer, Double> $scoreVsEpoch = this.getScoreVsEpoch();
        result = result * 59 + ($scoreVsEpoch == null ? 43 : ((Object)$scoreVsEpoch).hashCode());
        T $bestModel = this.getBestModel();
        result = result * 59 + ($bestModel == null ? 43 : $bestModel.hashCode());
        return result;
    }

    public static enum TerminationReason {
        Error,
        IterationTerminationCondition,
        EpochTerminationCondition;

    }
}

