/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidConfigException;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ConvolutionUtils {
    private ConvolutionUtils() {
    }

    public static int[] getOutputSize(INDArray inputData, int[] kernel, int[] strides, int[] padding, ConvolutionMode convolutionMode) {
        int inH = inputData.size(2);
        int inW = inputData.size(3);
        if (convolutionMode != ConvolutionMode.Same && (kernel[0] <= 0 || kernel[0] > inH + 2 * padding[0])) {
            throw new DL4JInvalidInputException("Invalid input data or configuration: kernel height and input height must satisfy 0 < kernel height <= input height + 2 * padding height. \nGot kernel height = " + kernel[0] + ", input height = " + inH + " and padding height = " + padding[0] + " which do not satisfy 0 < " + kernel[0] + " <= " + (inH + 2 * padding[0]) + ConvolutionUtils.getCommonErrorMsg(inputData, kernel, strides, padding));
        }
        if (convolutionMode != ConvolutionMode.Same && (kernel[1] <= 0 || kernel[1] > inW + 2 * padding[1])) {
            throw new DL4JInvalidInputException("Invalid input data or configuration: kernel width and input width must satisfy  0 < kernel width <= input width + 2 * padding width. \nGot kernel width = " + kernel[1] + ", input width = " + inW + " and padding width = " + padding[1] + " which do not satisfy 0 < " + kernel[1] + " <= " + (inW + 2 * padding[1]) + "\nInput size: [numExamples,inputDepth,inputHeight,inputWidth]=" + Arrays.toString(inputData.shape()) + ConvolutionUtils.getCommonErrorMsg(inputData, kernel, strides, padding));
        }
        if (convolutionMode == ConvolutionMode.Strict) {
            if ((inH - kernel[0] + 2 * padding[0]) % strides[0] != 0) {
                double d = (double)(inH - kernel[0] + 2 * padding[0]) / (double)strides[0] + 1.0;
                String str = String.format("%.2f", d);
                int truncated = (int)d;
                int sameSize = (int)Math.ceil((double)inH / (double)strides[0]);
                throw new DL4JInvalidConfigException("Invalid input data or configuration: Combination of kernel size, stride and padding are not valid for given input height, using ConvolutionMode.Strict\nConvolutionMode.Strict requires: output height = (input height - kernelSize + 2*padding)/stride + 1 to be an integer. Got: (" + inH + " - " + kernel[0] + " + 2*" + padding[0] + ")/" + strides[0] + " + 1 = " + str + "\nSee \"Constraints on strides\" at http://cs231n.github.io/convolutional-networks/ and ConvolutionType enumeration Javadoc.\nTo truncate/crop the input, such that output height = floor(" + str + ") = " + truncated + ", use ConvolutionType.Truncate.\nAlternatively use ConvolutionType.Same, which will use padding to give an output height of ceil(" + inH + "/" + strides[0] + ")=" + sameSize + ConvolutionUtils.getCommonErrorMsg(inputData, kernel, strides, padding));
            }
            if ((inW - kernel[1] + 2 * padding[1]) % strides[1] != 0) {
                double d = (double)(inW - kernel[1] + 2 * padding[1]) / (double)strides[1] + 1.0;
                String str = String.format("%.2f", d);
                int truncated = (int)d;
                int sameSize = (int)Math.ceil((double)inW / (double)strides[1]);
                throw new DL4JInvalidConfigException("Invalid input data or configuration: Combination of kernel size, stride and padding are not valid for given input width, using ConvolutionMode.Strict\nConvolutionMode.Strict requires: output width = (input - kernelSize + 2*padding)/stride + 1 to be an integer. Got: (" + inW + " - " + kernel[1] + " + 2*" + padding[1] + ")/" + strides[1] + " + 1 = " + str + "\nSee \"Constraints on strides\" at http://cs231n.github.io/convolutional-networks/ and ConvolutionType enumeration Javadoc.\nTo truncate/crop the input, such that output width = floor(" + str + ") = " + truncated + ", use ConvolutionType.Truncate.\nAlternatively use ConvolutionType.Same, which will use padding to give an output width of ceil(" + inW + "/" + strides[1] + ")=" + sameSize + ConvolutionUtils.getCommonErrorMsg(inputData, kernel, strides, padding));
            }
        } else if (convolutionMode == ConvolutionMode.Same) {
            int outH = (int)Math.ceil((double)inH / (double)strides[0]);
            int outW = (int)Math.ceil((double)inW / (double)strides[1]);
            return new int[]{outH, outW};
        }
        int hOut = (inH - kernel[0] + 2 * padding[0]) / strides[0] + 1;
        int wOut = (inW - kernel[1] + 2 * padding[1]) / strides[1] + 1;
        return new int[]{hOut, wOut};
    }

    private static String getCommonErrorMsg(INDArray inputData, int[] kernel, int[] strides, int[] padding) {
        return "\nInput size: [numExamples,inputDepth,inputHeight,inputWidth]=" + Arrays.toString(inputData.shape()) + ", kernel=" + Arrays.toString(kernel) + ", strides=" + Arrays.toString(strides) + ", padding=" + Arrays.toString(padding);
    }

    public static int[] getSameModeTopLeftPadding(int[] outSize, int[] inSize, int[] kernel, int[] strides) {
        int[] outPad = new int[]{((outSize[0] - 1) * strides[0] + kernel[0] - inSize[0]) / 2, ((outSize[1] - 1) * strides[1] + kernel[1] - inSize[1]) / 2};
        return outPad;
    }

    public static int[] getSameModeBottomRightPadding(int[] outSize, int[] inSize, int[] kernel, int[] strides) {
        int[] outPad = new int[]{((outSize[0] - 1) * strides[0] + kernel[0] - inSize[0] + 1) / 2, ((outSize[1] - 1) * strides[1] + kernel[1] - inSize[1] + 1) / 2};
        return outPad;
    }

    public static int[] getHeightAndWidth(NeuralNetConfiguration conf) {
        return ConvolutionUtils.getHeightAndWidth(((ConvolutionLayer)conf.getLayer()).getKernelSize());
    }

    public static int numFeatureMap(NeuralNetConfiguration conf) {
        return ((ConvolutionLayer)conf.getLayer()).getNOut();
    }

    public static int[] getHeightAndWidth(int[] shape) {
        if (shape.length < 2) {
            throw new IllegalArgumentException("No width and height able to be found: array must be at least length 2");
        }
        return new int[]{shape[shape.length - 1], shape[shape.length - 2]};
    }

    public static int numChannels(int[] shape) {
        if (shape.length < 4) {
            return 1;
        }
        return shape[1];
    }

    public static void validateCnnKernelStridePadding(int[] kernelSize, int[] stride, int[] padding) {
        if (kernelSize == null || kernelSize.length != 2) {
            throw new IllegalStateException("Invalid kernel size: expected int[] of length 2, got " + (kernelSize == null ? null : Arrays.toString(kernelSize)));
        }
        if (stride == null || stride.length != 2) {
            throw new IllegalStateException("Invalid stride configuration: expected int[] of length 2, got " + (stride == null ? null : Arrays.toString(stride)));
        }
        if (padding == null || padding.length != 2) {
            throw new IllegalStateException("Invalid padding configuration: expected int[] of length 2, got " + (padding == null ? null : Arrays.toString(padding)));
        }
        if (kernelSize[0] <= 0 || kernelSize[1] <= 0) {
            throw new IllegalStateException("Invalid kernel size: values must be positive (> 0) for all dimensions. Got: " + Arrays.toString(kernelSize));
        }
        if (stride[0] <= 0 || stride[1] <= 0) {
            throw new IllegalStateException("Invalid stride configuration: values must be positive (> 0) for all dimensions. Got: " + Arrays.toString(stride));
        }
        if (padding[0] < 0 || padding[1] < 0) {
            throw new IllegalStateException("Invalid padding configuration: values must be >= 0 for all dimensions. Got: " + Arrays.toString(padding));
        }
    }
}

