/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class ZeroPaddingLayer
extends AbstractLayer<org.deeplearning4j.nn.conf.layers.ZeroPaddingLayer> {
    private int[] padding;

    public ZeroPaddingLayer(NeuralNetConfiguration conf) {
        super(conf);
        this.padding = ((org.deeplearning4j.nn.conf.layers.ZeroPaddingLayer)conf.getLayer()).getPadding();
    }

    @Override
    public INDArray preOutput(boolean training) {
        return this.activate(training);
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.CONVOLUTIONAL;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        int[] inShape = this.input.shape();
        INDArray epsNext = epsilon.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval((int)this.padding[0], (int)(this.padding[0] + inShape[2])), NDArrayIndex.interval((int)this.padding[2], (int)(this.padding[2] + inShape[3]))});
        return new Pair<Gradient, INDArray>(new DefaultGradient(), epsNext);
    }

    @Override
    public INDArray activationMean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray activate(boolean training) {
        int[] inShape = this.input.shape();
        int outH = inShape[2] + this.padding[0] + this.padding[1];
        int outW = inShape[3] + this.padding[2] + this.padding[3];
        int[] outShape = new int[]{inShape[0], inShape[1], outH, outW};
        INDArray out = Nd4j.create((int[])outShape);
        out.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval((int)this.padding[0], (int)(this.padding[0] + inShape[2])), NDArrayIndex.interval((int)this.padding[2], (int)(this.padding[2] + inShape[3]))}, this.input);
        return out;
    }

    @Override
    public Layer clone() {
        return new ZeroPaddingLayer(this.conf.clone());
    }

    @Override
    public double calcL1(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public double calcL2(boolean backpropParamsOnly) {
        return 0.0;
    }
}

