/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.BasePretrainNetwork;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.params.PretrainParamInitializer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.nd4j.linalg.api.ndarray.INDArray;

public class AutoEncoder
extends BasePretrainNetwork {
    protected double corruptionLevel;
    protected double sparsity;

    private AutoEncoder(Builder builder) {
        super(builder);
        this.corruptionLevel = builder.corruptionLevel;
        this.sparsity = builder.sparsity;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<IterationListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        org.deeplearning4j.nn.layers.feedforward.autoencoder.AutoEncoder ret = new org.deeplearning4j.nn.layers.feedforward.autoencoder.AutoEncoder(conf);
        ret.setListeners(iterationListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return PretrainParamInitializer.getInstance();
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        InputType outputType = this.getOutputType(-1, inputType);
        int actElementsPerEx = outputType.arrayElementsPerExample() + inputType.arrayElementsPerExample();
        int numParams = this.initializer().numParams(this);
        int updaterStateSize = (int)this.getIUpdater().stateSize((long)numParams);
        int trainSizePerEx = 0;
        if (this.getDropOut() > 0.0) {
            trainSizePerEx += inputType.arrayElementsPerExample();
        }
        return new LayerMemoryReport.Builder(this.layerName, AutoEncoder.class, inputType, outputType).standardMemory(numParams, updaterStateSize).workingMemory(0L, 0L, 0L, trainSizePerEx += actElementsPerEx).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    public double getCorruptionLevel() {
        return this.corruptionLevel;
    }

    public double getSparsity() {
        return this.sparsity;
    }

    public void setCorruptionLevel(double corruptionLevel) {
        this.corruptionLevel = corruptionLevel;
    }

    public void setSparsity(double sparsity) {
        this.sparsity = sparsity;
    }

    public AutoEncoder() {
    }

    @Override
    public String toString() {
        return "AutoEncoder(super=" + super.toString() + ", corruptionLevel=" + this.getCorruptionLevel() + ", sparsity=" + this.getSparsity() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoEncoder)) {
            return false;
        }
        AutoEncoder other = (AutoEncoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Double.compare(this.getCorruptionLevel(), other.getCorruptionLevel()) != 0) {
            return false;
        }
        return Double.compare(this.getSparsity(), other.getSparsity()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AutoEncoder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        long $corruptionLevel = Double.doubleToLongBits(this.getCorruptionLevel());
        result = result * 59 + (int)($corruptionLevel >>> 32 ^ $corruptionLevel);
        long $sparsity = Double.doubleToLongBits(this.getSparsity());
        result = result * 59 + (int)($sparsity >>> 32 ^ $sparsity);
        return result;
    }

    public static class Builder
    extends BasePretrainNetwork.Builder<Builder> {
        private double corruptionLevel = 0.3f;
        private double sparsity = 0.0;

        public Builder() {
        }

        public Builder(double corruptionLevel) {
            this.corruptionLevel = corruptionLevel;
        }

        public Builder corruptionLevel(double corruptionLevel) {
            this.corruptionLevel = corruptionLevel;
            return this;
        }

        public Builder sparsity(double sparsity) {
            this.sparsity = sparsity;
            return this;
        }

        @Override
        public AutoEncoder build() {
            return new AutoEncoder(this);
        }

        @ConstructorProperties(value={"corruptionLevel", "sparsity"})
        public Builder(double corruptionLevel, double sparsity) {
            this.corruptionLevel = corruptionLevel;
            this.sparsity = sparsity;
        }
    }
}

