/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.preprocessor;

import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;

public class RnnToFeedForwardPreProcessor
implements InputPreProcessor {
    @Override
    public INDArray preProcess(INDArray input, int miniBatchSize) {
        int[] shape;
        if (input.rank() != 3) {
            throw new IllegalArgumentException("Invalid input: expect NDArray with rank 3 (i.e., activations for RNN layer)");
        }
        if (input.ordering() != 'f') {
            input = input.dup('f');
        }
        if ((shape = input.shape())[0] == 1) {
            return input.tensorAlongDimension(0, new int[]{1, 2}).permutei(new int[]{1, 0});
        }
        if (shape[2] == 1) {
            return input.tensorAlongDimension(0, new int[]{1, 0});
        }
        INDArray permuted = input.permute(new int[]{0, 2, 1});
        return permuted.reshape('f', shape[0] * shape[2], shape[1]);
    }

    @Override
    public INDArray backprop(INDArray output, int miniBatchSize) {
        if (output == null) {
            return null;
        }
        if (output.rank() != 2) {
            throw new IllegalArgumentException("Invalid input: expect NDArray with rank 2 (i.e., epsilons from feed forward layer)");
        }
        if (output.ordering() == 'c') {
            output = Shape.toOffsetZeroCopy((INDArray)output, (char)'f');
        }
        int[] shape = output.shape();
        INDArray reshaped = output.reshape('f', new int[]{miniBatchSize, shape[0] / miniBatchSize, shape[1]});
        return reshaped.permute(new int[]{0, 2, 1});
    }

    @Override
    public RnnToFeedForwardPreProcessor clone() {
        try {
            RnnToFeedForwardPreProcessor clone = (RnnToFeedForwardPreProcessor)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputType getOutputType(InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.RNN) {
            throw new IllegalStateException("Invalid input: expected input of type RNN, got " + inputType);
        }
        InputType.InputTypeRecurrent rnn = (InputType.InputTypeRecurrent)inputType;
        return InputType.feedForward(rnn.getSize());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RnnToFeedForwardPreProcessor)) {
            return false;
        }
        RnnToFeedForwardPreProcessor other = (RnnToFeedForwardPreProcessor)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RnnToFeedForwardPreProcessor;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "RnnToFeedForwardPreProcessor()";
    }
}

