/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.preprocessor.CnnToFeedForwardPreProcessor;
import org.deeplearning4j.nn.conf.preprocessor.RnnToFeedForwardPreProcessor;

public abstract class FeedForwardLayer
extends Layer {
    protected int nIn;
    protected int nOut;

    public FeedForwardLayer(Builder builder) {
        super(builder);
        this.nIn = builder.nIn;
        this.nOut = builder.nOut;
    }

    @Override
    public InputType getOutputType(InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.FF && inputType.getType() != InputType.Type.CNNFlat) {
            throw new IllegalStateException("Invalid input type (layer name=\"" + this.getLayerName() + "\"): expected FeedForward input type. Got: " + inputType);
        }
        return InputType.feedForward(this.nOut);
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
        if (inputType == null || inputType.getType() != InputType.Type.FF && inputType.getType() != InputType.Type.CNNFlat) {
            throw new IllegalStateException("Invalid input type (layer name=\"" + this.getLayerName() + "\"): expected FeedForward input type. Got: " + inputType);
        }
        if (this.nIn <= 0 || override) {
            if (inputType.getType() == InputType.Type.FF) {
                InputType.InputTypeFeedForward f = (InputType.InputTypeFeedForward)inputType;
                this.nIn = f.getSize();
            } else {
                InputType.InputTypeConvolutionalFlat f = (InputType.InputTypeConvolutionalFlat)inputType;
                this.nIn = f.getFlattenedSize();
            }
        }
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for layer (layer name = \"" + this.getLayerName() + "\"): input type is null");
        }
        switch (inputType.getType()) {
            case FF: 
            case CNNFlat: {
                return null;
            }
            case RNN: {
                return new RnnToFeedForwardPreProcessor();
            }
            case CNN: {
                InputType.InputTypeConvolutional c = (InputType.InputTypeConvolutional)inputType;
                return new CnnToFeedForwardPreProcessor(c.getHeight(), c.getWidth(), c.getDepth());
            }
        }
        throw new RuntimeException("Unknown input type: " + inputType);
    }

    @Override
    public double getL1ByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.l1;
            }
            case "b": {
                return 0.0;
            }
        }
        throw new IllegalStateException("Unknown parameter: \"" + paramName + "\"");
    }

    @Override
    public double getL2ByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.l2;
            }
            case "b": {
                return 0.0;
            }
        }
        throw new IllegalStateException("Unknown parameter: \"" + paramName + "\"");
    }

    @Override
    public double getLearningRateByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.learningRate;
            }
            case "b": {
                if (!Double.isNaN(this.biasLearningRate)) {
                    return this.biasLearningRate;
                }
                return this.learningRate;
            }
        }
        throw new IllegalStateException("Unknown parameter: \"" + paramName + "\"");
    }

    public int getNIn() {
        return this.nIn;
    }

    public int getNOut() {
        return this.nOut;
    }

    public void setNIn(int nIn) {
        this.nIn = nIn;
    }

    public void setNOut(int nOut) {
        this.nOut = nOut;
    }

    public FeedForwardLayer() {
    }

    @Override
    public String toString() {
        return "FeedForwardLayer(super=" + super.toString() + ", nIn=" + this.getNIn() + ", nOut=" + this.getNOut() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeedForwardLayer)) {
            return false;
        }
        FeedForwardLayer other = (FeedForwardLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getNIn() != other.getNIn()) {
            return false;
        }
        return this.getNOut() == other.getNOut();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FeedForwardLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + this.getNIn();
        result = result * 59 + this.getNOut();
        return result;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Layer.Builder<T> {
        protected int nIn = 0;
        protected int nOut = 0;

        public T nIn(int nIn) {
            this.nIn = nIn;
            return (T)this;
        }

        public T nOut(int nOut) {
            this.nOut = nOut;
            return (T)this;
        }
    }
}

